/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlgraphics.xmp.XMPArrayType;
import org.apache.xmlgraphics.xmp.XMPComplexValue;
import org.apache.xmlgraphics.xmp.XMPProperty;
import org.apache.xmlgraphics.xmp.XMPStructure;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMPArray
extends XMPComplexValue {
    private XMPArrayType type;
    private List values = new ArrayList();
    private List xmllang = new ArrayList();
    private List<String> parseTypes = new ArrayList<String>();

    public XMPArray(XMPArrayType type) {
        this.type = type;
    }

    public XMPArrayType getType() {
        return this.type;
    }

    public Object getValue(int idx) {
        return this.values.get(idx);
    }

    public XMPStructure getStructure(int idx) {
        return (XMPStructure)this.values.get(idx);
    }

    @Override
    public Object getSimpleValue() {
        if (this.values.size() == 1) {
            return this.getValue(0);
        }
        if (this.values.size() > 1) {
            return this.getLangValue("x-default");
        }
        return null;
    }

    private String getParentLanguage(String lang) {
        if (lang == null) {
            return null;
        }
        int pos = lang.indexOf(45);
        if (pos > 0) {
            String parent = lang.substring(0, pos);
            return parent;
        }
        return null;
    }

    public String getLangValue(String lang) {
        String v2 = null;
        String valueForParentLanguage = null;
        int c2 = this.values.size();
        for (int i2 = 0; i2 < c2; ++i2) {
            String parent;
            String l2 = (String)this.xmllang.get(i2);
            if (l2 == null && lang == null || l2 != null && l2.equals(lang)) {
                v2 = this.values.get(i2).toString();
                break;
            }
            if (l2 == null || lang == null || (parent = this.getParentLanguage(l2)) == null || !parent.equals(lang)) continue;
            valueForParentLanguage = this.values.get(i2).toString();
        }
        if (lang != null && v2 == null && valueForParentLanguage != null) {
            v2 = valueForParentLanguage;
        }
        if (lang == null && v2 == null && (v2 = this.getLangValue("x-default")) == null && this.values.size() > 0) {
            v2 = this.getValue(0).toString();
        }
        return v2;
    }

    public String removeLangValue(String lang) {
        if (lang == null || "".equals(lang)) {
            lang = "x-default";
        }
        int c2 = this.values.size();
        for (int i2 = 0; i2 < c2; ++i2) {
            String l2 = (String)this.xmllang.get(i2);
            if ((!"x-default".equals(lang) || l2 != null) && !lang.equals(l2)) continue;
            String value = (String)this.values.remove(i2);
            this.xmllang.remove(i2);
            return value;
        }
        return null;
    }

    public void add(Object value, String lang, String parseType) {
        this.values.add(value);
        this.xmllang.add(lang);
        this.parseTypes.add(parseType);
    }

    public void add(Object value, String lang) {
        this.add(value, lang, null);
    }

    public void add(Object value) {
        this.add(value, null, null);
    }

    public boolean remove(String value) {
        int idx = this.values.indexOf(value);
        if (idx >= 0) {
            this.values.remove(idx);
            this.xmllang.remove(idx);
            this.parseTypes.remove(idx);
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public Object[] toObjectArray() {
        Object[] res = new Object[this.getSize()];
        int c2 = res.length;
        for (int i2 = 0; i2 < c2; ++i2) {
            res[i2] = this.getValue(i2);
        }
        return res;
    }

    @Override
    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        handler.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", this.type.getName(), "rdf:" + this.type.getName(), atts);
        int c2 = this.values.size();
        for (int i2 = 0; i2 < c2; ++i2) {
            String parseType;
            String lang = (String)this.xmllang.get(i2);
            atts.clear();
            Object v2 = this.values.get(i2);
            if (lang != null) {
                atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", lang);
            }
            if (v2 instanceof URI) {
                atts.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", "rdf:resource", "CDATA", ((URI)v2).toString());
            }
            if ((parseType = this.parseTypes.get(i2)) != null) {
                atts.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", "rdf:parseType", "CDATA", parseType);
            }
            handler.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "li", "rdf:li", atts);
            if (v2 instanceof XMPComplexValue) {
                ((XMPComplexValue)v2).toSAX(handler);
            } else if (v2 instanceof XMPProperty) {
                XMPProperty prop = (XMPProperty)v2;
                prop.toSAX(handler);
            } else if (v2 instanceof List) {
                List list = (List)v2;
                for (XMPProperty prop : list) {
                    prop.toSAX(handler);
                }
            } else if (!(v2 instanceof URI)) {
                String value = (String)this.values.get(i2);
                char[] chars = value.toCharArray();
                handler.characters(chars, 0, chars.length);
            }
            handler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "li", "rdf:li");
        }
        handler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", this.type.getName(), "rdf:" + this.type.getName());
    }

    public String toString() {
        return "XMP array: " + this.type + ", " + this.getSize();
    }
}

