/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.values;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.GDate;
import org.apache.xmlbeans.GDateSpecification;
import org.apache.xmlbeans.GDuration;
import org.apache.xmlbeans.GDurationSpecification;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.StringEnumAbstractBase;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.ValidationContext;
import org.apache.xmlbeans.impl.schema.SchemaTypeImpl;
import org.apache.xmlbeans.impl.values.NamespaceContext;
import org.apache.xmlbeans.impl.values.NamespaceManager;
import org.apache.xmlbeans.impl.values.XmlObjectBase;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;

public class XmlUnionImpl
extends XmlObjectBase
implements XmlAnySimpleType {
    private SchemaType _schemaType;
    private XmlAnySimpleType _value;
    private String _textvalue = "";
    private static final int JAVA_NUMBER = 47;
    private static final int JAVA_DATE = 48;
    private static final int JAVA_CALENDAR = 49;
    private static final int JAVA_BYTEARRAY = 50;
    private static final int JAVA_LIST = 51;

    public XmlUnionImpl(SchemaType type, boolean complex) {
        this._schemaType = type;
        this.initComplexType(complex, false);
    }

    @Override
    public SchemaType schemaType() {
        return this._schemaType;
    }

    @Override
    public SchemaType instanceType() {
        this.check_dated();
        return this._value == null ? null : ((SimpleValue)((Object)this._value)).instanceType();
    }

    @Override
    protected String compute_text(NamespaceManager nsm) {
        return this._textvalue;
    }

    @Override
    protected boolean is_defaultable_ws(String v2) {
        try {
            XmlAnySimpleType savedValue = this._value;
            this.set_text(v2);
            this._value = savedValue;
            return false;
        }
        catch (XmlValueOutOfRangeException e2) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void set_text(String s2) {
        if (!this._schemaType.matchPatternFacet(s2) && this._validateOnSet()) {
            throw new XmlValueOutOfRangeException("cvc-datatype-valid.1.1", new Object[]{"string", s2, QNameHelper.readable(this._schemaType)});
        }
        String original = this._textvalue;
        this._textvalue = s2;
        SchemaType[] members = this._schemaType.getUnionConstituentTypes();
        assert (members != null);
        boolean pushed = false;
        if (this.has_store()) {
            NamespaceContext.push(new NamespaceContext(this.get_store()));
            pushed = true;
        }
        try {
            boolean validate = true;
            while (validate || !this._validateOnSet()) {
                for (int i2 = 0; i2 < members.length; ++i2) {
                    try {
                        XmlAnySimpleType newval = ((SchemaTypeImpl)members[i2]).newValue(s2, validate);
                        if (!XmlUnionImpl.check(newval, this._schemaType)) continue;
                        this._value = newval;
                        return;
                    }
                    catch (XmlValueOutOfRangeException e2) {
                        continue;
                    }
                    catch (Exception e3) {
                        throw new RuntimeException("Troublesome union exception caused by unexpected " + e3, e3);
                    }
                }
                if (!validate) {
                    break;
                }
                validate = false;
            }
        }
        finally {
            if (pushed) {
                NamespaceContext.pop();
            }
        }
        this._textvalue = original;
        throw new XmlValueOutOfRangeException("cvc-datatype-valid.1.2.3", new Object[]{s2, QNameHelper.readable(this._schemaType)});
    }

    @Override
    protected void set_nil() {
        this._value = null;
        this._textvalue = null;
    }

    @Override
    protected int get_wscanon_rule() {
        return 1;
    }

    @Override
    public float getFloatValue() {
        this.check_dated();
        return this._value == null ? 0.0f : ((SimpleValue)((Object)this._value)).getFloatValue();
    }

    @Override
    public double getDoubleValue() {
        this.check_dated();
        return this._value == null ? 0.0 : ((SimpleValue)((Object)this._value)).getDoubleValue();
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        this.check_dated();
        return this._value == null ? null : ((SimpleValue)((Object)this._value)).getBigDecimalValue();
    }

    @Override
    public BigInteger getBigIntegerValue() {
        this.check_dated();
        return this._value == null ? null : ((SimpleValue)((Object)this._value)).getBigIntegerValue();
    }

    @Override
    public byte getByteValue() {
        this.check_dated();
        return this._value == null ? (byte)0 : ((SimpleValue)((Object)this._value)).getByteValue();
    }

    @Override
    public short getShortValue() {
        this.check_dated();
        return this._value == null ? (short)0 : ((SimpleValue)((Object)this._value)).getShortValue();
    }

    @Override
    public int getIntValue() {
        this.check_dated();
        return this._value == null ? 0 : ((SimpleValue)((Object)this._value)).getIntValue();
    }

    @Override
    public long getLongValue() {
        this.check_dated();
        return this._value == null ? 0L : ((SimpleValue)((Object)this._value)).getLongValue();
    }

    @Override
    public byte[] getByteArrayValue() {
        this.check_dated();
        return this._value == null ? null : ((SimpleValue)((Object)this._value)).getByteArrayValue();
    }

    @Override
    public boolean getBooleanValue() {
        this.check_dated();
        return this._value == null ? false : ((SimpleValue)((Object)this._value)).getBooleanValue();
    }

    @Override
    public Calendar getCalendarValue() {
        this.check_dated();
        return this._value == null ? null : ((SimpleValue)((Object)this._value)).getCalendarValue();
    }

    @Override
    public Date getDateValue() {
        this.check_dated();
        return this._value == null ? null : ((SimpleValue)((Object)this._value)).getDateValue();
    }

    @Override
    public GDate getGDateValue() {
        this.check_dated();
        return this._value == null ? null : ((SimpleValue)((Object)this._value)).getGDateValue();
    }

    @Override
    public GDuration getGDurationValue() {
        this.check_dated();
        return this._value == null ? null : ((SimpleValue)((Object)this._value)).getGDurationValue();
    }

    @Override
    public QName getQNameValue() {
        this.check_dated();
        return this._value == null ? null : ((SimpleValue)((Object)this._value)).getQNameValue();
    }

    @Override
    public List getListValue() {
        this.check_dated();
        return this._value == null ? null : ((SimpleValue)((Object)this._value)).getListValue();
    }

    @Override
    public List xgetListValue() {
        this.check_dated();
        return this._value == null ? null : ((SimpleValue)((Object)this._value)).xgetListValue();
    }

    @Override
    public StringEnumAbstractBase getEnumValue() {
        this.check_dated();
        return this._value == null ? null : ((SimpleValue)((Object)this._value)).getEnumValue();
    }

    @Override
    public String getStringValue() {
        this.check_dated();
        return this._value == null ? null : this._value.getStringValue();
    }

    static boolean lexical_overlap(int source, int target) {
        if (source == target) {
            return true;
        }
        if (source == 2 || target == 2 || source == 12 || target == 12 || source == 6 || target == 6) {
            return true;
        }
        switch (source) {
            case 3: {
                switch (target) {
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
            case 4: {
                switch (target) {
                    case 3: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 18: {
                        return true;
                    }
                }
                return false;
            }
            case 5: {
                switch (target) {
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 18: {
                        return true;
                    }
                }
                return false;
            }
            case 7: 
            case 8: {
                switch (target) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 13: {
                        return true;
                    }
                }
                return false;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: {
                switch (target) {
                    case 4: 
                    case 5: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 18: {
                        return true;
                    }
                }
                return false;
            }
            case 13: {
                switch (target) {
                    case 4: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private static boolean logical_overlap(SchemaType type, int javacode) {
        assert (type.getSimpleVariety() != 2);
        if (javacode <= 46) {
            if (type.getSimpleVariety() != 1) {
                return false;
            }
            return type.getPrimitiveType().getBuiltinTypeCode() == javacode;
        }
        switch (javacode) {
            case 47: {
                if (type.getSimpleVariety() != 1) {
                    return false;
                }
                switch (type.getPrimitiveType().getBuiltinTypeCode()) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 18: 
                    case 20: 
                    case 21: {
                        return true;
                    }
                }
                return false;
            }
            case 48: {
                if (type.getSimpleVariety() != 1) {
                    return false;
                }
                switch (type.getPrimitiveType().getBuiltinTypeCode()) {
                    case 14: 
                    case 16: {
                        return true;
                    }
                }
                return false;
            }
            case 49: {
                if (type.getSimpleVariety() != 1) {
                    return false;
                }
                switch (type.getPrimitiveType().getBuiltinTypeCode()) {
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: {
                        return true;
                    }
                }
                return false;
            }
            case 50: {
                if (type.getSimpleVariety() != 1) {
                    return false;
                }
                switch (type.getPrimitiveType().getBuiltinTypeCode()) {
                    case 4: 
                    case 5: {
                        return true;
                    }
                }
                return false;
            }
            case 51: {
                return type.getSimpleVariety() == 3;
            }
        }
        assert (false) : "missing case";
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void set_primitive(int typecode, Object val) {
        SchemaType[] members = this._schemaType.getUnionConstituentTypes();
        assert (members != null);
        boolean pushed = false;
        if (this.has_store()) {
            NamespaceContext.push(new NamespaceContext(this.get_store()));
            pushed = true;
        }
        try {
            boolean validate = true;
            while (validate || !this._validateOnSet()) {
                for (int i2 = 0; i2 < members.length; ++i2) {
                    XmlAnySimpleType newval;
                    if (!XmlUnionImpl.logical_overlap(members[i2], typecode)) continue;
                    try {
                        newval = ((SchemaTypeImpl)members[i2]).newValue(val, validate);
                    }
                    catch (XmlValueOutOfRangeException e2) {
                        continue;
                    }
                    catch (Exception e3) {
                        assert (false) : "Unexpected " + e3;
                        continue;
                    }
                    this._value = newval;
                    this._textvalue = this._value.stringValue();
                    return;
                }
                if (!validate) {
                    break;
                }
                validate = false;
            }
        }
        finally {
            if (pushed) {
                NamespaceContext.pop();
            }
        }
        throw new XmlValueOutOfRangeException("cvc-datatype-valid.1.2.3", new Object[]{val.toString(), QNameHelper.readable(this._schemaType)});
    }

    @Override
    protected void set_boolean(boolean v2) {
        this.set_primitive(3, new Boolean(v2));
    }

    @Override
    protected void set_byte(byte v2) {
        this.set_primitive(47, new Byte(v2));
    }

    @Override
    protected void set_short(short v2) {
        this.set_primitive(47, new Short(v2));
    }

    @Override
    protected void set_int(int v2) {
        this.set_primitive(47, new Integer(v2));
    }

    @Override
    protected void set_long(long v2) {
        this.set_primitive(47, new Long(v2));
    }

    @Override
    protected void set_float(float v2) {
        this.set_primitive(47, new Float(v2));
    }

    @Override
    protected void set_double(double v2) {
        this.set_primitive(47, new Double(v2));
    }

    @Override
    protected void set_ByteArray(byte[] b2) {
        this.set_primitive(50, b2);
    }

    @Override
    protected void set_hex(byte[] b2) {
        this.set_primitive(50, b2);
    }

    @Override
    protected void set_b64(byte[] b2) {
        this.set_primitive(50, b2);
    }

    @Override
    protected void set_BigInteger(BigInteger v2) {
        this.set_primitive(47, v2);
    }

    @Override
    protected void set_BigDecimal(BigDecimal v2) {
        this.set_primitive(47, v2);
    }

    @Override
    protected void set_QName(QName v2) {
        this.set_primitive(7, v2);
    }

    @Override
    protected void set_Calendar(Calendar c2) {
        this.set_primitive(49, c2);
    }

    @Override
    protected void set_Date(Date d2) {
        this.set_primitive(48, d2);
    }

    @Override
    protected void set_GDate(GDateSpecification d2) {
        int btc = d2.getBuiltinTypeCode();
        if (btc <= 0) {
            throw new XmlValueOutOfRangeException();
        }
        this.set_primitive(btc, d2);
    }

    @Override
    protected void set_GDuration(GDurationSpecification d2) {
        this.set_primitive(13, d2);
    }

    @Override
    protected void set_enum(StringEnumAbstractBase e2) {
        this.set_primitive(12, e2);
    }

    @Override
    protected void set_list(List v2) {
        this.set_primitive(51, v2);
    }

    protected void set_xmlfloat(XmlObject v2) {
        this.set_primitive(9, v2);
    }

    protected void set_xmldouble(XmlObject v2) {
        this.set_primitive(10, v2);
    }

    protected void set_xmldecimal(XmlObject v2) {
        this.set_primitive(11, v2);
    }

    protected void set_xmlduration(XmlObject v2) {
        this.set_primitive(13, v2);
    }

    protected void set_xmldatetime(XmlObject v2) {
        this.set_primitive(14, v2);
    }

    protected void set_xmltime(XmlObject v2) {
        this.set_primitive(15, v2);
    }

    protected void set_xmldate(XmlObject v2) {
        this.set_primitive(16, v2);
    }

    protected void set_xmlgyearmonth(XmlObject v2) {
        this.set_primitive(17, v2);
    }

    protected void set_xmlgyear(XmlObject v2) {
        this.set_primitive(18, v2);
    }

    protected void set_xmlgmonthday(XmlObject v2) {
        this.set_primitive(19, v2);
    }

    protected void set_xmlgday(XmlObject v2) {
        this.set_primitive(20, v2);
    }

    protected void set_xmlgmonth(XmlObject v2) {
        this.set_primitive(21, v2);
    }

    private static boolean check(XmlObject v2, SchemaType sType) {
        XmlAnySimpleType[] vals = sType.getEnumerationValues();
        if (vals != null) {
            for (int i2 = 0; i2 < vals.length; ++i2) {
                if (!vals[i2].valueEquals(v2)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected boolean equal_to(XmlObject xmlobj) {
        return this._value.valueEquals(xmlobj);
    }

    @Override
    protected int value_hash_code() {
        return this._value.hashCode();
    }

    @Override
    protected void validate_simpleval(String lexical, ValidationContext ctx) {
        try {
            this.check_dated();
        }
        catch (Exception e2) {
            ctx.invalid("union", new Object[]{"'" + lexical + "' does not match any of the member types for " + QNameHelper.readable(this.schemaType())});
            return;
        }
        if (this._value == null) {
            ctx.invalid("union", new Object[]{"'" + lexical + "' does not match any of the member types for " + QNameHelper.readable(this.schemaType())});
            return;
        }
        ((XmlObjectBase)((Object)this._value)).validate_simpleval(lexical, ctx);
    }
}

