/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.tool;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.impl.common.IOUtil;

public class CommandLine {
    private Map _options;
    private String[] _badopts;
    private String[] _args;
    private List _files;
    private List _urls;
    private File _baseDir;
    private static final File[] EMPTY_FILEARRAY = new File[0];
    private static final URL[] EMPTY_URLARRAY = new URL[0];

    public CommandLine(String[] args, Collection flags, Collection scheme) {
        if (flags == null || scheme == null) {
            throw new IllegalArgumentException("collection required (use Collections.EMPTY_SET if no options)");
        }
        this._options = new LinkedHashMap();
        ArrayList<String> badopts = new ArrayList<String>();
        ArrayList<String> endargs = new ArrayList<String>();
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].indexOf(45) == 0) {
                String opt = args[i2].substring(1);
                String val = null;
                if (flags.contains(opt)) {
                    val = "";
                } else if (scheme.contains(opt)) {
                    val = i2 + 1 < args.length ? args[++i2] : "";
                } else {
                    badopts.add(args[i2]);
                }
                this._options.put(opt, val);
                continue;
            }
            endargs.add(args[i2]);
        }
        this._badopts = badopts.toArray(new String[badopts.size()]);
        this._args = endargs.toArray(new String[endargs.size()]);
    }

    public static void printLicense() {
        try {
            IOUtil.copyCompletely(CommandLine.class.getClassLoader().getResourceAsStream("LICENSE.txt"), System.out);
        }
        catch (Exception e2) {
            System.out.println("License available in this JAR in LICENSE.txt");
        }
    }

    public static void printVersion() {
        System.out.println(XmlBeans.getVendor() + ", " + XmlBeans.getTitle() + ".XmlBeans version " + XmlBeans.getVersion());
    }

    public String[] args() {
        String[] result = new String[this._args.length];
        System.arraycopy(this._args, 0, result, 0, this._args.length);
        return result;
    }

    public String[] getBadOpts() {
        return this._badopts;
    }

    public String getOpt(String opt) {
        return (String)this._options.get(opt);
    }

    private static List collectFiles(File[] dirs) {
        ArrayList<File> files = new ArrayList<File>();
        for (int i2 = 0; i2 < dirs.length; ++i2) {
            File f2 = dirs[i2];
            if (!f2.isDirectory()) {
                files.add(f2);
                continue;
            }
            files.addAll(CommandLine.collectFiles(f2.listFiles()));
        }
        return files;
    }

    private List getFileList() {
        if (this._files == null) {
            String[] args = this.args();
            File[] files = new File[args.length];
            boolean noBaseDir = false;
            for (int i2 = 0; i2 < args.length; ++i2) {
                files[i2] = new File(args[i2]);
                if (!noBaseDir && this._baseDir == null) {
                    if (files[i2].isDirectory()) {
                        this._baseDir = files[i2];
                        continue;
                    }
                    this._baseDir = files[i2].getParentFile();
                    continue;
                }
                URI currUri = files[i2].toURI();
                if (this._baseDir == null || !this._baseDir.toURI().relativize(currUri).equals(currUri)) continue;
                this._baseDir = null;
                noBaseDir = true;
            }
            this._files = Collections.unmodifiableList(CommandLine.collectFiles(files));
        }
        return this._files;
    }

    private List getUrlList() {
        if (this._urls == null) {
            String[] args = this.args();
            ArrayList<URL> urls = new ArrayList<URL>();
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (!CommandLine.looksLikeURL(args[i2])) continue;
                try {
                    urls.add(new URL(args[i2]));
                    continue;
                }
                catch (MalformedURLException mfEx) {
                    System.err.println("ignoring invalid url: " + args[i2] + ": " + mfEx.getMessage());
                }
            }
            this._urls = Collections.unmodifiableList(urls);
        }
        return this._urls;
    }

    private static boolean looksLikeURL(String str) {
        return str.startsWith("http:") || str.startsWith("https:") || str.startsWith("ftp:") || str.startsWith("file:");
    }

    public URL[] getURLs() {
        return this.getUrlList().toArray(EMPTY_URLARRAY);
    }

    public File[] getFiles() {
        return this.getFileList().toArray(EMPTY_FILEARRAY);
    }

    public File getBaseDir() {
        return this._baseDir;
    }

    public File[] filesEndingWith(String ext) {
        ArrayList<File> result = new ArrayList<File>();
        for (File f2 : this.getFileList()) {
            if (!f2.getName().endsWith(ext) || CommandLine.looksLikeURL(f2.getPath())) continue;
            result.add(f2);
        }
        return result.toArray(EMPTY_FILEARRAY);
    }
}

