/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.jam.internal;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.apache.xmlbeans.impl.jam.provider.JamLogger;

public class JamLoggerImpl
implements JamLogger {
    private boolean mShowWarnings = true;
    private Set mVerboseClasses = null;
    private PrintWriter mOut = new PrintWriter(System.out, true);

    protected void setOut(PrintWriter out) {
        this.mOut = out;
    }

    @Override
    public boolean isVerbose(Object o2) {
        if (this.mVerboseClasses == null) {
            return false;
        }
        for (Class c2 : this.mVerboseClasses) {
            if (!c2.isAssignableFrom(o2.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVerbose(Class aClass) {
        if (this.mVerboseClasses == null) {
            return false;
        }
        for (Class c2 : this.mVerboseClasses) {
            if (!c2.isAssignableFrom(aClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setVerbose(Class c2) {
        if (c2 == null) {
            throw new IllegalArgumentException();
        }
        if (this.mVerboseClasses == null) {
            this.mVerboseClasses = new HashSet();
        }
        this.mVerboseClasses.add(c2);
    }

    @Override
    public void setShowWarnings(boolean b2) {
        this.mShowWarnings = b2;
    }

    @Override
    public void verbose(String msg, Object o2) {
        if (this.isVerbose(o2)) {
            this.verbose(msg);
        }
    }

    @Override
    public void verbose(Throwable t2, Object o2) {
        if (this.isVerbose(o2)) {
            this.verbose(t2);
        }
    }

    @Override
    public void verbose(String msg) {
        this.printVerbosePrefix();
        this.mOut.println(msg);
    }

    @Override
    public void verbose(Throwable t2) {
        this.printVerbosePrefix();
        this.mOut.println();
        t2.printStackTrace(this.mOut);
    }

    @Override
    public void warning(Throwable t2) {
        if (this.mShowWarnings) {
            this.mOut.println("[JAM] Warning: unexpected exception thrown: ");
            t2.printStackTrace();
        }
    }

    @Override
    public void warning(String w2) {
        if (this.mShowWarnings) {
            this.mOut.print("[JAM] Warning: ");
            this.mOut.println(w2);
        }
    }

    @Override
    public void error(Throwable t2) {
        this.mOut.println("[JAM] Error: unexpected exception thrown: ");
        t2.printStackTrace(this.mOut);
    }

    @Override
    public void error(String msg) {
        this.mOut.print("[JAM] Error: ");
        this.mOut.println(msg);
    }

    public void setVerbose(boolean v2) {
        this.setVerbose(Object.class);
    }

    @Override
    public boolean isVerbose() {
        return this.mVerboseClasses != null;
    }

    private void printVerbosePrefix() {
        StackTraceElement[] st = new Exception().getStackTrace();
        this.mOut.println("[JAM] Verbose: ");
        this.mOut.print('(');
        this.mOut.print(JamLoggerImpl.shortName(st[2].getClassName()));
        this.mOut.print('.');
        this.mOut.print(st[2].getMethodName());
        this.mOut.print(':');
        this.mOut.print(st[2].getLineNumber());
        this.mOut.print(")  ");
    }

    private static String shortName(String className) {
        int index = className.lastIndexOf(46);
        if (index != -1) {
            className = className.substring(index + 1, className.length());
        }
        return className;
    }
}

