/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.config;

import org.apache.xmlbeans.InterfaceExtension;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.config.BindingConfigImpl;
import org.apache.xmlbeans.impl.config.NameSet;
import org.apache.xmlbeans.impl.jam.JClass;
import org.apache.xmlbeans.impl.jam.JMethod;
import org.apache.xmlbeans.impl.jam.JParameter;
import org.apache.xmlbeans.impl.jam.JamClassLoader;
import org.apache.xmlbeans.impl.xb.xmlconfig.Extensionconfig;

public class InterfaceExtensionImpl
implements InterfaceExtension {
    private NameSet _xbeanSet;
    private String _interfaceClassName;
    private String _delegateToClassName;
    private MethodSignatureImpl[] _methods;

    static InterfaceExtensionImpl newInstance(JamClassLoader loader, NameSet xbeanSet, Extensionconfig.Interface intfXO) {
        InterfaceExtensionImpl result = new InterfaceExtensionImpl();
        result._xbeanSet = xbeanSet;
        JClass interfaceJClass = InterfaceExtensionImpl.validateInterface(loader, intfXO.getName(), intfXO);
        if (interfaceJClass == null) {
            BindingConfigImpl.error("Interface '" + intfXO.getStaticHandler() + "' not found.", intfXO);
            return null;
        }
        result._interfaceClassName = interfaceJClass.getQualifiedName();
        result._delegateToClassName = intfXO.getStaticHandler();
        JClass delegateJClass = InterfaceExtensionImpl.validateClass(loader, result._delegateToClassName, intfXO);
        if (delegateJClass == null) {
            BindingConfigImpl.warning("Handler class '" + intfXO.getStaticHandler() + "' not found on classpath, skip validation.", intfXO);
            return result;
        }
        if (!result.validateMethods(interfaceJClass, delegateJClass, intfXO)) {
            return null;
        }
        return result;
    }

    private static JClass validateInterface(JamClassLoader loader, String intfStr, XmlObject loc) {
        return InterfaceExtensionImpl.validateJava(loader, intfStr, true, loc);
    }

    static JClass validateClass(JamClassLoader loader, String clsStr, XmlObject loc) {
        return InterfaceExtensionImpl.validateJava(loader, clsStr, false, loc);
    }

    static JClass validateJava(JamClassLoader loader, String clsStr, boolean isInterface, XmlObject loc) {
        if (loader == null) {
            return null;
        }
        String ent = isInterface ? "Interface" : "Class";
        JClass cls = loader.loadClass(clsStr);
        if (cls == null || cls.isUnresolvedType()) {
            BindingConfigImpl.error(ent + " '" + clsStr + "' not found.", loc);
            return null;
        }
        if (isInterface && !cls.isInterface() || !isInterface && cls.isInterface()) {
            BindingConfigImpl.error("'" + clsStr + "' must be " + (isInterface ? "an interface" : "a class") + ".", loc);
        }
        if (!cls.isPublic()) {
            BindingConfigImpl.error(ent + " '" + clsStr + "' is not public.", loc);
        }
        return cls;
    }

    private boolean validateMethods(JClass interfaceJClass, JClass delegateJClass, XmlObject loc) {
        boolean valid = true;
        JMethod[] interfaceMethods = interfaceJClass.getMethods();
        this._methods = new MethodSignatureImpl[interfaceMethods.length];
        for (int i2 = 0; i2 < interfaceMethods.length; ++i2) {
            JMethod method = this.validateMethod(interfaceJClass, delegateJClass, interfaceMethods[i2], loc);
            if (method != null) {
                this._methods[i2] = new MethodSignatureImpl(this.getStaticHandler(), method);
                continue;
            }
            valid = false;
        }
        return valid;
    }

    private JMethod validateMethod(JClass interfaceJClass, JClass delegateJClass, JMethod method, XmlObject loc) {
        String methodName = method.getSimpleName();
        JParameter[] params = method.getParameters();
        JClass returnType = method.getReturnType();
        JClass[] delegateParams = new JClass[params.length + 1];
        delegateParams[0] = returnType.forName("org.apache.xmlbeans.XmlObject");
        for (int i2 = 1; i2 < delegateParams.length; ++i2) {
            delegateParams[i2] = params[i2 - 1].getType();
        }
        JMethod handlerMethod = null;
        handlerMethod = InterfaceExtensionImpl.getMethod(delegateJClass, methodName, delegateParams);
        if (handlerMethod == null) {
            BindingConfigImpl.error("Handler class '" + delegateJClass.getQualifiedName() + "' does not contain method " + methodName + "(" + InterfaceExtensionImpl.listTypes(delegateParams) + ")", loc);
            return null;
        }
        JClass[] intfExceptions = method.getExceptionTypes();
        JClass[] delegateExceptions = handlerMethod.getExceptionTypes();
        if (delegateExceptions.length != intfExceptions.length) {
            BindingConfigImpl.error("Handler method '" + delegateJClass.getQualifiedName() + "." + methodName + "(" + InterfaceExtensionImpl.listTypes(delegateParams) + ")' must declare the same exceptions as the interface method '" + interfaceJClass.getQualifiedName() + "." + methodName + "(" + InterfaceExtensionImpl.listTypes(params), loc);
            return null;
        }
        for (int i3 = 0; i3 < delegateExceptions.length; ++i3) {
            if (delegateExceptions[i3] == intfExceptions[i3]) continue;
            BindingConfigImpl.error("Handler method '" + delegateJClass.getQualifiedName() + "." + methodName + "(" + InterfaceExtensionImpl.listTypes(delegateParams) + ")' must declare the same exceptions as the interface method '" + interfaceJClass.getQualifiedName() + "." + methodName + "(" + InterfaceExtensionImpl.listTypes(params), loc);
            return null;
        }
        if (!handlerMethod.isPublic() || !handlerMethod.isStatic()) {
            BindingConfigImpl.error("Method '" + delegateJClass.getQualifiedName() + "." + methodName + "(" + InterfaceExtensionImpl.listTypes(delegateParams) + ")' must be declared public and static.", loc);
            return null;
        }
        if (!returnType.equals(handlerMethod.getReturnType())) {
            BindingConfigImpl.error("Return type for method '" + handlerMethod.getReturnType() + " " + delegateJClass.getQualifiedName() + "." + methodName + "(" + InterfaceExtensionImpl.listTypes(delegateParams) + ")' does not match the return type of the interface method :'" + returnType + "'.", loc);
            return null;
        }
        return method;
    }

    static JMethod getMethod(JClass cls, String name, JClass[] paramTypes) {
        JMethod[] methods = cls.getMethods();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            JParameter[] mParams;
            JMethod method = methods[i2];
            if (!name.equals(method.getSimpleName()) || (mParams = method.getParameters()).length != paramTypes.length) continue;
            for (int j2 = 0; j2 < mParams.length; ++j2) {
                JParameter mParam = mParams[j2];
                if (mParam.getType().equals(paramTypes[j2])) continue;
            }
            return method;
        }
        return null;
    }

    private static String listTypes(JClass[] types) {
        StringBuffer result = new StringBuffer();
        for (int i2 = 0; i2 < types.length; ++i2) {
            JClass type = types[i2];
            if (i2 > 0) {
                result.append(", ");
            }
            result.append(InterfaceExtensionImpl.emitType(type));
        }
        return result.toString();
    }

    private static String listTypes(JParameter[] params) {
        StringBuffer result = new StringBuffer();
        for (int i2 = 0; i2 < params.length; ++i2) {
            JClass type = params[i2].getType();
            if (i2 > 0) {
                result.append(", ");
            }
            result.append(InterfaceExtensionImpl.emitType(type));
        }
        return result.toString();
    }

    public static String emitType(JClass cls) {
        if (cls.isArrayType()) {
            return InterfaceExtensionImpl.emitType(cls.getArrayComponentType()) + "[]";
        }
        return cls.getQualifiedName().replace('$', '.');
    }

    public boolean contains(String fullJavaName) {
        return this._xbeanSet.contains(fullJavaName);
    }

    @Override
    public String getStaticHandler() {
        return this._delegateToClassName;
    }

    @Override
    public String getInterface() {
        return this._interfaceClassName;
    }

    @Override
    public InterfaceExtension.MethodSignature[] getMethods() {
        return this._methods;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("  static handler: ").append(this._delegateToClassName).append("\n");
        buf.append("  interface: ").append(this._interfaceClassName).append("\n");
        buf.append("  name set: ").append(this._xbeanSet).append("\n");
        for (int i2 = 0; i2 < this._methods.length; ++i2) {
            buf.append("  method[").append(i2).append("]=").append(this._methods[i2]).append("\n");
        }
        return buf.toString();
    }

    static class MethodSignatureImpl
    implements InterfaceExtension.MethodSignature {
        private String _intfName;
        private final int NOTINITIALIZED = -1;
        private int _hashCode = -1;
        private String _signature;
        private String _name;
        private String _return;
        private String[] _params;
        private String[] _exceptions;

        MethodSignatureImpl(String intfName, JMethod method) {
            if (intfName == null || method == null) {
                throw new IllegalArgumentException("Interface: " + intfName + " method: " + method);
            }
            this._intfName = intfName;
            this._hashCode = -1;
            this._signature = null;
            this._name = method.getSimpleName();
            this._return = method.getReturnType().getQualifiedName().replace('$', '.');
            JParameter[] paramTypes = method.getParameters();
            this._params = new String[paramTypes.length];
            for (int i2 = 0; i2 < paramTypes.length; ++i2) {
                this._params[i2] = paramTypes[i2].getType().getQualifiedName().replace('$', '.');
            }
            JClass[] exceptionTypes = method.getExceptionTypes();
            this._exceptions = new String[exceptionTypes.length];
            for (int i3 = 0; i3 < exceptionTypes.length; ++i3) {
                this._exceptions[i3] = exceptionTypes[i3].getQualifiedName().replace('$', '.');
            }
        }

        String getInterfaceName() {
            return this._intfName;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getReturnType() {
            return this._return;
        }

        @Override
        public String[] getParameterTypes() {
            return this._params;
        }

        @Override
        public String[] getExceptionTypes() {
            return this._exceptions;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof MethodSignatureImpl)) {
                return false;
            }
            MethodSignatureImpl ms = (MethodSignatureImpl)o2;
            if (!ms.getName().equals(this.getName())) {
                return false;
            }
            String[] params = this.getParameterTypes();
            String[] msParams = ms.getParameterTypes();
            if (msParams.length != params.length) {
                return false;
            }
            for (int i2 = 0; i2 < params.length; ++i2) {
                if (msParams[i2].equals(params[i2])) continue;
                return false;
            }
            return this._intfName.equals(ms._intfName);
        }

        public int hashCode() {
            if (this._hashCode != -1) {
                return this._hashCode;
            }
            int hash = this.getName().hashCode();
            String[] params = this.getParameterTypes();
            for (int i2 = 0; i2 < params.length; ++i2) {
                hash *= 19;
                hash += params[i2].hashCode();
            }
            this._hashCode = hash += 21 * this._intfName.hashCode();
            return this._hashCode;
        }

        String getSignature() {
            if (this._signature != null) {
                return this._signature;
            }
            StringBuffer sb = new StringBuffer(60);
            sb.append(this._name).append("(");
            for (int i2 = 0; i2 < this._params.length; ++i2) {
                sb.append(i2 == 0 ? "" : " ,").append(this._params[i2]);
            }
            sb.append(")");
            this._signature = sb.toString();
            return this._signature;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getReturnType()).append(" ").append(this.getSignature());
            return buf.toString();
        }
    }
}

