/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHeaderFooter;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFSDT;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTNumbering;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtBlock;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FtrDocument;

public class XWPFFooter
extends XWPFHeaderFooter {
    public XWPFFooter() {
    }

    public XWPFFooter(XWPFDocument doc, CTHdrFtr hdrFtr) throws IOException {
        super(doc, hdrFtr);
        XmlCursor cursor = this.headerFooter.newCursor();
        cursor.selectPath("./*");
        while (cursor.toNextSelection()) {
            XmlObject o2 = cursor.getObject();
            if (o2 instanceof CTP) {
                XWPFParagraph p2 = new XWPFParagraph((CTP)o2, this);
                this.paragraphs.add(p2);
                this.bodyElements.add(p2);
            }
            if (!(o2 instanceof CTTbl)) continue;
            XWPFTable t2 = new XWPFTable((CTTbl)o2, this);
            this.tables.add(t2);
            this.bodyElements.add(t2);
        }
        cursor.dispose();
    }

    public XWPFFooter(POIXMLDocumentPart parent, PackagePart part) throws IOException {
        super(parent, part);
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTNumbering.type.getName().getNamespaceURI(), "ftr"));
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        super._getHdrFtr().save(out, xmlOptions);
        out.close();
    }

    @Override
    protected void onDocumentRead() throws IOException {
        super.onDocumentRead();
        FtrDocument ftrDocument = null;
        InputStream is = null;
        try {
            is = this.getPackagePart().getInputStream();
            ftrDocument = FtrDocument.Factory.parse(is, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            this.headerFooter = ftrDocument.getFtr();
            XmlCursor cursor = this.headerFooter.newCursor();
            cursor.selectPath("./*");
            while (cursor.toNextSelection()) {
                XmlObject o2 = cursor.getObject();
                if (o2 instanceof CTP) {
                    XWPFParagraph p2 = new XWPFParagraph((CTP)o2, this);
                    this.paragraphs.add(p2);
                    this.bodyElements.add(p2);
                }
                if (o2 instanceof CTTbl) {
                    XWPFTable t2 = new XWPFTable((CTTbl)o2, this);
                    this.tables.add(t2);
                    this.bodyElements.add(t2);
                }
                if (!(o2 instanceof CTSdtBlock)) continue;
                XWPFSDT c2 = new XWPFSDT((CTSdtBlock)o2, (IBody)this);
                this.bodyElements.add(c2);
            }
            cursor.dispose();
        }
        catch (Exception e2) {
            throw new POIXMLException(e2);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public BodyType getPartType() {
        return BodyType.FOOTER;
    }
}

