/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import org.apache.poi.util.Internal;

@Internal
public abstract class POILogger {
    public static final int DEBUG = 1;
    public static final int INFO = 3;
    public static final int WARN = 5;
    public static final int ERROR = 7;
    public static final int FATAL = 9;
    protected static final String[] LEVEL_STRINGS_SHORT = new String[]{"?", "D", "?", "I", "?", "W", "?", "E", "?", "F", "?"};
    protected static final String[] LEVEL_STRINGS = new String[]{"?0?", "DEBUG", "?2?", "INFO", "?4?", "WARN", "?6?", "ERROR", "?8?", "FATAL", "?10+?"};

    POILogger() {
    }

    public abstract void initialize(String var1);

    protected abstract void _log(int var1, Object var2);

    protected abstract void _log(int var1, Object var2, Throwable var3);

    public abstract boolean check(int var1);

    public void log(int level, Object ... objs) {
        if (!this.check(level)) {
            return;
        }
        StringBuilder sb = new StringBuilder(32);
        Throwable lastEx = null;
        for (int i2 = 0; i2 < objs.length; ++i2) {
            if (i2 == objs.length - 1 && objs[i2] instanceof Throwable) {
                lastEx = (Throwable)objs[i2];
                continue;
            }
            sb.append(objs[i2]);
        }
        String msg = sb.toString();
        msg = msg.replaceAll("[\r\n]+", " ");
        if (lastEx == null) {
            this._log(level, msg);
        } else {
            this._log(level, msg, lastEx);
        }
    }
}

