/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

public class Finance {
    public static double pmt(double r2, int nper, double pv, double fv, int type) {
        double pmt = -r2 * (pv * Math.pow(1.0 + r2, nper) + fv) / ((1.0 + r2 * (double)type) * (Math.pow(1.0 + r2, nper) - 1.0));
        return pmt;
    }

    public static double pmt(double r2, int nper, double pv, double fv) {
        return Finance.pmt(r2, nper, pv, fv, 0);
    }

    public static double pmt(double r2, int nper, double pv) {
        return Finance.pmt(r2, nper, pv, 0.0);
    }

    public static double ipmt(double r2, int per, int nper, double pv, double fv, int type) {
        double ipmt = Finance.fv(r2, per - 1, Finance.pmt(r2, nper, pv, fv, type), pv, type) * r2;
        if (type == 1) {
            ipmt /= 1.0 + r2;
        }
        return ipmt;
    }

    public static double ipmt(double r2, int per, int nper, double pv, double fv) {
        return Finance.ipmt(r2, per, nper, pv, fv, 0);
    }

    public static double ipmt(double r2, int per, int nper, double pv) {
        return Finance.ipmt(r2, per, nper, pv, 0.0);
    }

    public static double ppmt(double r2, int per, int nper, double pv, double fv, int type) {
        return Finance.pmt(r2, nper, pv, fv, type) - Finance.ipmt(r2, per, nper, pv, fv, type);
    }

    public static double ppmt(double r2, int per, int nper, double pv, double fv) {
        return Finance.pmt(r2, nper, pv, fv) - Finance.ipmt(r2, per, nper, pv, fv);
    }

    public static double ppmt(double r2, int per, int nper, double pv) {
        return Finance.pmt(r2, nper, pv) - Finance.ipmt(r2, per, nper, pv);
    }

    public static double fv(double r2, int nper, double pmt, double pv, int type) {
        double fv = -(pv * Math.pow(1.0 + r2, nper) + pmt * (1.0 + r2 * (double)type) * (Math.pow(1.0 + r2, nper) - 1.0) / r2);
        return fv;
    }

    public static double fv(double r2, int nper, double c2, double pv) {
        return Finance.fv(r2, nper, c2, pv, 0);
    }
}

