/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw.geom;

import org.apache.poi.sl.draw.binding.CTGeomGuide;
import org.apache.poi.sl.draw.geom.Context;
import org.apache.poi.sl.draw.geom.Formula;

public class Guide
implements Formula {
    private final String name;
    private final String fmla;
    private final Op op;
    private final String[] operands;

    public Guide(CTGeomGuide gd) {
        this(gd.getName(), gd.getFmla());
    }

    public Guide(String nm, String fm) {
        this.name = nm;
        this.fmla = fm;
        this.operands = fm.split("\\s+");
        this.op = Op.valueOf(this.operands[0].replace("*", "mul").replace("/", "div").replace("+", "add").replace("-", "sub").replace("?:", "ifelse"));
    }

    public String getName() {
        return this.name;
    }

    String getFormula() {
        return this.fmla;
    }

    @Override
    public double evaluate(Context ctx) {
        double x2 = this.operands.length > 1 ? ctx.getValue(this.operands[1]) : 0.0;
        double y2 = this.operands.length > 2 ? ctx.getValue(this.operands[2]) : 0.0;
        double z2 = this.operands.length > 3 ? ctx.getValue(this.operands[3]) : 0.0;
        switch (this.op) {
            case abs: {
                return Math.abs(x2);
            }
            case adddiv: {
                return (x2 + y2) / z2;
            }
            case addsub: {
                return x2 + y2 - z2;
            }
            case at2: {
                return Math.toDegrees(Math.atan2(y2, x2)) * 60000.0;
            }
            case cos: {
                return x2 * Math.cos(Math.toRadians(y2 / 60000.0));
            }
            case cat2: {
                return x2 * Math.cos(Math.atan2(z2, y2));
            }
            case ifelse: {
                return x2 > 0.0 ? y2 : z2;
            }
            case val: {
                return x2;
            }
            case max: {
                return Math.max(x2, y2);
            }
            case min: {
                return Math.min(x2, y2);
            }
            case mod: {
                return Math.sqrt(x2 * x2 + y2 * y2 + z2 * z2);
            }
            case muldiv: {
                return x2 * y2 / z2;
            }
            case pin: {
                if (y2 < x2) {
                    return x2;
                }
                if (y2 > z2) {
                    return z2;
                }
                return y2;
            }
            case sat2: {
                return x2 * Math.sin(Math.atan2(z2, y2));
            }
            case sin: {
                return x2 * Math.sin(Math.toRadians(y2 / 60000.0));
            }
            case sqrt: {
                return Math.sqrt(x2);
            }
            case tan: {
                return x2 * Math.tan(Math.toRadians(y2 / 60000.0));
            }
        }
        return 0.0;
    }

    static enum Op {
        muldiv,
        addsub,
        adddiv,
        ifelse,
        val,
        abs,
        sqrt,
        max,
        min,
        at2,
        sin,
        cos,
        tan,
        cat2,
        sat2,
        pin,
        mod;

    }
}

