/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.opc;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public final class StreamHelper {
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    private StreamHelper() {
    }

    private static synchronized Transformer getIdentityTransformer() throws TransformerException {
        return transformerFactory.newTransformer();
    }

    public static boolean saveXmlInStream(Document xmlContent, OutputStream outStream) {
        try {
            Transformer trans = StreamHelper.getIdentityTransformer();
            DOMSource xmlSource = new DOMSource(xmlContent);
            StreamResult outputTarget = new StreamResult(new FilterOutputStream(outStream){

                @Override
                public void write(byte[] b2, int off, int len) throws IOException {
                    this.out.write(b2, off, len);
                }

                @Override
                public void close() throws IOException {
                    this.out.flush();
                }
            });
            trans.setOutputProperty("encoding", "UTF-8");
            trans.setOutputProperty("indent", "no");
            trans.setOutputProperty("standalone", "yes");
            trans.transform(xmlSource, outputTarget);
        }
        catch (TransformerException e2) {
            return false;
        }
        return true;
    }

    public static boolean copyStream(InputStream inStream, OutputStream outStream) {
        try {
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = inStream.read(buffer)) >= 0) {
                outStream.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e2) {
            return false;
        }
        return true;
    }
}

