/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.Record;

public final class WorkbookRecordList {
    private List<Record> records = new ArrayList<Record>();
    private int protpos = 0;
    private int bspos = 0;
    private int tabpos = 0;
    private int fontpos = 0;
    private int xfpos = 0;
    private int backuppos = 0;
    private int namepos = 0;
    private int supbookpos = 0;
    private int externsheetPos = 0;
    private int palettepos = -1;

    public void setRecords(List<Record> records) {
        this.records = records;
    }

    public int size() {
        return this.records.size();
    }

    public Record get(int i2) {
        return this.records.get(i2);
    }

    public void add(int pos, Record r2) {
        this.records.add(pos, r2);
        this.updateRecordPos(pos, true);
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public void remove(Object record) {
        int i2 = 0;
        for (Record r2 : this.records) {
            if (r2 == record) {
                this.remove(i2);
                break;
            }
            ++i2;
        }
    }

    public void remove(int pos) {
        this.records.remove(pos);
        this.updateRecordPos(pos, false);
    }

    public int getProtpos() {
        return this.protpos;
    }

    public void setProtpos(int protpos) {
        this.protpos = protpos;
    }

    public int getBspos() {
        return this.bspos;
    }

    public void setBspos(int bspos) {
        this.bspos = bspos;
    }

    public int getTabpos() {
        return this.tabpos;
    }

    public void setTabpos(int tabpos) {
        this.tabpos = tabpos;
    }

    public int getFontpos() {
        return this.fontpos;
    }

    public void setFontpos(int fontpos) {
        this.fontpos = fontpos;
    }

    public int getXfpos() {
        return this.xfpos;
    }

    public void setXfpos(int xfpos) {
        this.xfpos = xfpos;
    }

    public int getBackuppos() {
        return this.backuppos;
    }

    public void setBackuppos(int backuppos) {
        this.backuppos = backuppos;
    }

    public int getPalettepos() {
        return this.palettepos;
    }

    public void setPalettepos(int palettepos) {
        this.palettepos = palettepos;
    }

    public int getNamepos() {
        return this.namepos;
    }

    public int getSupbookpos() {
        return this.supbookpos;
    }

    public void setNamepos(int namepos) {
        this.namepos = namepos;
    }

    public void setSupbookpos(int supbookpos) {
        this.supbookpos = supbookpos;
    }

    public int getExternsheetPos() {
        return this.externsheetPos;
    }

    public void setExternsheetPos(int externsheetPos) {
        this.externsheetPos = externsheetPos;
    }

    private void updateRecordPos(int pos, boolean add) {
        int delta = add ? 1 : -1;
        int p2 = this.getProtpos();
        if (p2 >= pos) {
            this.setProtpos(p2 + delta);
        }
        if ((p2 = this.getBspos()) >= pos) {
            this.setBspos(p2 + delta);
        }
        if ((p2 = this.getTabpos()) >= pos) {
            this.setTabpos(p2 + delta);
        }
        if ((p2 = this.getFontpos()) >= pos) {
            this.setFontpos(p2 + delta);
        }
        if ((p2 = this.getXfpos()) >= pos) {
            this.setXfpos(p2 + delta);
        }
        if ((p2 = this.getBackuppos()) >= pos) {
            this.setBackuppos(p2 + delta);
        }
        if ((p2 = this.getNamepos()) >= pos) {
            this.setNamepos(p2 + delta);
        }
        if ((p2 = this.getSupbookpos()) >= pos) {
            this.setSupbookpos(p2 + delta);
        }
        if ((p2 = this.getPalettepos()) != -1 && p2 >= pos) {
            this.setPalettepos(p2 + delta);
        }
        if ((p2 = this.getExternsheetPos()) >= pos) {
            this.setExternsheetPos(p2 + delta);
        }
    }
}

