/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianByteArrayInputStream;

public class Filetime {
    private static final long EPOCH_DIFF = -11644473600000L;
    private static final int SIZE = 8;
    private static final long UINT_MASK = 0xFFFFFFFFL;
    private static final long NANO_100 = 10000L;
    private int _dwHighDateTime;
    private int _dwLowDateTime;

    Filetime() {
    }

    Filetime(int low, int high) {
        this._dwLowDateTime = low;
        this._dwHighDateTime = high;
    }

    Filetime(Date date) {
        long filetime = Filetime.dateToFileTime(date);
        this._dwHighDateTime = (int)(filetime >>> 32 & 0xFFFFFFFFL);
        this._dwLowDateTime = (int)(filetime & 0xFFFFFFFFL);
    }

    void read(LittleEndianByteArrayInputStream lei) {
        this._dwLowDateTime = lei.readInt();
        this._dwHighDateTime = lei.readInt();
    }

    long getHigh() {
        return this._dwHighDateTime;
    }

    long getLow() {
        return this._dwLowDateTime;
    }

    byte[] toByteArray() {
        byte[] result = new byte[8];
        LittleEndian.putInt(result, 0, this._dwLowDateTime);
        LittleEndian.putInt(result, 4, this._dwHighDateTime);
        return result;
    }

    int write(OutputStream out) throws IOException {
        LittleEndian.putInt(this._dwLowDateTime, out);
        LittleEndian.putInt(this._dwHighDateTime, out);
        return 8;
    }

    Date getJavaValue() {
        long l2 = (long)this._dwHighDateTime << 32 | (long)this._dwLowDateTime & 0xFFFFFFFFL;
        return Filetime.filetimeToDate(l2);
    }

    public static Date filetimeToDate(long filetime) {
        long ms_since_16010101 = filetime / 10000L;
        long ms_since_19700101 = ms_since_16010101 + -11644473600000L;
        return new Date(ms_since_19700101);
    }

    public static long dateToFileTime(Date date) {
        long ms_since_19700101 = date.getTime();
        long ms_since_16010101 = ms_since_19700101 - -11644473600000L;
        return ms_since_16010101 * 10000L;
    }

    public static boolean isUndefined(Date date) {
        return date == null || Filetime.dateToFileTime(date) == 0L;
    }
}

