/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui.xmleditor;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import org.apache.batik.util.gui.xmleditor.XMLContext;
import org.apache.batik.util.gui.xmleditor.XMLScanner;
import org.apache.batik.util.gui.xmleditor.XMLToken;

public class XMLDocument
extends PlainDocument {
    protected XMLScanner lexer;
    protected XMLContext context;
    protected XMLToken cacheToken = null;

    public XMLDocument() {
        this(new XMLContext());
    }

    public XMLDocument(XMLContext context) {
        this.context = context;
        this.lexer = new XMLScanner();
    }

    public XMLToken getScannerStart(int pos) throws BadLocationException {
        int ctx = 3;
        int offset = 0;
        int tokenOffset = 0;
        if (this.cacheToken != null) {
            if (this.cacheToken.getStartOffset() > pos) {
                this.cacheToken = null;
            } else {
                int line2;
                ctx = this.cacheToken.getContext();
                tokenOffset = offset = this.cacheToken.getStartOffset();
                Element element = this.getDefaultRootElement();
                int line1 = element.getElementIndex(pos);
                if (line1 - (line2 = element.getElementIndex(offset)) < 50) {
                    return this.cacheToken;
                }
            }
        }
        String str = this.getText(offset, pos - offset);
        this.lexer.setString(str);
        this.lexer.reset();
        int lastCtx = ctx;
        int lastOffset = offset;
        while (offset < pos) {
            lastOffset = offset;
            lastCtx = ctx;
            offset = this.lexer.scan(ctx) + tokenOffset;
            ctx = this.lexer.getScanValue();
        }
        this.cacheToken = new XMLToken(lastCtx, lastOffset, offset);
        return this.cacheToken;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a2) throws BadLocationException {
        super.insertString(offset, str, a2);
        if (this.cacheToken != null && this.cacheToken.getStartOffset() >= offset) {
            this.cacheToken = null;
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        if (this.cacheToken != null && this.cacheToken.getStartOffset() >= offs) {
            this.cacheToken = null;
        }
    }

    public int find(String str, int fromIndex, boolean caseSensitive) throws BadLocationException {
        int offset = -1;
        int startOffset = -1;
        int len = 0;
        int charIndex = 0;
        Element rootElement = this.getDefaultRootElement();
        int elementIndex = rootElement.getElementIndex(fromIndex);
        if (elementIndex < 0) {
            return offset;
        }
        charIndex = fromIndex - rootElement.getElement(elementIndex).getStartOffset();
        for (int i2 = elementIndex; i2 < rootElement.getElementCount(); ++i2) {
            Element element = rootElement.getElement(i2);
            startOffset = element.getStartOffset();
            len = element.getEndOffset() > this.getLength() ? this.getLength() - startOffset : element.getEndOffset() - startOffset;
            String text = this.getText(startOffset, len);
            if (!caseSensitive) {
                text = text.toLowerCase();
                str = str.toLowerCase();
            }
            if ((charIndex = text.indexOf(str, charIndex)) != -1) {
                offset = startOffset + charIndex;
                break;
            }
            charIndex = 0;
        }
        return offset;
    }
}

