/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ClassFileUtilities {
    public static final byte CONSTANT_UTF8_INFO = 1;
    public static final byte CONSTANT_INTEGER_INFO = 3;
    public static final byte CONSTANT_FLOAT_INFO = 4;
    public static final byte CONSTANT_LONG_INFO = 5;
    public static final byte CONSTANT_DOUBLE_INFO = 6;
    public static final byte CONSTANT_CLASS_INFO = 7;
    public static final byte CONSTANT_STRING_INFO = 8;
    public static final byte CONSTANT_FIELDREF_INFO = 9;
    public static final byte CONSTANT_METHODREF_INFO = 10;
    public static final byte CONSTANT_INTERFACEMETHODREF_INFO = 11;
    public static final byte CONSTANT_NAMEANDTYPE_INFO = 12;

    protected ClassFileUtilities() {
    }

    public static void main(String[] args) {
        String[] cwdFiles;
        boolean showFiles = false;
        if (args.length == 1 && args[0].equals("-f")) {
            showFiles = true;
        } else if (args.length != 0) {
            System.err.println("usage: org.apache.batik.util.ClassFileUtilities [-f]");
            System.err.println();
            System.err.println("  -f    list files that cause each jar file dependency");
            System.exit(1);
        }
        File cwd = new File(".");
        File buildDir = null;
        for (String cwdFile : cwdFiles = cwd.list()) {
            if (!cwdFile.startsWith("batik-")) continue;
            buildDir = new File(cwdFile);
            if (buildDir.isDirectory()) break;
            buildDir = null;
        }
        if (buildDir == null || !buildDir.isDirectory()) {
            System.out.println("Directory 'batik-xxx' not found in current directory!");
            return;
        }
        try {
            HashMap cs = new HashMap();
            HashMap js = new HashMap();
            ClassFileUtilities.collectJars(buildDir, js, cs);
            HashSet<JarFile> classpath = new HashSet<JarFile>();
            Iterator<Object> i2 = js.values().iterator();
            while (i2.hasNext()) {
                classpath.add(((Jar)i2.next()).jarFile);
            }
            for (ClassFile fromFile : cs.values()) {
                Set result = ClassFileUtilities.getClassDependencies(fromFile.getInputStream(), classpath, false);
                Iterator<Object> iterator = result.iterator();
                while (iterator.hasNext()) {
                    Object aResult = iterator.next();
                    ClassFile toFile = (ClassFile)cs.get(aResult);
                    if (fromFile == toFile || toFile == null) continue;
                    fromFile.deps.add(toFile);
                }
            }
            for (ClassFile fromFile : cs.values()) {
                for (Object dep : fromFile.deps) {
                    ClassFile toFile = (ClassFile)dep;
                    Jar fromJar = fromFile.jar;
                    Jar toJar = toFile.jar;
                    if (fromFile.name.equals(toFile.name) || toJar == fromJar || fromJar.files.contains(toFile.name)) continue;
                    Integer n2 = (Integer)fromJar.deps.get(toJar);
                    if (n2 == null) {
                        fromJar.deps.put(toJar, 1);
                        continue;
                    }
                    fromJar.deps.put(toJar, n2 + 1);
                }
            }
            ArrayList<Triple> triples = new ArrayList<Triple>(10);
            for (Jar fromJar : js.values()) {
                for (Object o2 : fromJar.deps.keySet()) {
                    Jar toJar = (Jar)o2;
                    Triple t2 = new Triple();
                    t2.from = fromJar;
                    t2.to = toJar;
                    t2.count = (Integer)fromJar.deps.get(toJar);
                    triples.add(t2);
                }
            }
            Collections.sort(triples);
            for (Triple t3 : triples) {
                System.out.println(t3.count + "," + t3.from.name + "," + t3.to.name);
                if (!showFiles) continue;
                for (Object file : t3.from.files) {
                    ClassFile fromFile = (ClassFile)file;
                    for (Object dep : fromFile.deps) {
                        ClassFile toFile = (ClassFile)dep;
                        if (toFile.jar != t3.to || t3.from.files.contains(toFile.name)) continue;
                        System.out.println("\t" + fromFile.name + " --> " + toFile.name);
                    }
                }
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static void collectJars(File dir, Map jars, Map classFiles) throws IOException {
        File[] files;
        for (File file : files = dir.listFiles()) {
            String n2 = file.getName();
            if (n2.endsWith(".jar") && file.isFile()) {
                Jar j2 = new Jar();
                j2.name = file.getPath();
                j2.file = file;
                j2.jarFile = new JarFile(file);
                jars.put(j2.name, j2);
                Enumeration<JarEntry> entries = j2.jarFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry ze = entries.nextElement();
                    String name = ze.getName();
                    if (!name.endsWith(".class")) continue;
                    ClassFile cf = new ClassFile();
                    cf.name = name;
                    cf.jar = j2;
                    classFiles.put(j2.name + '!' + cf.name, cf);
                    j2.files.add(cf);
                }
                continue;
            }
            if (!file.isDirectory()) continue;
            ClassFileUtilities.collectJars(file, jars, classFiles);
        }
    }

    public static Set getClassDependencies(String path, Set classpath, boolean rec) throws IOException {
        return ClassFileUtilities.getClassDependencies(new FileInputStream(path), classpath, rec);
    }

    public static Set getClassDependencies(InputStream is, Set classpath, boolean rec) throws IOException {
        HashSet result = new HashSet();
        HashSet done = new HashSet();
        ClassFileUtilities.computeClassDependencies(is, classpath, done, result, rec);
        return result;
    }

    private static void computeClassDependencies(InputStream is, Set classpath, Set done, Set result, boolean rec) throws IOException {
        for (Object o2 : ClassFileUtilities.getClassDependencies(is)) {
            String s2 = (String)o2;
            if (done.contains(s2)) continue;
            done.add(s2);
            for (Object aClasspath : classpath) {
                InputStream depis = null;
                String path = null;
                Object cpEntry = aClasspath;
                if (cpEntry instanceof JarFile) {
                    JarFile jarFile = (JarFile)cpEntry;
                    String classFileName = s2 + ".class";
                    ZipEntry ze = jarFile.getEntry(classFileName);
                    if (ze != null) {
                        path = jarFile.getName() + '!' + classFileName;
                        depis = jarFile.getInputStream(ze);
                    }
                } else {
                    path = (String)cpEntry + '/' + s2 + ".class";
                    File f2 = new File(path);
                    if (f2.isFile()) {
                        depis = new FileInputStream(f2);
                    }
                }
                if (depis == null) continue;
                result.add(path);
                if (!rec) continue;
                ClassFileUtilities.computeClassDependencies(depis, classpath, done, result, rec);
            }
        }
    }

    public static Set getClassDependencies(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        if (dis.readInt() != -889275714) {
            throw new IOException("Invalid classfile");
        }
        dis.readInt();
        int len = dis.readShort();
        String[] strs = new String[len];
        HashSet<Integer> classes = new HashSet<Integer>();
        HashSet<Integer> desc = new HashSet<Integer>();
        block8: for (int i2 = 1; i2 < len; ++i2) {
            int constCode = dis.readByte() & 0xFF;
            switch (constCode) {
                case 5: 
                case 6: {
                    dis.readLong();
                    ++i2;
                    continue block8;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    dis.readInt();
                    continue block8;
                }
                case 7: {
                    classes.add(dis.readShort() & 0xFFFF);
                    continue block8;
                }
                case 8: {
                    dis.readShort();
                    continue block8;
                }
                case 12: {
                    dis.readShort();
                    desc.add(dis.readShort() & 0xFFFF);
                    continue block8;
                }
                case 1: {
                    strs[i2] = dis.readUTF();
                    continue block8;
                }
                default: {
                    throw new RuntimeException("unexpected data in constant-pool:" + constCode);
                }
            }
        }
        HashSet<String> result = new HashSet<String>();
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            result.add(strs[(Integer)it.next()]);
        }
        it = desc.iterator();
        while (it.hasNext()) {
            result.addAll(ClassFileUtilities.getDescriptorClasses(strs[(Integer)it.next()]));
        }
        return result;
    }

    protected static Set getDescriptorClasses(String desc) {
        HashSet<String> result = new HashSet<String>();
        int i2 = 0;
        char c2 = desc.charAt(i2);
        switch (c2) {
            case '(': {
                StringBuffer sb;
                block14: while (true) {
                    c2 = desc.charAt(++i2);
                    switch (c2) {
                        case '[': {
                            while ((c2 = desc.charAt(++i2)) == '[') {
                            }
                            if (c2 != 'L') continue block14;
                        }
                        case 'L': {
                            c2 = desc.charAt(++i2);
                            sb = new StringBuffer();
                            while (c2 != ';') {
                                sb.append(c2);
                                c2 = desc.charAt(++i2);
                            }
                            result.add(sb.toString());
                            continue block14;
                        }
                        default: {
                            continue block14;
                        }
                        case ')': 
                    }
                    break;
                }
                c2 = desc.charAt(++i2);
                switch (c2) {
                    case '[': {
                        while ((c2 = desc.charAt(++i2)) == '[') {
                        }
                        if (c2 != 'L') break;
                    }
                    case 'L': {
                        c2 = desc.charAt(++i2);
                        sb = new StringBuffer();
                        while (c2 != ';') {
                            sb.append(c2);
                            c2 = desc.charAt(++i2);
                        }
                        result.add(sb.toString());
                        break;
                    }
                }
                break;
            }
            case '[': {
                while ((c2 = desc.charAt(++i2)) == '[') {
                }
                if (c2 != 'L') break;
            }
            case 'L': {
                c2 = desc.charAt(++i2);
                StringBuffer sb = new StringBuffer();
                while (c2 != ';') {
                    sb.append(c2);
                    c2 = desc.charAt(++i2);
                }
                result.add(sb.toString());
                break;
            }
        }
        return result;
    }

    protected static class Triple
    implements Comparable {
        public Jar from;
        public Jar to;
        public int count;

        protected Triple() {
        }

        public int compareTo(Object o2) {
            return ((Triple)o2).count - this.count;
        }
    }

    protected static class Jar {
        public String name;
        public File file;
        public JarFile jarFile;
        public Map deps = new HashMap();
        public Set files = new HashSet();

        protected Jar() {
        }
    }

    protected static class ClassFile {
        public String name;
        public List deps = new ArrayList(10);
        public Jar jar;

        protected ClassFile() {
        }

        public InputStream getInputStream() throws IOException {
            return this.jar.jarFile.getInputStream(this.jar.jarFile.getEntry(this.name));
        }
    }
}

