/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.AWTPermission;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.text.CharacterIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.batik.bridge.Mark;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.AWTEventDispatcher;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.SelectionAdapter;
import org.apache.batik.gvt.event.SelectionEvent;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.gvt.renderer.ImageRendererFactory;
import org.apache.batik.swing.gvt.AbstractZoomInteractor;
import org.apache.batik.swing.gvt.GVTTreeRenderer;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.GVTTreeRendererListener;
import org.apache.batik.swing.gvt.Interactor;
import org.apache.batik.swing.gvt.JGVTComponentListener;
import org.apache.batik.swing.gvt.Overlay;
import org.apache.batik.swing.gvt.TextSelectionManager;
import org.apache.batik.util.HaltingThread;
import org.apache.batik.util.Platform;

public class JGVTComponent
extends JComponent {
    protected Listener listener;
    protected GVTTreeRenderer gvtTreeRenderer;
    protected GraphicsNode gvtRoot;
    protected ImageRendererFactory rendererFactory = new ConcreteImageRendererFactory();
    protected ImageRenderer renderer;
    protected List gvtTreeRendererListeners = Collections.synchronizedList(new LinkedList());
    protected boolean needRender;
    protected boolean progressivePaint;
    protected HaltingThread progressivePaintThread;
    protected BufferedImage image;
    protected AffineTransform initialTransform = new AffineTransform();
    protected AffineTransform renderingTransform = new AffineTransform();
    protected AffineTransform paintingTransform;
    protected List interactors = new LinkedList();
    protected Interactor interactor;
    protected List overlays = new LinkedList();
    protected List jgvtListeners = null;
    protected AWTEventDispatcher eventDispatcher;
    protected TextSelectionManager textSelectionManager;
    protected boolean doubleBufferedRendering;
    protected boolean eventsEnabled;
    protected boolean selectableText;
    protected boolean useUnixTextSelection = true;
    protected boolean suspendInteractions;
    protected boolean disableInteractions;

    public JGVTComponent() {
        this(false, false);
    }

    public JGVTComponent(boolean eventsEnabled, boolean selectableText) {
        this.setBackground(Color.white);
        this.eventsEnabled = eventsEnabled;
        this.selectableText = selectableText;
        this.listener = this.createListener();
        this.addAWTListeners();
        this.addGVTTreeRendererListener(this.listener);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                if (JGVTComponent.this.updateRenderingTransform()) {
                    JGVTComponent.this.scheduleGVTRendering();
                }
            }
        });
    }

    protected Listener createListener() {
        return new Listener();
    }

    protected void addAWTListeners() {
        this.addKeyListener(this.listener);
        this.addMouseListener(this.listener);
        this.addMouseMotionListener(this.listener);
        this.addMouseWheelListener(this.listener);
    }

    public void setDisableInteractions(boolean b2) {
        this.disableInteractions = b2;
    }

    public boolean getDisableInteractions() {
        return this.disableInteractions;
    }

    public void setUseUnixTextSelection(boolean b2) {
        this.useUnixTextSelection = b2;
    }

    public void getUseUnixTextSelection(boolean b2) {
        this.useUnixTextSelection = b2;
    }

    public List getInteractors() {
        return this.interactors;
    }

    public List getOverlays() {
        return this.overlays;
    }

    public BufferedImage getOffScreen() {
        return this.image;
    }

    public void addJGVTComponentListener(JGVTComponentListener listener) {
        if (this.jgvtListeners == null) {
            this.jgvtListeners = new LinkedList();
        }
        this.jgvtListeners.add(listener);
    }

    public void removeJGVTComponentListener(JGVTComponentListener listener) {
        if (this.jgvtListeners == null) {
            return;
        }
        this.jgvtListeners.remove(listener);
    }

    public void resetRenderingTransform() {
        this.setRenderingTransform(this.initialTransform);
    }

    public void stopProcessing() {
        if (this.gvtTreeRenderer != null) {
            this.needRender = false;
            this.gvtTreeRenderer.halt();
            this.haltProgressivePaintThread();
        }
    }

    public GraphicsNode getGraphicsNode() {
        return this.gvtRoot;
    }

    public void setGraphicsNode(GraphicsNode gn) {
        this.setGraphicsNode(gn, true);
        this.initialTransform = new AffineTransform();
        this.updateRenderingTransform();
        this.setRenderingTransform(this.initialTransform, true);
    }

    protected void setGraphicsNode(GraphicsNode gn, boolean createDispatcher) {
        this.gvtRoot = gn;
        if (gn != null && createDispatcher) {
            this.initializeEventHandling();
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.setRootNode(gn);
        }
    }

    protected void initializeEventHandling() {
        if (this.eventsEnabled) {
            this.eventDispatcher = this.createEventDispatcher();
            if (this.selectableText) {
                this.textSelectionManager = this.createTextSelectionManager(this.eventDispatcher);
                this.textSelectionManager.addSelectionListener(new UnixTextSelectionListener());
            }
        }
    }

    protected AWTEventDispatcher createEventDispatcher() {
        return new AWTEventDispatcher();
    }

    protected TextSelectionManager createTextSelectionManager(EventDispatcher ed) {
        return new TextSelectionManager(this, ed);
    }

    public TextSelectionManager getTextSelectionManager() {
        return this.textSelectionManager;
    }

    public void setSelectionOverlayColor(Color color) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayColor(color);
        }
    }

    public Color getSelectionOverlayColor() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.getSelectionOverlayColor();
        }
        return null;
    }

    public void setSelectionOverlayStrokeColor(Color color) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayStrokeColor(color);
        }
    }

    public Color getSelectionOverlayStrokeColor() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.getSelectionOverlayStrokeColor();
        }
        return null;
    }

    public void setSelectionOverlayXORMode(boolean state) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelectionOverlayXORMode(state);
        }
    }

    public boolean isSelectionOverlayXORMode() {
        if (this.textSelectionManager != null) {
            return this.textSelectionManager.isSelectionOverlayXORMode();
        }
        return false;
    }

    public void select(Mark start, Mark end) {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.setSelection(start, end);
        }
    }

    public void deselectAll() {
        if (this.textSelectionManager != null) {
            this.textSelectionManager.clearSelection();
        }
    }

    public void setProgressivePaint(boolean b2) {
        if (this.progressivePaint != b2) {
            this.progressivePaint = b2;
            this.haltProgressivePaintThread();
        }
    }

    public boolean getProgressivePaint() {
        return this.progressivePaint;
    }

    public Rectangle getRenderRect() {
        Dimension d2 = this.getSize();
        return new Rectangle(0, 0, d2.width, d2.height);
    }

    public void immediateRepaint() {
        if (EventQueue.isDispatchThread()) {
            Rectangle visRect = this.getRenderRect();
            if (this.doubleBufferedRendering) {
                this.repaint(visRect.x, visRect.y, visRect.width, visRect.height);
            } else {
                this.paintImmediately(visRect.x, visRect.y, visRect.width, visRect.height);
            }
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Rectangle visRect = JGVTComponent.this.getRenderRect();
                        if (JGVTComponent.this.doubleBufferedRendering) {
                            JGVTComponent.this.repaint(visRect.x, visRect.y, visRect.width, visRect.height);
                        } else {
                            JGVTComponent.this.paintImmediately(visRect.x, visRect.y, visRect.width, visRect.height);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Graphics2D g2d = (Graphics2D)g2;
        Rectangle visRect = this.getRenderRect();
        g2d.setComposite(AlphaComposite.SrcOver);
        g2d.setPaint(this.getBackground());
        g2d.fillRect(visRect.x, visRect.y, visRect.width, visRect.height);
        if (this.image != null) {
            if (this.paintingTransform != null) {
                g2d.transform(this.paintingTransform);
            }
            g2d.drawRenderedImage(this.image, null);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            for (Object overlay : this.overlays) {
                ((Overlay)overlay).paint(g2);
            }
        }
    }

    public void setPaintingTransform(AffineTransform at) {
        this.paintingTransform = at;
        this.immediateRepaint();
    }

    public AffineTransform getPaintingTransform() {
        return this.paintingTransform;
    }

    public void setRenderingTransform(AffineTransform at) {
        this.setRenderingTransform(at, true);
    }

    public void setRenderingTransform(AffineTransform at, boolean performRedraw) {
        this.renderingTransform = new AffineTransform(at);
        this.suspendInteractions = true;
        if (this.eventDispatcher != null) {
            try {
                this.eventDispatcher.setBaseTransform(this.renderingTransform.createInverse());
            }
            catch (NoninvertibleTransformException e2) {
                this.handleException(e2);
            }
        }
        if (this.jgvtListeners != null) {
            Iterator iter = this.jgvtListeners.iterator();
            ComponentEvent ce = new ComponentEvent(this, 1337);
            while (iter.hasNext()) {
                JGVTComponentListener l2 = (JGVTComponentListener)iter.next();
                l2.componentTransformChanged(ce);
            }
        }
        if (performRedraw) {
            this.scheduleGVTRendering();
        }
    }

    public AffineTransform getInitialTransform() {
        return new AffineTransform(this.initialTransform);
    }

    public AffineTransform getRenderingTransform() {
        return new AffineTransform(this.renderingTransform);
    }

    public void setDoubleBufferedRendering(boolean b2) {
        this.doubleBufferedRendering = b2;
    }

    public boolean getDoubleBufferedRendering() {
        return this.doubleBufferedRendering;
    }

    public void addGVTTreeRendererListener(GVTTreeRendererListener l2) {
        this.gvtTreeRendererListeners.add(l2);
    }

    public void removeGVTTreeRendererListener(GVTTreeRendererListener l2) {
        this.gvtTreeRendererListeners.remove(l2);
    }

    public void flush() {
        this.renderer.flush();
    }

    public void flush(Rectangle r2) {
        this.renderer.flush(r2);
    }

    protected ImageRenderer createImageRenderer() {
        return this.rendererFactory.createStaticImageRenderer();
    }

    protected void renderGVTTree() {
        AffineTransform inv;
        Rectangle visRect = this.getRenderRect();
        if (this.gvtRoot == null || visRect.width <= 0 || visRect.height <= 0) {
            return;
        }
        if (this.renderer == null || this.renderer.getTree() != this.gvtRoot) {
            this.renderer = this.createImageRenderer();
            this.renderer.setTree(this.gvtRoot);
        }
        try {
            inv = this.renderingTransform.createInverse();
        }
        catch (NoninvertibleTransformException e2) {
            throw new IllegalStateException("NoninvertibleTransformEx:" + e2.getMessage());
        }
        Shape s2 = inv.createTransformedShape(visRect);
        this.gvtTreeRenderer = new GVTTreeRenderer(this.renderer, this.renderingTransform, this.doubleBufferedRendering, s2, visRect.width, visRect.height);
        this.gvtTreeRenderer.setPriority(1);
        for (Object gvtTreeRendererListener : this.gvtTreeRendererListeners) {
            this.gvtTreeRenderer.addGVTTreeRendererListener((GVTTreeRendererListener)gvtTreeRendererListener);
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.setEventDispatchEnabled(false);
        }
        this.gvtTreeRenderer.start();
    }

    protected boolean computeRenderingTransform() {
        this.initialTransform = new AffineTransform();
        if (!this.initialTransform.equals(this.renderingTransform)) {
            this.setRenderingTransform(this.initialTransform, false);
            return true;
        }
        return false;
    }

    protected boolean updateRenderingTransform() {
        return false;
    }

    protected void handleException(Exception e2) {
    }

    protected void releaseRenderingReferences() {
        this.eventDispatcher = null;
        if (this.textSelectionManager != null) {
            this.overlays.remove(this.textSelectionManager.getSelectionOverlay());
            this.textSelectionManager = null;
        }
        this.renderer = null;
        this.image = null;
        this.gvtRoot = null;
    }

    protected void scheduleGVTRendering() {
        if (this.gvtTreeRenderer != null) {
            this.needRender = true;
            this.gvtTreeRenderer.halt();
        } else {
            this.renderGVTTree();
        }
    }

    private void haltProgressivePaintThread() {
        if (this.progressivePaintThread != null) {
            this.progressivePaintThread.halt();
            this.progressivePaintThread = null;
        }
    }

    protected class UnixTextSelectionListener
    extends SelectionAdapter {
        protected UnixTextSelectionListener() {
        }

        @Override
        public void selectionDone(SelectionEvent evt) {
            int sz;
            if (!JGVTComponent.this.useUnixTextSelection) {
                return;
            }
            Object o2 = evt.getSelection();
            if (!(o2 instanceof CharacterIterator)) {
                return;
            }
            CharacterIterator iter = (CharacterIterator)o2;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkPermission(new AWTPermission("accessClipboard"));
                }
                catch (SecurityException e2) {
                    return;
                }
            }
            if ((sz = iter.getEndIndex() - iter.getBeginIndex()) == 0) {
                return;
            }
            char[] cbuff = new char[sz];
            cbuff[0] = iter.first();
            for (int i2 = 1; i2 < cbuff.length; ++i2) {
                cbuff[i2] = iter.next();
            }
            final String strSel = new String(cbuff);
            new Thread(){

                @Override
                public void run() {
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection sel = new StringSelection(strSel);
                    cb.setContents(sel, sel);
                }
            }.start();
        }
    }

    protected class Listener
    implements GVTTreeRendererListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        boolean checkClick = false;
        boolean hadDrag = false;
        int startX;
        int startY;
        long startTime;
        long fakeClickTime;
        int MAX_DISP = 16;
        long CLICK_TIME = 200L;

        protected Listener() {
        }

        @Override
        public void gvtRenderingPrepare(GVTTreeRendererEvent e2) {
            JGVTComponent.this.suspendInteractions = true;
            if (!JGVTComponent.this.progressivePaint && !JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.image = null;
            }
        }

        @Override
        public void gvtRenderingStarted(GVTTreeRendererEvent e2) {
            if (JGVTComponent.this.progressivePaint && !JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.image = e2.getImage();
                JGVTComponent.this.progressivePaintThread = new HaltingThread(){

                    @Override
                    public void run() {
                        final 1 thisThread = this;
                        try {
                            while (!1.hasBeenHalted()) {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (JGVTComponent.this.progressivePaintThread == thisThread) {
                                            Rectangle vRect = JGVTComponent.this.getRenderRect();
                                            JGVTComponent.this.repaint(vRect.x, vRect.y, vRect.width, vRect.height);
                                        }
                                    }
                                });
                                1.sleep(200L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t2) {
                            t2.printStackTrace();
                        }
                    }
                };
                JGVTComponent.this.progressivePaintThread.setPriority(2);
                JGVTComponent.this.progressivePaintThread.start();
            }
            if (!JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.paintingTransform = null;
                JGVTComponent.this.suspendInteractions = false;
            }
        }

        @Override
        public void gvtRenderingCompleted(GVTTreeRendererEvent e2) {
            JGVTComponent.this.haltProgressivePaintThread();
            if (JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.paintingTransform = null;
                JGVTComponent.this.suspendInteractions = false;
            }
            JGVTComponent.this.gvtTreeRenderer = null;
            if (JGVTComponent.this.needRender) {
                JGVTComponent.this.renderGVTTree();
                JGVTComponent.this.needRender = false;
            } else {
                JGVTComponent.this.image = e2.getImage();
                JGVTComponent.this.immediateRepaint();
            }
            if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.setEventDispatchEnabled(true);
            }
        }

        @Override
        public void gvtRenderingCancelled(GVTTreeRendererEvent e2) {
            this.renderingStopped();
        }

        @Override
        public void gvtRenderingFailed(GVTTreeRendererEvent e2) {
            this.renderingStopped();
        }

        private void renderingStopped() {
            JGVTComponent.this.haltProgressivePaintThread();
            if (JGVTComponent.this.doubleBufferedRendering) {
                JGVTComponent.this.suspendInteractions = false;
            }
            JGVTComponent.this.gvtTreeRenderer = null;
            if (JGVTComponent.this.needRender) {
                JGVTComponent.this.renderGVTTree();
                JGVTComponent.this.needRender = false;
            } else {
                JGVTComponent.this.immediateRepaint();
            }
            if (JGVTComponent.this.eventDispatcher != null) {
                JGVTComponent.this.eventDispatcher.setEventDispatchEnabled(true);
            }
        }

        @Override
        public void keyTyped(KeyEvent e2) {
            this.selectInteractor(e2);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.keyTyped(e2);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchKeyTyped(e2);
            }
        }

        protected void dispatchKeyTyped(KeyEvent e2) {
            JGVTComponent.this.eventDispatcher.keyTyped(e2);
        }

        @Override
        public void keyPressed(KeyEvent e2) {
            this.selectInteractor(e2);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.keyPressed(e2);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchKeyPressed(e2);
            }
        }

        protected void dispatchKeyPressed(KeyEvent e2) {
            JGVTComponent.this.eventDispatcher.keyPressed(e2);
        }

        @Override
        public void keyReleased(KeyEvent e2) {
            this.selectInteractor(e2);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.keyReleased(e2);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchKeyReleased(e2);
            }
        }

        protected void dispatchKeyReleased(KeyEvent e2) {
            JGVTComponent.this.eventDispatcher.keyReleased(e2);
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            if (this.fakeClickTime != e2.getWhen()) {
                this.handleMouseClicked(e2);
            }
        }

        public void handleMouseClicked(MouseEvent e2) {
            this.selectInteractor(e2);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseClicked(e2);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseClicked(e2);
            }
        }

        protected void dispatchMouseClicked(MouseEvent e2) {
            JGVTComponent.this.eventDispatcher.mouseClicked(e2);
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            this.startX = e2.getX();
            this.startY = e2.getY();
            this.startTime = e2.getWhen();
            this.checkClick = true;
            this.selectInteractor(e2);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mousePressed(e2);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMousePressed(e2);
            }
        }

        protected void dispatchMousePressed(MouseEvent e2) {
            JGVTComponent.this.eventDispatcher.mousePressed(e2);
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            if (this.checkClick && this.hadDrag) {
                int dx = this.startX - e2.getX();
                int dy = this.startY - e2.getY();
                long cTime = e2.getWhen();
                if (dx * dx + dy * dy < this.MAX_DISP && cTime - this.startTime < this.CLICK_TIME) {
                    MouseEvent click = new MouseEvent(e2.getComponent(), 500, e2.getWhen(), e2.getModifiersEx(), e2.getX(), e2.getY(), e2.getClickCount(), e2.isPopupTrigger());
                    this.fakeClickTime = click.getWhen();
                    this.handleMouseClicked(click);
                }
            }
            this.checkClick = false;
            this.hadDrag = false;
            this.selectInteractor(e2);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseReleased(e2);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseReleased(e2);
            }
        }

        protected void dispatchMouseReleased(MouseEvent e2) {
            JGVTComponent.this.eventDispatcher.mouseReleased(e2);
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
            this.selectInteractor(e2);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseEntered(e2);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseEntered(e2);
            }
        }

        protected void dispatchMouseEntered(MouseEvent e2) {
            JGVTComponent.this.eventDispatcher.mouseEntered(e2);
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            this.selectInteractor(e2);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseExited(e2);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseExited(e2);
            }
        }

        protected void dispatchMouseExited(MouseEvent e2) {
            JGVTComponent.this.eventDispatcher.mouseExited(e2);
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            int dy;
            this.hadDrag = true;
            int dx = this.startX - e2.getX();
            if (dx * dx + (dy = this.startY - e2.getY()) * dy > this.MAX_DISP) {
                this.checkClick = false;
            }
            this.selectInteractor(e2);
            if (JGVTComponent.this.interactor != null) {
                JGVTComponent.this.interactor.mouseDragged(e2);
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseDragged(e2);
            }
        }

        protected void dispatchMouseDragged(MouseEvent e2) {
            JGVTComponent.this.eventDispatcher.mouseDragged(e2);
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            this.selectInteractor(e2);
            if (JGVTComponent.this.interactor != null) {
                if (Platform.isOSX && JGVTComponent.this.interactor instanceof AbstractZoomInteractor) {
                    this.mouseDragged(e2);
                } else {
                    JGVTComponent.this.interactor.mouseMoved(e2);
                }
                this.deselectInteractor();
            } else if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseMoved(e2);
            }
        }

        protected void dispatchMouseMoved(MouseEvent e2) {
            JGVTComponent.this.eventDispatcher.mouseMoved(e2);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e2) {
            if (JGVTComponent.this.eventDispatcher != null) {
                this.dispatchMouseWheelMoved(e2);
            }
        }

        protected void dispatchMouseWheelMoved(MouseWheelEvent e2) {
            JGVTComponent.this.eventDispatcher.mouseWheelMoved(e2);
        }

        protected void selectInteractor(InputEvent ie) {
            if (!JGVTComponent.this.disableInteractions && !JGVTComponent.this.suspendInteractions && JGVTComponent.this.interactor == null && JGVTComponent.this.gvtRoot != null) {
                for (Object interactor1 : JGVTComponent.this.interactors) {
                    Interactor i2 = (Interactor)interactor1;
                    if (!i2.startInteraction(ie)) continue;
                    JGVTComponent.this.interactor = i2;
                    break;
                }
            }
        }

        protected void deselectInteractor() {
            if (JGVTComponent.this.interactor.endInteraction()) {
                JGVTComponent.this.interactor = null;
            }
        }
    }
}

