/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.Table;

public class HmtxTable
implements Table {
    private byte[] buf = null;
    private int[] hMetrics = null;
    private short[] leftSideBearing = null;

    protected HmtxTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        raf.seek(de.getOffset());
        this.buf = new byte[de.getLength()];
        raf.read(this.buf);
    }

    public void init(int numberOfHMetrics, int lsbCount) {
        int i2;
        if (this.buf == null) {
            return;
        }
        this.hMetrics = new int[numberOfHMetrics];
        ByteArrayInputStream bais = new ByteArrayInputStream(this.buf);
        for (i2 = 0; i2 < numberOfHMetrics; ++i2) {
            this.hMetrics[i2] = bais.read() << 24 | bais.read() << 16 | bais.read() << 8 | bais.read();
        }
        if (lsbCount > 0) {
            this.leftSideBearing = new short[lsbCount];
            for (i2 = 0; i2 < lsbCount; ++i2) {
                this.leftSideBearing[i2] = (short)(bais.read() << 8 | bais.read());
            }
        }
        this.buf = null;
    }

    public int getAdvanceWidth(int i2) {
        if (this.hMetrics == null) {
            return 0;
        }
        if (i2 < this.hMetrics.length) {
            return this.hMetrics[i2] >> 16;
        }
        return this.hMetrics[this.hMetrics.length - 1] >> 16;
    }

    public short getLeftSideBearing(int i2) {
        if (this.hMetrics == null) {
            return 0;
        }
        if (i2 < this.hMetrics.length) {
            return (short)(this.hMetrics[i2] & 0xFFFF);
        }
        return this.leftSideBearing[i2 - this.hMetrics.length];
    }

    @Override
    public int getType() {
        return 1752003704;
    }
}

