/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.extension.svg;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class HistogramRed
extends AbstractRed {
    boolean[] computed;
    int tallied = 0;
    int[] bins = new int[256];

    public HistogramRed(CachableRed src) {
        super(src, null);
        int tiles = this.getNumXTiles() * this.getNumYTiles();
        this.computed = new boolean[tiles];
    }

    public void tallyTile(Raster r2) {
        int minX = r2.getMinX();
        int minY = r2.getMinY();
        int w2 = r2.getWidth();
        int h2 = r2.getHeight();
        int[] samples = null;
        for (int y2 = minY; y2 < minY + h2; ++y2) {
            samples = r2.getPixels(minX, y2, w2, 1, samples);
            for (int x2 = 0; x2 < 3 * w2; ++x2) {
                int val = samples[x2++] * 5;
                val += samples[x2++] * 9;
                int n2 = (val += samples[x2++] * 2) >> 4;
                this.bins[n2] = this.bins[n2] + 1;
            }
        }
        ++this.tallied;
    }

    public int[] getHistogram() {
        if (this.tallied == this.computed.length) {
            return this.bins;
        }
        CachableRed src = (CachableRed)this.getSources().get(0);
        int yt0 = src.getMinTileY();
        int xtiles = src.getNumXTiles();
        int xt0 = src.getMinTileX();
        for (int y2 = 0; y2 < src.getNumYTiles(); ++y2) {
            for (int x2 = 0; x2 < xtiles; ++x2) {
                int idx = x2 + xt0 + y2 * xtiles;
                if (this.computed[idx]) continue;
                Raster r2 = src.getTile(x2 + xt0, y2 + yt0);
                this.tallyTile(r2);
                this.computed[idx] = true;
            }
        }
        return this.bins;
    }

    @Override
    public WritableRaster copyData(WritableRaster wr) {
        this.copyToRaster(wr);
        return wr;
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        int yt = tileY - this.getMinTileY();
        int xt = tileX - this.getMinTileX();
        CachableRed src = (CachableRed)this.getSources().get(0);
        Raster r2 = src.getTile(tileX, tileY);
        int idx = xt + yt * this.getNumXTiles();
        if (this.computed[idx]) {
            return r2;
        }
        this.tallyTile(r2);
        this.computed[idx] = true;
        return r2;
    }
}

