/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.apache.batik.ext.awt.geom.Polyline2D;

public class Polygon2D
implements Shape,
Cloneable,
Serializable {
    public int npoints;
    public float[] xpoints;
    public float[] ypoints;
    protected Rectangle2D bounds;
    private GeneralPath path;
    private GeneralPath closedPath;

    public Polygon2D() {
        this.xpoints = new float[4];
        this.ypoints = new float[4];
    }

    public Polygon2D(Rectangle2D rec) {
        if (rec == null) {
            throw new IndexOutOfBoundsException("null Rectangle");
        }
        this.npoints = 4;
        this.xpoints = new float[4];
        this.ypoints = new float[4];
        this.xpoints[0] = (float)rec.getMinX();
        this.ypoints[0] = (float)rec.getMinY();
        this.xpoints[1] = (float)rec.getMaxX();
        this.ypoints[1] = (float)rec.getMinY();
        this.xpoints[2] = (float)rec.getMaxX();
        this.ypoints[2] = (float)rec.getMaxY();
        this.xpoints[3] = (float)rec.getMinX();
        this.ypoints[3] = (float)rec.getMaxY();
        this.calculatePath();
    }

    public Polygon2D(Polygon pol) {
        if (pol == null) {
            throw new IndexOutOfBoundsException("null Polygon");
        }
        this.npoints = pol.npoints;
        this.xpoints = new float[pol.npoints];
        this.ypoints = new float[pol.npoints];
        for (int i2 = 0; i2 < pol.npoints; ++i2) {
            this.xpoints[i2] = pol.xpoints[i2];
            this.ypoints[i2] = pol.ypoints[i2];
        }
        this.calculatePath();
    }

    public Polygon2D(float[] xpoints, float[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = npoints;
        this.xpoints = new float[npoints];
        this.ypoints = new float[npoints];
        System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
        System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
        this.calculatePath();
    }

    public Polygon2D(int[] xpoints, int[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = npoints;
        this.xpoints = new float[npoints];
        this.ypoints = new float[npoints];
        for (int i2 = 0; i2 < npoints; ++i2) {
            this.xpoints[i2] = xpoints[i2];
            this.ypoints[i2] = ypoints[i2];
        }
        this.calculatePath();
    }

    public void reset() {
        this.npoints = 0;
        this.bounds = null;
        this.path = new GeneralPath();
        this.closedPath = null;
    }

    public Object clone() {
        Polygon2D pol = new Polygon2D();
        for (int i2 = 0; i2 < this.npoints; ++i2) {
            pol.addPoint(this.xpoints[i2], this.ypoints[i2]);
        }
        return pol;
    }

    private void calculatePath() {
        this.path = new GeneralPath();
        this.path.moveTo(this.xpoints[0], this.ypoints[0]);
        for (int i2 = 1; i2 < this.npoints; ++i2) {
            this.path.lineTo(this.xpoints[i2], this.ypoints[i2]);
        }
        this.bounds = this.path.getBounds2D();
        this.closedPath = null;
    }

    private void updatePath(float x2, float y2) {
        this.closedPath = null;
        if (this.path == null) {
            this.path = new GeneralPath(0);
            this.path.moveTo(x2, y2);
            this.bounds = new Rectangle2D.Float(x2, y2, 0.0f, 0.0f);
        } else {
            this.path.lineTo(x2, y2);
            float _xmax = (float)this.bounds.getMaxX();
            float _ymax = (float)this.bounds.getMaxY();
            float _xmin = (float)this.bounds.getMinX();
            float _ymin = (float)this.bounds.getMinY();
            if (x2 < _xmin) {
                _xmin = x2;
            } else if (x2 > _xmax) {
                _xmax = x2;
            }
            if (y2 < _ymin) {
                _ymin = y2;
            } else if (y2 > _ymax) {
                _ymax = y2;
            }
            this.bounds = new Rectangle2D.Float(_xmin, _ymin, _xmax - _xmin, _ymax - _ymin);
        }
    }

    public Polyline2D getPolyline2D() {
        Polyline2D pol = new Polyline2D(this.xpoints, this.ypoints, this.npoints);
        pol.addPoint(this.xpoints[0], this.ypoints[0]);
        return pol;
    }

    public Polygon getPolygon() {
        int[] _xpoints = new int[this.npoints];
        int[] _ypoints = new int[this.npoints];
        for (int i2 = 0; i2 < this.npoints; ++i2) {
            _xpoints[i2] = (int)this.xpoints[i2];
            _ypoints[i2] = (int)this.ypoints[i2];
        }
        return new Polygon(_xpoints, _ypoints, this.npoints);
    }

    public void addPoint(Point2D p2) {
        this.addPoint((float)p2.getX(), (float)p2.getY());
    }

    public void addPoint(float x2, float y2) {
        if (this.npoints == this.xpoints.length) {
            float[] tmp = new float[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, tmp, 0, this.npoints);
            this.xpoints = tmp;
            tmp = new float[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, tmp, 0, this.npoints);
            this.ypoints = tmp;
        }
        this.xpoints[this.npoints] = x2;
        this.ypoints[this.npoints] = y2;
        ++this.npoints;
        this.updatePath(x2, y2);
    }

    public boolean contains(Point p2) {
        return this.contains(p2.x, p2.y);
    }

    public boolean contains(int x2, int y2) {
        return this.contains((double)x2, (double)y2);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            return null;
        }
        return this.bounds.getBounds();
    }

    @Override
    public boolean contains(double x2, double y2) {
        if (this.npoints <= 2 || !this.bounds.contains(x2, y2)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.contains(x2, y2);
    }

    private void updateComputingPath() {
        if (this.npoints >= 1 && this.closedPath == null) {
            this.closedPath = (GeneralPath)this.path.clone();
            this.closedPath.closePath();
        }
    }

    @Override
    public boolean contains(Point2D p2) {
        return this.contains(p2.getX(), p2.getY());
    }

    @Override
    public boolean intersects(double x2, double y2, double w2, double h2) {
        if (this.npoints <= 0 || !this.bounds.intersects(x2, y2, w2, h2)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.intersects(x2, y2, w2, h2);
    }

    @Override
    public boolean intersects(Rectangle2D r2) {
        return this.intersects(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
    }

    @Override
    public boolean contains(double x2, double y2, double w2, double h2) {
        if (this.npoints <= 0 || !this.bounds.intersects(x2, y2, w2, h2)) {
            return false;
        }
        this.updateComputingPath();
        return this.closedPath.contains(x2, y2, w2, h2);
    }

    @Override
    public boolean contains(Rectangle2D r2) {
        return this.contains(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        this.updateComputingPath();
        if (this.closedPath == null) {
            return null;
        }
        return this.closedPath.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }
}

