/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.anim.dom.SVGOMFlowRegionElement;
import org.apache.batik.anim.dom.XBLEventSupport;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.CursorManager;
import org.apache.batik.bridge.FlowTextNode;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGAElementBridge;
import org.apache.batik.bridge.SVGTextElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextNode;
import org.apache.batik.bridge.TextUtilities;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.svg12.SVG12TextElementBridge;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.value.ComputedValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.svg12.LineHeightValue;
import org.apache.batik.css.engine.value.svg12.SVG12ValueConstants;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.flow.BlockInfo;
import org.apache.batik.gvt.flow.RegionInfo;
import org.apache.batik.gvt.flow.TextLineBreaks;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.batik.gvt.text.TextPath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class SVGFlowRootElementBridge
extends SVG12TextElementBridge {
    public static final AttributedCharacterIterator.Attribute FLOW_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_EMPTY_PARAGRAPH = GVTAttributedCharacterIterator.TextAttribute.FLOW_EMPTY_PARAGRAPH;
    public static final AttributedCharacterIterator.Attribute FLOW_LINE_BREAK = GVTAttributedCharacterIterator.TextAttribute.FLOW_LINE_BREAK;
    public static final AttributedCharacterIterator.Attribute FLOW_REGIONS = GVTAttributedCharacterIterator.TextAttribute.FLOW_REGIONS;
    public static final AttributedCharacterIterator.Attribute LINE_HEIGHT = GVTAttributedCharacterIterator.TextAttribute.LINE_HEIGHT;
    public static final GVTAttributedCharacterIterator.TextAttribute TEXTPATH = GVTAttributedCharacterIterator.TextAttribute.TEXTPATH;
    public static final GVTAttributedCharacterIterator.TextAttribute ANCHOR_TYPE = GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE;
    public static final GVTAttributedCharacterIterator.TextAttribute LETTER_SPACING = GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING;
    public static final GVTAttributedCharacterIterator.TextAttribute WORD_SPACING = GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING;
    public static final GVTAttributedCharacterIterator.TextAttribute KERNING = GVTAttributedCharacterIterator.TextAttribute.KERNING;
    protected Map flowRegionNodes;
    protected TextNode textNode;
    protected RegionChangeListener regionChangeListener;
    protected int startLen;
    int marginTopIndex = -1;
    int marginRightIndex = -1;
    int marginBottomIndex = -1;
    int marginLeftIndex = -1;
    int indentIndex = -1;
    int textAlignIndex = -1;
    int lineHeightIndex = -1;

    @Override
    protected TextNode getTextNode() {
        return this.textNode;
    }

    @Override
    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    @Override
    public String getLocalName() {
        return "flowRoot";
    }

    @Override
    public Bridge getInstance() {
        return new SVGFlowRootElementBridge();
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext ctx, Element e2) {
        if (!SVGUtilities.matchUserAgent(e2, ctx.getUserAgent())) {
            return null;
        }
        CompositeGraphicsNode cgn = new CompositeGraphicsNode();
        String s2 = e2.getAttributeNS(null, "transform");
        if (s2.length() != 0) {
            cgn.setTransform(SVGUtilities.convertTransform(e2, "transform", s2, ctx));
        }
        cgn.setVisible(CSSUtilities.convertVisibility(e2));
        RenderingHints hints = null;
        hints = CSSUtilities.convertColorRendering(e2, hints);
        hints = CSSUtilities.convertTextRendering(e2, hints);
        if (hints != null) {
            cgn.setRenderingHints(hints);
        }
        CompositeGraphicsNode cgn2 = new CompositeGraphicsNode();
        cgn.add(cgn2);
        FlowTextNode tn = (FlowTextNode)this.instantiateGraphicsNode();
        tn.setLocation(this.getLocation(ctx, e2));
        if (ctx.getTextPainter() != null) {
            tn.setTextPainter(ctx.getTextPainter());
        }
        this.textNode = tn;
        cgn.add(tn);
        this.associateSVGContext(ctx, e2, cgn);
        Node child = this.getFirstChild(e2);
        while (child != null) {
            if (child.getNodeType() == 1) {
                this.addContextToChild(ctx, (Element)child);
            }
            child = this.getNextSibling(child);
        }
        return cgn;
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return new FlowTextNode();
    }

    @Override
    protected Point2D getLocation(BridgeContext ctx, Element e2) {
        return new Point2D.Float(0.0f, 0.0f);
    }

    @Override
    protected boolean isTextElement(Element e2) {
        if (!"http://www.w3.org/2000/svg".equals(e2.getNamespaceURI())) {
            return false;
        }
        String nodeName = e2.getLocalName();
        return nodeName.equals("flowDiv") || nodeName.equals("flowLine") || nodeName.equals("flowPara") || nodeName.equals("flowRegionBreak") || nodeName.equals("flowSpan");
    }

    @Override
    protected boolean isTextChild(Element e2) {
        if (!"http://www.w3.org/2000/svg".equals(e2.getNamespaceURI())) {
            return false;
        }
        String nodeName = e2.getLocalName();
        return nodeName.equals("a") || nodeName.equals("flowLine") || nodeName.equals("flowPara") || nodeName.equals("flowRegionBreak") || nodeName.equals("flowSpan");
    }

    @Override
    public void buildGraphicsNode(BridgeContext ctx, Element e2, GraphicsNode node) {
        boolean isStatic;
        CompositeGraphicsNode cgn = (CompositeGraphicsNode)node;
        boolean bl = isStatic = !ctx.isDynamic();
        if (isStatic) {
            this.flowRegionNodes = new HashMap();
        } else {
            this.regionChangeListener = new RegionChangeListener();
        }
        CompositeGraphicsNode cgn2 = (CompositeGraphicsNode)cgn.get(0);
        GVTBuilder builder = ctx.getGVTBuilder();
        Node n2 = this.getFirstChild(e2);
        while (n2 != null) {
            if (n2 instanceof SVGOMFlowRegionElement) {
                Node m2 = this.getFirstChild(n2);
                while (m2 != null) {
                    GraphicsNode gn;
                    if (m2.getNodeType() == 1 && (gn = builder.build(ctx, (Element)m2)) != null) {
                        cgn2.add(gn);
                        if (isStatic) {
                            this.flowRegionNodes.put(m2, gn);
                        }
                    }
                    m2 = this.getNextSibling(m2);
                }
                if (!isStatic) {
                    AbstractNode an = (AbstractNode)n2;
                    XBLEventSupport es = (XBLEventSupport)an.initializeEventSupport();
                    es.addImplementationEventListenerNS("http://www.w3.org/2000/svg", "shapechange", this.regionChangeListener, false);
                }
            }
            n2 = this.getNextSibling(n2);
        }
        GraphicsNode tn = (GraphicsNode)cgn.get(1);
        super.buildGraphicsNode(ctx, e2, tn);
        this.flowRegionNodes = null;
    }

    @Override
    protected void computeLaidoutText(BridgeContext ctx, Element e2, GraphicsNode node) {
        super.computeLaidoutText(ctx, this.getFlowDivElement(e2), node);
    }

    @Override
    protected void addContextToChild(BridgeContext ctx, Element e2) {
        String ln;
        if ("http://www.w3.org/2000/svg".equals(e2.getNamespaceURI()) && ((ln = e2.getLocalName()).equals("flowDiv") || ln.equals("flowLine") || ln.equals("flowPara") || ln.equals("flowSpan"))) {
            ((SVGOMElement)e2).setSVGContext(new FlowContentBridge(ctx, (SVGTextElementBridge)this, e2));
        }
        Node child = this.getFirstChild(e2);
        while (child != null) {
            if (child.getNodeType() == 1) {
                this.addContextToChild(ctx, (Element)child);
            }
            child = this.getNextSibling(child);
        }
    }

    @Override
    protected void removeContextFromChild(BridgeContext ctx, Element e2) {
        String ln;
        if ("http://www.w3.org/2000/svg".equals(e2.getNamespaceURI()) && ((ln = e2.getLocalName()).equals("flowDiv") || ln.equals("flowLine") || ln.equals("flowPara") || ln.equals("flowSpan"))) {
            ((SVGTextElementBridge.AbstractTextChildBridgeUpdateHandler)((SVGOMElement)e2).getSVGContext()).dispose();
        }
        Node child = this.getFirstChild(e2);
        while (child != null) {
            if (child.getNodeType() == 1) {
                this.removeContextFromChild(ctx, (Element)child);
            }
            child = this.getNextSibling(child);
        }
    }

    @Override
    protected AttributedString buildAttributedString(BridgeContext ctx, Element element) {
        if (element == null) {
            return null;
        }
        List rgns = this.getRegions(ctx, element);
        AttributedString ret = this.getFlowDiv(ctx, element);
        if (ret == null) {
            return ret;
        }
        ret.addAttribute(FLOW_REGIONS, rgns, 0, 1);
        TextLineBreaks.findLineBrk(ret);
        return ret;
    }

    protected void dumpACIWord(AttributedString as) {
        if (as == null) {
            return;
        }
        StringBuffer chars = new StringBuffer();
        StringBuffer brkStr = new StringBuffer();
        AttributedCharacterIterator aci = as.getIterator();
        AttributedCharacterIterator.Attribute WORD_LIMIT = TextLineBreaks.WORD_LIMIT;
        char ch = aci.current();
        while (ch != '\uffff') {
            chars.append(ch).append(' ').append(' ');
            int w2 = (Integer)aci.getAttribute(WORD_LIMIT);
            brkStr.append(w2).append(' ');
            if (w2 < 10) {
                brkStr.append(' ');
            }
            ch = aci.next();
        }
        System.out.println(chars.toString());
        System.out.println(brkStr.toString());
    }

    protected Element getFlowDivElement(Element elem) {
        String eNS = elem.getNamespaceURI();
        if (!eNS.equals("http://www.w3.org/2000/svg")) {
            return null;
        }
        String nodeName = elem.getLocalName();
        if (nodeName.equals("flowDiv")) {
            return elem;
        }
        if (!nodeName.equals("flowRoot")) {
            return null;
        }
        Node n2 = this.getFirstChild(elem);
        while (n2 != null) {
            Element e2;
            String ln;
            String nNS;
            if (n2.getNodeType() == 1 && "http://www.w3.org/2000/svg".equals(nNS = n2.getNamespaceURI()) && (ln = (e2 = (Element)n2).getLocalName()).equals("flowDiv")) {
                return e2;
            }
            n2 = this.getNextSibling(n2);
        }
        return null;
    }

    protected AttributedString getFlowDiv(BridgeContext ctx, Element element) {
        Element flowDiv = this.getFlowDivElement(element);
        if (flowDiv == null) {
            return null;
        }
        return this.gatherFlowPara(ctx, flowDiv);
    }

    protected AttributedString gatherFlowPara(BridgeContext ctx, Element div) {
        TextPaintInfo divTPI = new TextPaintInfo();
        divTPI.visible = true;
        divTPI.fillPaint = Color.black;
        this.elemTPI.put(div, divTPI);
        SVGTextElementBridge.AttributedStringBuffer asb = new SVGTextElementBridge.AttributedStringBuffer();
        ArrayList<Integer> paraEnds = new ArrayList<Integer>();
        ArrayList<Element> paraElems = new ArrayList<Element>();
        ArrayList lnLocs = new ArrayList();
        Node n2 = this.getFirstChild(div);
        while (n2 != null) {
            if (n2.getNodeType() == 1 && this.getNamespaceURI().equals(n2.getNamespaceURI())) {
                Element e2 = (Element)n2;
                String ln = e2.getLocalName();
                if (ln.equals("flowPara")) {
                    this.fillAttributedStringBuffer(ctx, e2, true, null, null, asb, lnLocs);
                    paraElems.add(e2);
                    paraEnds.add(asb.length());
                } else if (ln.equals("flowRegionBreak")) {
                    this.fillAttributedStringBuffer(ctx, e2, true, null, null, asb, lnLocs);
                    paraElems.add(e2);
                    paraEnds.add(asb.length());
                }
            }
            n2 = this.getNextSibling(n2);
        }
        divTPI.startChar = 0;
        divTPI.endChar = asb.length() - 1;
        AttributedString ret = asb.toAttributedString();
        if (ret == null) {
            return null;
        }
        int prevLN = 0;
        for (Object lnLoc : lnLocs) {
            int nextLN = (Integer)lnLoc;
            if (nextLN == prevLN) continue;
            ret.addAttribute(FLOW_LINE_BREAK, new Object(), prevLN, nextLN);
            prevLN = nextLN;
        }
        int start = 0;
        LinkedList<BlockInfo> emptyPara = null;
        for (int i2 = 0; i2 < paraElems.size(); ++i2) {
            Element elem = (Element)paraElems.get(i2);
            int end = (Integer)paraEnds.get(i2);
            if (start == end) {
                if (emptyPara == null) {
                    emptyPara = new LinkedList<BlockInfo>();
                }
                emptyPara.add(this.makeBlockInfo(ctx, elem));
            } else {
                ret.addAttribute(FLOW_PARAGRAPH, this.makeBlockInfo(ctx, elem), start, end);
                if (emptyPara != null) {
                    ret.addAttribute(FLOW_EMPTY_PARAGRAPH, emptyPara, start, end);
                    emptyPara = null;
                }
            }
            start = end;
        }
        return ret;
    }

    protected List getRegions(BridgeContext ctx, Element element) {
        element = (Element)element.getParentNode();
        LinkedList ret = new LinkedList();
        Node n2 = this.getFirstChild(element);
        while (n2 != null) {
            Element e2;
            String ln;
            if (n2.getNodeType() == 1 && "http://www.w3.org/2000/svg".equals(n2.getNamespaceURI()) && "flowRegion".equals(ln = (e2 = (Element)n2).getLocalName())) {
                float verticalAlignment = 0.0f;
                this.gatherRegionInfo(ctx, e2, verticalAlignment, ret);
            }
            n2 = this.getNextSibling(n2);
        }
        return ret;
    }

    protected void gatherRegionInfo(BridgeContext ctx, Element rgn, float verticalAlign, List regions) {
        boolean isStatic = !ctx.isDynamic();
        Node n2 = this.getFirstChild(rgn);
        while (n2 != null) {
            GraphicsNode gn;
            Shape s2;
            if (n2.getNodeType() == 1 && (s2 = (gn = isStatic ? (GraphicsNode)this.flowRegionNodes.get(n2) : ctx.getGraphicsNode(n2)).getOutline()) != null) {
                AffineTransform at = gn.getTransform();
                if (at != null) {
                    s2 = at.createTransformedShape(s2);
                }
                regions.add(new RegionInfo(s2, verticalAlign));
            }
            n2 = this.getNextSibling(n2);
        }
    }

    protected void fillAttributedStringBuffer(BridgeContext ctx, Element element, boolean top, Integer bidiLevel, Map initialAttributes, SVGTextElementBridge.AttributedStringBuffer asb, List lnLocs) {
        Integer i2;
        if (!SVGUtilities.matchUserAgent(element, ctx.getUserAgent()) || !CSSUtilities.convertDisplay(element)) {
            return;
        }
        String s2 = XMLSupport.getXMLSpace(element);
        boolean preserve = s2.equals("preserve");
        Element nodeElement = element;
        int elementStartChar = asb.length();
        if (top) {
            this.endLimit = this.startLen = asb.length();
        }
        if (preserve) {
            this.endLimit = this.startLen;
        }
        HashMap map = initialAttributes == null ? new HashMap() : new HashMap(initialAttributes);
        initialAttributes = this.getAttributeMap(ctx, element, null, bidiLevel, map);
        Object o2 = map.get(TextAttribute.BIDI_EMBEDDING);
        Integer subBidiLevel = bidiLevel;
        if (o2 != null) {
            subBidiLevel = (Integer)o2;
        }
        int lineBreak = -1;
        if (lnLocs.size() != 0) {
            lineBreak = (Integer)lnLocs.get(lnLocs.size() - 1);
        }
        Node n2 = this.getFirstChild(element);
        while (n2 != null) {
            boolean prevEndsWithSpace;
            if (preserve) {
                prevEndsWithSpace = false;
            } else {
                int len = asb.length();
                if (len == this.startLen) {
                    prevEndsWithSpace = true;
                } else {
                    prevEndsWithSpace = asb.getLastChar() == 32;
                    int idx = lnLocs.size() - 1;
                    if (!prevEndsWithSpace && idx >= 0 && (i2 = (Integer)lnLocs.get(idx)) == len) {
                        prevEndsWithSpace = true;
                    }
                }
            }
            switch (n2.getNodeType()) {
                case 1: {
                    int before;
                    if (!"http://www.w3.org/2000/svg".equals(n2.getNamespaceURI())) break;
                    nodeElement = (Element)n2;
                    String ln = n2.getLocalName();
                    if (ln.equals("flowLine")) {
                        before = asb.length();
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, subBidiLevel, initialAttributes, asb, lnLocs);
                        lineBreak = asb.length();
                        lnLocs.add(lineBreak);
                        if (before == lineBreak) break;
                        initialAttributes = null;
                        break;
                    }
                    if (ln.equals("flowSpan") || ln.equals("altGlyph")) {
                        before = asb.length();
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, subBidiLevel, initialAttributes, asb, lnLocs);
                        if (asb.length() == before) break;
                        initialAttributes = null;
                        break;
                    }
                    if (ln.equals("a")) {
                        if (ctx.isInteractive()) {
                            NodeEventTarget target = (NodeEventTarget)((Object)nodeElement);
                            UserAgent ua = ctx.getUserAgent();
                            SVGAElementBridge.CursorHolder ch = new SVGAElementBridge.CursorHolder(CursorManager.DEFAULT_CURSOR);
                            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", new SVGAElementBridge.AnchorListener(ua, ch), false, null);
                            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", new SVGAElementBridge.CursorMouseOverListener(ua, ch), false, null);
                            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", new SVGAElementBridge.CursorMouseOutListener(ua, ch), false, null);
                        }
                        before = asb.length();
                        this.fillAttributedStringBuffer(ctx, nodeElement, false, subBidiLevel, initialAttributes, asb, lnLocs);
                        if (asb.length() == before) break;
                        initialAttributes = null;
                        break;
                    }
                    if (!ln.equals("tref")) break;
                    String uriStr = XLinkSupport.getXLinkHref((Element)n2);
                    Element ref = ctx.getReferencedElement((Element)n2, uriStr);
                    s2 = TextUtilities.getElementContent(ref);
                    if ((s2 = this.normalizeString(s2, preserve, prevEndsWithSpace)).length() == 0) break;
                    int trefStart = asb.length();
                    HashMap m2 = new HashMap();
                    this.getAttributeMap(ctx, nodeElement, null, bidiLevel, m2);
                    asb.append(s2, m2);
                    int trefEnd = asb.length() - 1;
                    TextPaintInfo tpi = (TextPaintInfo)this.elemTPI.get(nodeElement);
                    tpi.startChar = trefStart;
                    tpi.endChar = trefEnd;
                    break;
                }
                case 3: 
                case 4: {
                    s2 = n2.getNodeValue();
                    s2 = this.normalizeString(s2, preserve, prevEndsWithSpace);
                    if (s2.length() == 0) break;
                    asb.append(s2, map);
                    if (preserve) {
                        this.endLimit = asb.length();
                    }
                    initialAttributes = null;
                }
            }
            n2 = this.getNextSibling(n2);
        }
        if (top) {
            boolean strippedSome = false;
            while (this.endLimit < asb.length() && asb.getLastChar() == 32) {
                int idx = lnLocs.size() - 1;
                int len = asb.length();
                if (idx >= 0 && (i2 = (Integer)lnLocs.get(idx)) >= len) {
                    i2 = len - 1;
                    lnLocs.set(idx, i2);
                    --idx;
                    while (idx >= 0 && (i2 = (Integer)lnLocs.get(idx)) >= len - 1) {
                        lnLocs.remove(idx);
                        --idx;
                    }
                }
                asb.stripLast();
                strippedSome = true;
            }
            if (strippedSome) {
                for (Object o1 : this.elemTPI.values()) {
                    TextPaintInfo tpi = (TextPaintInfo)o1;
                    if (tpi.endChar < asb.length()) continue;
                    tpi.endChar = asb.length() - 1;
                    if (tpi.startChar <= tpi.endChar) continue;
                    tpi.startChar = tpi.endChar;
                }
            }
        }
        int elementEndChar = asb.length() - 1;
        TextPaintInfo tpi = (TextPaintInfo)this.elemTPI.get(element);
        tpi.startChar = elementStartChar;
        tpi.endChar = elementEndChar;
    }

    @Override
    protected Map getAttributeMap(BridgeContext ctx, Element element, TextPath textPath, Integer bidiLevel, Map result) {
        Map inheritingMap = super.getAttributeMap(ctx, element, textPath, bidiLevel, result);
        float fontSize = TextUtilities.convertFontSize(element).floatValue();
        float lineHeight = this.getLineHeight(ctx, element, fontSize);
        result.put(LINE_HEIGHT, Float.valueOf(lineHeight));
        return inheritingMap;
    }

    protected void checkMap(Map attrs) {
        if (attrs.containsKey(TEXTPATH)) {
            return;
        }
        if (attrs.containsKey(ANCHOR_TYPE)) {
            return;
        }
        if (attrs.containsKey(LETTER_SPACING)) {
            return;
        }
        if (attrs.containsKey(WORD_SPACING)) {
            return;
        }
        if (attrs.containsKey(KERNING)) {
            return;
        }
    }

    protected void initCSSPropertyIndexes(Element e2) {
        CSSEngine eng = CSSUtilities.getCSSEngine(e2);
        this.marginTopIndex = eng.getPropertyIndex("margin-top");
        this.marginRightIndex = eng.getPropertyIndex("margin-right");
        this.marginBottomIndex = eng.getPropertyIndex("margin-bottom");
        this.marginLeftIndex = eng.getPropertyIndex("margin-left");
        this.indentIndex = eng.getPropertyIndex("indent");
        this.textAlignIndex = eng.getPropertyIndex("text-align");
        this.lineHeightIndex = eng.getPropertyIndex("line-height");
    }

    public BlockInfo makeBlockInfo(BridgeContext ctx, Element element) {
        if (this.marginTopIndex == -1) {
            this.initCSSPropertyIndexes(element);
        }
        Value v2 = CSSUtilities.getComputedStyle(element, this.marginTopIndex);
        float top = v2.getFloatValue();
        v2 = CSSUtilities.getComputedStyle(element, this.marginRightIndex);
        float right = v2.getFloatValue();
        v2 = CSSUtilities.getComputedStyle(element, this.marginBottomIndex);
        float bottom = v2.getFloatValue();
        v2 = CSSUtilities.getComputedStyle(element, this.marginLeftIndex);
        float left = v2.getFloatValue();
        v2 = CSSUtilities.getComputedStyle(element, this.indentIndex);
        float indent = v2.getFloatValue();
        v2 = CSSUtilities.getComputedStyle(element, this.textAlignIndex);
        if (v2 == ValueConstants.INHERIT_VALUE) {
            v2 = CSSUtilities.getComputedStyle(element, 11);
            v2 = v2 == ValueConstants.LTR_VALUE ? SVG12ValueConstants.START_VALUE : SVG12ValueConstants.END_VALUE;
        }
        int textAlign = v2 == SVG12ValueConstants.START_VALUE ? 0 : (v2 == SVG12ValueConstants.MIDDLE_VALUE ? 1 : (v2 == SVG12ValueConstants.END_VALUE ? 2 : 3));
        HashMap fontAttrs = new HashMap(20);
        List fontList = this.getFontList(ctx, element, fontAttrs);
        Float fs = (Float)fontAttrs.get(TextAttribute.SIZE);
        float fontSize = fs.floatValue();
        float lineHeight = this.getLineHeight(ctx, element, fontSize);
        String ln = element.getLocalName();
        boolean rgnBr = ln.equals("flowRegionBreak");
        return new BlockInfo(top, right, bottom, left, indent, textAlign, lineHeight, fontList, fontAttrs, rgnBr);
    }

    protected float getLineHeight(BridgeContext ctx, Element element, float fontSize) {
        Value v2;
        if (this.lineHeightIndex == -1) {
            this.initCSSPropertyIndexes(element);
        }
        if ((v2 = CSSUtilities.getComputedStyle(element, this.lineHeightIndex)) == ValueConstants.INHERIT_VALUE || v2 == SVG12ValueConstants.NORMAL_VALUE) {
            return fontSize * 1.1f;
        }
        float lineHeight = v2.getFloatValue();
        if (v2 instanceof ComputedValue) {
            v2 = ((ComputedValue)v2).getComputedValue();
        }
        if (v2 instanceof LineHeightValue && ((LineHeightValue)v2).getFontSizeRelative()) {
            lineHeight *= fontSize;
        }
        return lineHeight;
    }

    protected class RegionChangeListener
    implements EventListener {
        protected RegionChangeListener() {
        }

        @Override
        public void handleEvent(Event evt) {
            SVGFlowRootElementBridge.this.laidoutText = null;
            SVGFlowRootElementBridge.this.computeLaidoutText(SVGFlowRootElementBridge.this.ctx, SVGFlowRootElementBridge.this.e, SVGFlowRootElementBridge.this.getTextNode());
        }
    }

    protected class FlowContentBridge
    extends SVGTextElementBridge.AbstractTextChildTextContent {
        public FlowContentBridge(BridgeContext ctx, SVGTextElementBridge parent, Element e2) {
            super(ctx, parent, e2);
        }
    }
}

