/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.EventListenerList;
import org.apache.batik.anim.dom.BindableElement;
import org.apache.batik.anim.dom.XBLEventSupport;
import org.apache.batik.anim.dom.XBLOMContentElement;
import org.apache.batik.anim.dom.XBLOMDefinitionElement;
import org.apache.batik.anim.dom.XBLOMImportElement;
import org.apache.batik.anim.dom.XBLOMShadowTreeElement;
import org.apache.batik.anim.dom.XBLOMTemplateElement;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.svg12.BindingListener;
import org.apache.batik.bridge.svg12.ContentManager;
import org.apache.batik.bridge.svg12.ContentSelectionChangedListener;
import org.apache.batik.dom.AbstractAttrNS;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.AbstractNode;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.xbl.NodeXBL;
import org.apache.batik.dom.xbl.ShadowTreeEvent;
import org.apache.batik.dom.xbl.XBLManager;
import org.apache.batik.dom.xbl.XBLManagerData;
import org.apache.batik.dom.xbl.XBLShadowTreeElement;
import org.apache.batik.util.DoublyIndexedTable;
import org.apache.batik.util.XBLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class DefaultXBLManager
implements XBLManager,
XBLConstants {
    protected boolean isProcessing;
    protected Document document;
    protected BridgeContext ctx;
    protected DoublyIndexedTable definitionLists = new DoublyIndexedTable();
    protected DoublyIndexedTable definitions = new DoublyIndexedTable();
    protected Map contentManagers = new HashMap();
    protected Map imports = new HashMap();
    protected DocInsertedListener docInsertedListener = new DocInsertedListener();
    protected DocRemovedListener docRemovedListener = new DocRemovedListener();
    protected DocSubtreeListener docSubtreeListener = new DocSubtreeListener();
    protected ImportAttrListener importAttrListener = new ImportAttrListener();
    protected RefAttrListener refAttrListener = new RefAttrListener();
    protected EventListenerList bindingListenerList = new EventListenerList();
    protected EventListenerList contentSelectionChangedListenerList = new EventListenerList();

    public DefaultXBLManager(Document doc, BridgeContext ctx) {
        this.document = doc;
        this.ctx = ctx;
        ImportRecord ir = new ImportRecord(null, null);
        this.imports.put(null, ir);
    }

    @Override
    public void startProcessing() {
        if (this.isProcessing) {
            return;
        }
        NodeList nl = this.document.getElementsByTagNameNS("http://www.w3.org/2004/xbl", "definition");
        XBLOMDefinitionElement[] defs = new XBLOMDefinitionElement[nl.getLength()];
        for (int i2 = 0; i2 < defs.length; ++i2) {
            defs[i2] = (XBLOMDefinitionElement)nl.item(i2);
        }
        nl = this.document.getElementsByTagNameNS("http://www.w3.org/2004/xbl", "import");
        Element[] imports = new Element[nl.getLength()];
        for (int i3 = 0; i3 < imports.length; ++i3) {
            imports[i3] = (Element)nl.item(i3);
        }
        AbstractDocument doc = (AbstractDocument)this.document;
        XBLEventSupport es = (XBLEventSupport)doc.initializeEventSupport();
        es.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.docRemovedListener, true);
        es.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.docInsertedListener, true);
        es.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.docSubtreeListener, true);
        for (XBLOMDefinitionElement def : defs) {
            if (def.getAttributeNS(null, "ref").length() != 0) {
                this.addDefinitionRef(def);
                continue;
            }
            String ns = def.getElementNamespaceURI();
            String ln = def.getElementLocalName();
            this.addDefinition(ns, ln, def, null);
        }
        for (Element anImport : imports) {
            this.addImport(anImport);
        }
        this.isProcessing = true;
        this.bind(this.document.getDocumentElement());
    }

    @Override
    public void stopProcessing() {
        if (!this.isProcessing) {
            return;
        }
        this.isProcessing = false;
        AbstractDocument doc = (AbstractDocument)this.document;
        XBLEventSupport es = (XBLEventSupport)doc.initializeEventSupport();
        es.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.docRemovedListener, true);
        es.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.docInsertedListener, true);
        es.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.docSubtreeListener, true);
        int nSlots = this.imports.values().size();
        ImportRecord[] irs = new ImportRecord[nSlots];
        this.imports.values().toArray(irs);
        for (ImportRecord ir : irs) {
            if (ir.importElement.getLocalName().equals("definition")) {
                this.removeDefinitionRef(ir.importElement);
                continue;
            }
            this.removeImport(ir.importElement);
        }
        Object[] defRecs = this.definitions.getValuesArray();
        this.definitions.clear();
        for (Object defRec1 : defRecs) {
            DefinitionRecord defRec = (DefinitionRecord)defRec1;
            TreeSet defs = (TreeSet)this.definitionLists.get(defRec.namespaceURI, defRec.localName);
            if (defs == null) continue;
            while (!defs.isEmpty()) {
                defRec = (DefinitionRecord)defs.first();
                defs.remove(defRec);
                this.removeDefinition(defRec);
            }
            this.definitionLists.put(defRec.namespaceURI, defRec.localName, null);
        }
        this.definitionLists = new DoublyIndexedTable();
        this.contentManagers.clear();
    }

    @Override
    public boolean isProcessing() {
        return this.isProcessing;
    }

    protected void addDefinitionRef(Element defRef) {
        String ref = defRef.getAttributeNS(null, "ref");
        Element e2 = this.ctx.getReferencedElement(defRef, ref);
        if (!"http://www.w3.org/2004/xbl".equals(e2.getNamespaceURI()) || !"definition".equals(e2.getLocalName())) {
            throw new BridgeException(this.ctx, defRef, "uri.badTarget", new Object[]{ref});
        }
        ImportRecord ir = new ImportRecord(defRef, e2);
        this.imports.put(defRef, ir);
        NodeEventTarget et = (NodeEventTarget)((Object)defRef);
        et.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.refAttrListener, false, null);
        XBLOMDefinitionElement d2 = (XBLOMDefinitionElement)defRef;
        String ns = d2.getElementNamespaceURI();
        String ln = d2.getElementLocalName();
        this.addDefinition(ns, ln, (XBLOMDefinitionElement)e2, defRef);
    }

    protected void removeDefinitionRef(Element defRef) {
        ImportRecord ir = (ImportRecord)this.imports.get(defRef);
        NodeEventTarget et = (NodeEventTarget)((Object)defRef);
        et.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.refAttrListener, false);
        DefinitionRecord defRec = (DefinitionRecord)this.definitions.get(ir.node, defRef);
        this.removeDefinition(defRec);
        this.imports.remove(defRef);
    }

    protected void addImport(Element imp) {
        String bindings = imp.getAttributeNS(null, "bindings");
        Node n2 = this.ctx.getReferencedNode(imp, bindings);
        if (!(n2.getNodeType() != 1 || "http://www.w3.org/2004/xbl".equals(n2.getNamespaceURI()) && "xbl".equals(n2.getLocalName()))) {
            throw new BridgeException(this.ctx, imp, "uri.badTarget", new Object[]{n2});
        }
        ImportRecord ir = new ImportRecord(imp, n2);
        this.imports.put(imp, ir);
        NodeEventTarget et = (NodeEventTarget)((Object)imp);
        et.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.importAttrListener, false, null);
        et = (NodeEventTarget)((Object)n2);
        et.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", ir.importInsertedListener, false, null);
        et.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", ir.importRemovedListener, false, null);
        et.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", ir.importSubtreeListener, false, null);
        this.addImportedDefinitions(imp, n2);
    }

    protected void addImportedDefinitions(Element imp, Node n2) {
        if (n2 instanceof XBLOMDefinitionElement) {
            XBLOMDefinitionElement def = (XBLOMDefinitionElement)n2;
            String ns = def.getElementNamespaceURI();
            String ln = def.getElementLocalName();
            this.addDefinition(ns, ln, def, imp);
        } else {
            for (n2 = n2.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                this.addImportedDefinitions(imp, n2);
            }
        }
    }

    protected void removeImport(Element imp) {
        Object[] defRecs;
        ImportRecord ir = (ImportRecord)this.imports.get(imp);
        NodeEventTarget et = (NodeEventTarget)((Object)ir.node);
        et.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", ir.importInsertedListener, false);
        et.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", ir.importRemovedListener, false);
        et.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", ir.importSubtreeListener, false);
        et = (NodeEventTarget)((Object)imp);
        et.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.importAttrListener, false);
        for (Object defRec1 : defRecs = this.definitions.getValuesArray()) {
            DefinitionRecord defRec = (DefinitionRecord)defRec1;
            if (defRec.importElement != imp) continue;
            this.removeDefinition(defRec);
        }
        this.imports.remove(imp);
    }

    protected void addDefinition(String namespaceURI, String localName, XBLOMDefinitionElement def, Element imp) {
        ImportRecord ir = (ImportRecord)this.imports.get(imp);
        DefinitionRecord oldDefRec = null;
        TreeSet<DefinitionRecord> defs = (TreeSet<DefinitionRecord>)this.definitionLists.get(namespaceURI, localName);
        if (defs == null) {
            defs = new TreeSet<DefinitionRecord>();
            this.definitionLists.put(namespaceURI, localName, defs);
        } else if (defs.size() > 0) {
            oldDefRec = (DefinitionRecord)defs.first();
        }
        XBLOMTemplateElement template = null;
        for (Node n2 = def.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (!(n2 instanceof XBLOMTemplateElement)) continue;
            template = (XBLOMTemplateElement)n2;
            break;
        }
        DefinitionRecord defRec = new DefinitionRecord(namespaceURI, localName, def, template, imp);
        defs.add(defRec);
        this.definitions.put(def, imp, defRec);
        this.addDefinitionElementListeners(def, ir);
        if (defs.first() != defRec) {
            return;
        }
        if (oldDefRec != null) {
            XBLOMDefinitionElement oldDef = oldDefRec.definition;
            XBLOMTemplateElement oldTemplate = oldDefRec.template;
            if (oldTemplate != null) {
                this.removeTemplateElementListeners(oldTemplate, ir);
            }
            this.removeDefinitionElementListeners(oldDef, ir);
        }
        if (template != null) {
            this.addTemplateElementListeners(template, ir);
        }
        if (this.isProcessing) {
            this.rebind(namespaceURI, localName, this.document.getDocumentElement());
        }
    }

    protected void addDefinitionElementListeners(XBLOMDefinitionElement def, ImportRecord ir) {
        XBLEventSupport es = (XBLEventSupport)def.initializeEventSupport();
        es.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", ir.defAttrListener, false);
        es.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", ir.defNodeInsertedListener, false);
        es.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", ir.defNodeRemovedListener, false);
    }

    protected void addTemplateElementListeners(XBLOMTemplateElement template, ImportRecord ir) {
        XBLEventSupport es = (XBLEventSupport)template.initializeEventSupport();
        es.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", ir.templateMutationListener, false);
        es.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", ir.templateMutationListener, false);
        es.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", ir.templateMutationListener, false);
        es.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", ir.templateMutationListener, false);
    }

    protected void removeDefinition(DefinitionRecord defRec) {
        TreeSet defs = (TreeSet)this.definitionLists.get(defRec.namespaceURI, defRec.localName);
        if (defs == null) {
            return;
        }
        Element imp = defRec.importElement;
        ImportRecord ir = (ImportRecord)this.imports.get(imp);
        DefinitionRecord activeDefRec = (DefinitionRecord)defs.first();
        defs.remove(defRec);
        this.definitions.remove(defRec.definition, imp);
        this.removeDefinitionElementListeners(defRec.definition, ir);
        if (defRec != activeDefRec) {
            return;
        }
        if (defRec.template != null) {
            this.removeTemplateElementListeners(defRec.template, ir);
        }
        this.rebind(defRec.namespaceURI, defRec.localName, this.document.getDocumentElement());
    }

    protected void removeDefinitionElementListeners(XBLOMDefinitionElement def, ImportRecord ir) {
        XBLEventSupport es = (XBLEventSupport)def.initializeEventSupport();
        es.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", ir.defAttrListener, false);
        es.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", ir.defNodeInsertedListener, false);
        es.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", ir.defNodeRemovedListener, false);
    }

    protected void removeTemplateElementListeners(XBLOMTemplateElement template, ImportRecord ir) {
        XBLEventSupport es = (XBLEventSupport)template.initializeEventSupport();
        es.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", ir.templateMutationListener, false);
        es.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", ir.templateMutationListener, false);
        es.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", ir.templateMutationListener, false);
        es.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", ir.templateMutationListener, false);
    }

    protected DefinitionRecord getActiveDefinition(String namespaceURI, String localName) {
        TreeSet defs = (TreeSet)this.definitionLists.get(namespaceURI, localName);
        if (defs == null || defs.size() == 0) {
            return null;
        }
        return (DefinitionRecord)defs.first();
    }

    protected void unbind(Element e2) {
        if (e2 instanceof BindableElement) {
            this.setActiveDefinition((BindableElement)e2, null);
        } else {
            NodeList nl = this.getXblScopedChildNodes(e2);
            for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                Node n2 = nl.item(i2);
                if (n2.getNodeType() != 1) continue;
                this.unbind((Element)n2);
            }
        }
    }

    protected void bind(Element e2) {
        XBLManager xm;
        AbstractDocument doc = (AbstractDocument)e2.getOwnerDocument();
        if (doc != this.document && (xm = doc.getXBLManager()) instanceof DefaultXBLManager) {
            ((DefaultXBLManager)xm).bind(e2);
            return;
        }
        if (e2 instanceof BindableElement) {
            DefinitionRecord defRec = this.getActiveDefinition(e2.getNamespaceURI(), e2.getLocalName());
            this.setActiveDefinition((BindableElement)e2, defRec);
        } else {
            NodeList nl = this.getXblScopedChildNodes(e2);
            for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                Node n2 = nl.item(i2);
                if (n2.getNodeType() != 1) continue;
                this.bind((Element)n2);
            }
        }
    }

    protected void rebind(String namespaceURI, String localName, Element e2) {
        XBLManager xm;
        AbstractDocument doc = (AbstractDocument)e2.getOwnerDocument();
        if (doc != this.document && (xm = doc.getXBLManager()) instanceof DefaultXBLManager) {
            ((DefaultXBLManager)xm).rebind(namespaceURI, localName, e2);
            return;
        }
        if (e2 instanceof BindableElement && namespaceURI.equals(e2.getNamespaceURI()) && localName.equals(e2.getLocalName())) {
            DefinitionRecord defRec = this.getActiveDefinition(e2.getNamespaceURI(), e2.getLocalName());
            this.setActiveDefinition((BindableElement)e2, defRec);
        } else {
            NodeList nl = this.getXblScopedChildNodes(e2);
            for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                Node n2 = nl.item(i2);
                if (n2.getNodeType() != 1) continue;
                this.rebind(namespaceURI, localName, (Element)n2);
            }
        }
    }

    protected void setActiveDefinition(BindableElement elt, DefinitionRecord defRec) {
        XBLRecord rec = this.getRecord(elt);
        XBLOMDefinitionElement xBLOMDefinitionElement = rec.definitionElement = defRec == null ? null : defRec.definition;
        if (defRec != null && defRec.definition != null && defRec.template != null) {
            this.setXblShadowTree(elt, this.cloneTemplate(defRec.template));
        } else {
            this.setXblShadowTree(elt, null);
        }
    }

    protected void setXblShadowTree(BindableElement elt, XBLOMShadowTreeElement newShadow) {
        XBLOMShadowTreeElement oldShadow = (XBLOMShadowTreeElement)this.getXblShadowTree(elt);
        if (oldShadow != null) {
            this.fireShadowTreeEvent(elt, "unbinding", oldShadow);
            ContentManager cm = this.getContentManager(oldShadow);
            if (cm != null) {
                cm.dispose();
            }
            elt.setShadowTree(null);
            XBLRecord rec = this.getRecord(oldShadow);
            rec.boundElement = null;
            oldShadow.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.docSubtreeListener, false);
        }
        if (newShadow != null) {
            newShadow.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", this.docSubtreeListener, false, null);
            this.fireShadowTreeEvent(elt, "prebind", newShadow);
            elt.setShadowTree(newShadow);
            XBLRecord rec = this.getRecord(newShadow);
            rec.boundElement = elt;
            AbstractDocument doc = (AbstractDocument)elt.getOwnerDocument();
            XBLManager xm = doc.getXBLManager();
            ContentManager cm = new ContentManager(newShadow, xm);
            this.setContentManager(newShadow, cm);
        }
        this.invalidateChildNodes(elt);
        if (newShadow != null) {
            NodeList nl = this.getXblScopedChildNodes(elt);
            for (int i2 = 0; i2 < nl.getLength(); ++i2) {
                Node n2 = nl.item(i2);
                if (n2.getNodeType() != 1) continue;
                this.bind((Element)n2);
            }
            this.dispatchBindingChangedEvent(elt, newShadow);
            this.fireShadowTreeEvent(elt, "bound", newShadow);
        } else {
            this.dispatchBindingChangedEvent(elt, newShadow);
        }
    }

    protected void fireShadowTreeEvent(BindableElement elt, String type, XBLShadowTreeElement e2) {
        DocumentEvent de = (DocumentEvent)((Object)elt.getOwnerDocument());
        ShadowTreeEvent evt = (ShadowTreeEvent)de.createEvent("ShadowTreeEvent");
        evt.initShadowTreeEventNS("http://www.w3.org/2004/xbl", type, true, false, e2);
        elt.dispatchEvent(evt);
    }

    protected XBLOMShadowTreeElement cloneTemplate(XBLOMTemplateElement template) {
        XBLOMShadowTreeElement clone = (XBLOMShadowTreeElement)template.getOwnerDocument().createElementNS("http://www.w3.org/2004/xbl", "shadowTree");
        NamedNodeMap attrs = template.getAttributes();
        for (int i2 = 0; i2 < attrs.getLength(); ++i2) {
            Attr attr = (Attr)attrs.item(i2);
            if (attr instanceof AbstractAttrNS) {
                clone.setAttributeNodeNS(attr);
                continue;
            }
            clone.setAttributeNode(attr);
        }
        for (Node n2 = template.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            clone.appendChild(n2.cloneNode(true));
        }
        return clone;
    }

    @Override
    public Node getXblParentNode(Node n2) {
        Node parent;
        XBLOMContentElement contentElement = this.getXblContentElement(n2);
        Node node = parent = contentElement == null ? n2.getParentNode() : contentElement.getParentNode();
        if (parent instanceof XBLOMContentElement) {
            parent = parent.getParentNode();
        }
        if (parent instanceof XBLOMShadowTreeElement) {
            parent = this.getXblBoundElement(parent);
        }
        return parent;
    }

    @Override
    public NodeList getXblChildNodes(Node n2) {
        XBLRecord rec = this.getRecord(n2);
        if (rec.childNodes == null) {
            rec.childNodes = new XblChildNodes(rec);
        }
        return rec.childNodes;
    }

    @Override
    public NodeList getXblScopedChildNodes(Node n2) {
        XBLRecord rec = this.getRecord(n2);
        if (rec.scopedChildNodes == null) {
            rec.scopedChildNodes = new XblScopedChildNodes(rec);
        }
        return rec.scopedChildNodes;
    }

    @Override
    public Node getXblFirstChild(Node n2) {
        NodeList nl = this.getXblChildNodes(n2);
        return nl.item(0);
    }

    @Override
    public Node getXblLastChild(Node n2) {
        NodeList nl = this.getXblChildNodes(n2);
        return nl.item(nl.getLength() - 1);
    }

    @Override
    public Node getXblPreviousSibling(Node n2) {
        Node p2 = this.getXblParentNode(n2);
        if (p2 == null || this.getRecord((Node)p2).childNodes == null) {
            return n2.getPreviousSibling();
        }
        XBLRecord rec = this.getRecord(n2);
        if (!rec.linksValid) {
            this.updateLinks(n2);
        }
        return rec.previousSibling;
    }

    @Override
    public Node getXblNextSibling(Node n2) {
        Node p2 = this.getXblParentNode(n2);
        if (p2 == null || this.getRecord((Node)p2).childNodes == null) {
            return n2.getNextSibling();
        }
        XBLRecord rec = this.getRecord(n2);
        if (!rec.linksValid) {
            this.updateLinks(n2);
        }
        return rec.nextSibling;
    }

    @Override
    public Element getXblFirstElementChild(Node n2) {
        n2 = this.getXblFirstChild(n2);
        while (n2 != null && n2.getNodeType() != 1) {
            n2 = this.getXblNextSibling(n2);
        }
        return (Element)n2;
    }

    @Override
    public Element getXblLastElementChild(Node n2) {
        n2 = this.getXblLastChild(n2);
        while (n2 != null && n2.getNodeType() != 1) {
            n2 = this.getXblPreviousSibling(n2);
        }
        return (Element)n2;
    }

    @Override
    public Element getXblPreviousElementSibling(Node n2) {
        while ((n2 = this.getXblPreviousSibling(n2)) != null && n2.getNodeType() != 1) {
        }
        return (Element)n2;
    }

    @Override
    public Element getXblNextElementSibling(Node n2) {
        while ((n2 = this.getXblNextSibling(n2)) != null && n2.getNodeType() != 1) {
        }
        return (Element)n2;
    }

    @Override
    public Element getXblBoundElement(Node n2) {
        while (n2 != null && !(n2 instanceof XBLShadowTreeElement)) {
            XBLOMContentElement content = this.getXblContentElement(n2);
            if (content != null) {
                n2 = content;
            }
            n2 = n2.getParentNode();
        }
        if (n2 == null) {
            return null;
        }
        return this.getRecord((Node)n2).boundElement;
    }

    @Override
    public Element getXblShadowTree(Node n2) {
        if (n2 instanceof BindableElement) {
            BindableElement elt = (BindableElement)n2;
            return elt.getShadowTree();
        }
        return null;
    }

    @Override
    public NodeList getXblDefinitions(Node n2) {
        final String namespaceURI = n2.getNamespaceURI();
        final String localName = n2.getLocalName();
        return new NodeList(){

            @Override
            public Node item(int i2) {
                TreeSet defs = (TreeSet)DefaultXBLManager.this.definitionLists.get(namespaceURI, localName);
                if (defs != null && defs.size() != 0 && i2 == 0) {
                    DefinitionRecord defRec = (DefinitionRecord)defs.first();
                    return defRec.definition;
                }
                return null;
            }

            @Override
            public int getLength() {
                TreeSet defs = (TreeSet)DefaultXBLManager.this.definitionLists.get(namespaceURI, localName);
                return defs != null && defs.size() != 0 ? 1 : 0;
            }
        };
    }

    protected XBLRecord getRecord(Node n2) {
        XBLManagerData xmd = (XBLManagerData)((Object)n2);
        XBLRecord rec = (XBLRecord)xmd.getManagerData();
        if (rec == null) {
            rec = new XBLRecord();
            rec.node = n2;
            xmd.setManagerData(rec);
        }
        return rec;
    }

    protected void updateLinks(Node n2) {
        NodeList xcn;
        XBLRecord rec = this.getRecord(n2);
        rec.previousSibling = null;
        rec.nextSibling = null;
        rec.linksValid = true;
        Node p2 = this.getXblParentNode(n2);
        if (p2 != null && (xcn = this.getXblChildNodes(p2)) instanceof XblChildNodes) {
            ((XblChildNodes)xcn).update();
        }
    }

    public XBLOMContentElement getXblContentElement(Node n2) {
        return this.getRecord((Node)n2).contentElement;
    }

    public static int computeBubbleLimit(Node from, Node to) {
        ArrayList<Node> fromList = new ArrayList<Node>(10);
        ArrayList<Node> toList = new ArrayList<Node>(10);
        while (from != null) {
            fromList.add(from);
            from = ((NodeXBL)((Object)from)).getXblParentNode();
        }
        while (to != null) {
            toList.add(to);
            to = ((NodeXBL)((Object)to)).getXblParentNode();
        }
        int fromSize = fromList.size();
        int toSize = toList.size();
        for (int i2 = 0; i2 < fromSize && i2 < toSize; ++i2) {
            Node n2;
            Node n1 = (Node)fromList.get(fromSize - i2 - 1);
            if (n1 == (n2 = (Node)toList.get(toSize - i2 - 1))) continue;
            Element prevBoundElement = ((NodeXBL)((Object)n1)).getXblBoundElement();
            while (i2 > 0 && prevBoundElement != fromList.get(fromSize - i2 - 1)) {
                --i2;
            }
            return fromSize - i2 - 1;
        }
        return 1;
    }

    public ContentManager getContentManager(Node n2) {
        Element s2;
        Element b2 = this.getXblBoundElement(n2);
        if (b2 != null && (s2 = this.getXblShadowTree(b2)) != null) {
            ContentManager cm;
            Document doc = b2.getOwnerDocument();
            if (doc != this.document) {
                DefaultXBLManager xm = (DefaultXBLManager)((AbstractDocument)doc).getXBLManager();
                cm = (ContentManager)xm.contentManagers.get(s2);
            } else {
                cm = (ContentManager)this.contentManagers.get(s2);
            }
            return cm;
        }
        return null;
    }

    void setContentManager(Element shadow, ContentManager cm) {
        if (cm == null) {
            this.contentManagers.remove(shadow);
        } else {
            this.contentManagers.put(shadow, cm);
        }
    }

    public void invalidateChildNodes(Node n2) {
        XBLRecord rec = this.getRecord(n2);
        if (rec.childNodes != null) {
            rec.childNodes.invalidate();
        }
        if (rec.scopedChildNodes != null) {
            rec.scopedChildNodes.invalidate();
        }
    }

    public void addContentSelectionChangedListener(ContentSelectionChangedListener l2) {
        this.contentSelectionChangedListenerList.add(ContentSelectionChangedListener.class, l2);
    }

    public void removeContentSelectionChangedListener(ContentSelectionChangedListener l2) {
        this.contentSelectionChangedListenerList.remove(ContentSelectionChangedListener.class, l2);
    }

    protected Object[] getContentSelectionChangedListeners() {
        return this.contentSelectionChangedListenerList.getListenerList();
    }

    void shadowTreeSelectedContentChanged(Set deselected, Set selected) {
        for (Node n2 : deselected) {
            if (n2.getNodeType() != 1) continue;
            this.unbind((Element)n2);
        }
        for (Node n2 : selected) {
            if (n2.getNodeType() != 1) continue;
            this.bind((Element)n2);
        }
    }

    public void addBindingListener(BindingListener l2) {
        this.bindingListenerList.add(BindingListener.class, l2);
    }

    public void removeBindingListener(BindingListener l2) {
        this.bindingListenerList.remove(BindingListener.class, l2);
    }

    protected void dispatchBindingChangedEvent(Element bindableElement, Element shadowTree) {
        Object[] ls = this.bindingListenerList.getListenerList();
        for (int i2 = ls.length - 2; i2 >= 0; i2 -= 2) {
            BindingListener l2 = (BindingListener)ls[i2 + 1];
            l2.bindingChanged(bindableElement, shadowTree);
        }
    }

    protected boolean isActiveDefinition(XBLOMDefinitionElement def, Element imp) {
        DefinitionRecord defRec = (DefinitionRecord)this.definitions.get(def, imp);
        if (defRec == null) {
            return false;
        }
        return defRec == this.getActiveDefinition(defRec.namespaceURI, defRec.localName);
    }

    protected class XblScopedChildNodes
    extends XblChildNodes {
        public XblScopedChildNodes(XBLRecord rec) {
            super(rec);
        }

        @Override
        protected void update() {
            Node n2;
            this.size = 0;
            Element shadowTree = DefaultXBLManager.this.getXblShadowTree(this.record.node);
            Node node = n2 = shadowTree == null ? this.record.node.getFirstChild() : shadowTree.getFirstChild();
            while (n2 != null) {
                this.collectXblScopedChildNodes(n2);
                n2 = n2.getNextSibling();
            }
        }

        protected void collectXblScopedChildNodes(Node n2) {
            boolean isChild = false;
            if (n2.getNodeType() == 1) {
                ContentManager cm;
                if (!n2.getNamespaceURI().equals("http://www.w3.org/2004/xbl")) {
                    isChild = true;
                } else if (n2 instanceof XBLOMContentElement && (cm = DefaultXBLManager.this.getContentManager(n2)) != null) {
                    NodeList selected = cm.getSelectedContent((XBLOMContentElement)n2);
                    for (int i2 = 0; i2 < selected.getLength(); ++i2) {
                        this.collectXblScopedChildNodes(selected.item(i2));
                    }
                }
            } else {
                isChild = true;
            }
            if (isChild) {
                this.nodes.add(n2);
                ++this.size;
            }
        }
    }

    protected class XblChildNodes
    implements NodeList {
        protected XBLRecord record;
        protected List nodes;
        protected int size;

        public XblChildNodes(XBLRecord rec) {
            this.record = rec;
            this.nodes = new ArrayList();
            this.size = -1;
        }

        protected void update() {
            Node m2;
            this.size = 0;
            Element shadowTree = DefaultXBLManager.this.getXblShadowTree(this.record.node);
            Node last = null;
            Node node = m2 = shadowTree == null ? this.record.node.getFirstChild() : shadowTree.getFirstChild();
            while (m2 != null) {
                last = this.collectXblChildNodes(m2, last);
                m2 = m2.getNextSibling();
            }
            if (last != null) {
                XBLRecord rec = DefaultXBLManager.this.getRecord(last);
                rec.nextSibling = null;
                rec.linksValid = true;
            }
        }

        protected Node collectXblChildNodes(Node n2, Node prev) {
            boolean isChild = false;
            if (n2.getNodeType() == 1) {
                ContentManager cm;
                if (!"http://www.w3.org/2004/xbl".equals(n2.getNamespaceURI())) {
                    isChild = true;
                } else if (n2 instanceof XBLOMContentElement && (cm = DefaultXBLManager.this.getContentManager(n2)) != null) {
                    NodeList selected = cm.getSelectedContent((XBLOMContentElement)n2);
                    for (int i2 = 0; i2 < selected.getLength(); ++i2) {
                        prev = this.collectXblChildNodes(selected.item(i2), prev);
                    }
                }
            } else {
                isChild = true;
            }
            if (isChild) {
                XBLRecord rec;
                this.nodes.add(n2);
                ++this.size;
                if (prev != null) {
                    rec = DefaultXBLManager.this.getRecord(prev);
                    rec.nextSibling = n2;
                    rec.linksValid = true;
                }
                rec = DefaultXBLManager.this.getRecord(n2);
                rec.previousSibling = prev;
                rec.linksValid = true;
                prev = n2;
            }
            return prev;
        }

        public void invalidate() {
            for (int i2 = 0; i2 < this.size; ++i2) {
                XBLRecord rec = DefaultXBLManager.this.getRecord((Node)this.nodes.get(i2));
                rec.previousSibling = null;
                rec.nextSibling = null;
                rec.linksValid = false;
            }
            this.nodes.clear();
            this.size = -1;
        }

        public Node getFirstNode() {
            if (this.size == -1) {
                this.update();
            }
            return this.size == 0 ? null : (Node)this.nodes.get(0);
        }

        public Node getLastNode() {
            if (this.size == -1) {
                this.update();
            }
            return this.size == 0 ? null : (Node)this.nodes.get(this.nodes.size() - 1);
        }

        @Override
        public Node item(int index) {
            if (this.size == -1) {
                this.update();
            }
            if (index < 0 || index >= this.size) {
                return null;
            }
            return (Node)this.nodes.get(index);
        }

        @Override
        public int getLength() {
            if (this.size == -1) {
                this.update();
            }
            return this.size;
        }
    }

    protected class XBLRecord {
        public Node node;
        public XblChildNodes childNodes;
        public XblScopedChildNodes scopedChildNodes;
        public XBLOMContentElement contentElement;
        public XBLOMDefinitionElement definitionElement;
        public BindableElement boundElement;
        public boolean linksValid;
        public Node nextSibling;
        public Node previousSibling;

        protected XBLRecord() {
        }
    }

    protected class RefAttrListener
    implements EventListener {
        protected RefAttrListener() {
        }

        @Override
        public void handleEvent(Event evt) {
            EventTarget target = evt.getTarget();
            if (target != evt.getCurrentTarget()) {
                return;
            }
            MutationEvent mevt = (MutationEvent)evt;
            if (mevt.getAttrName().equals("ref")) {
                Element defRef = (Element)((Object)target);
                DefaultXBLManager.this.removeDefinitionRef(defRef);
                if (mevt.getNewValue().length() == 0) {
                    XBLOMDefinitionElement def = (XBLOMDefinitionElement)defRef;
                    String ns = def.getElementNamespaceURI();
                    String ln = def.getElementLocalName();
                    DefaultXBLManager.this.addDefinition(ns, ln, (XBLOMDefinitionElement)defRef, null);
                } else {
                    DefaultXBLManager.this.addDefinitionRef(defRef);
                }
            }
        }
    }

    protected class ImportAttrListener
    implements EventListener {
        protected ImportAttrListener() {
        }

        @Override
        public void handleEvent(Event evt) {
            EventTarget target = evt.getTarget();
            if (target != evt.getCurrentTarget()) {
                return;
            }
            MutationEvent mevt = (MutationEvent)evt;
            if (mevt.getAttrName().equals("bindings")) {
                Element imp = (Element)((Object)target);
                DefaultXBLManager.this.removeImport(imp);
                DefaultXBLManager.this.addImport(imp);
            }
        }
    }

    protected class DefNodeRemovedListener
    implements EventListener {
        protected Element importElement;

        public DefNodeRemovedListener(Element imp) {
            this.importElement = imp;
        }

        @Override
        public void handleEvent(Event evt) {
            MutationEvent mevt = (MutationEvent)evt;
            Node parent = mevt.getRelatedNode();
            if (!(parent instanceof XBLOMDefinitionElement)) {
                return;
            }
            EventTarget target = evt.getTarget();
            if (!(target instanceof XBLOMTemplateElement)) {
                return;
            }
            XBLOMTemplateElement template = (XBLOMTemplateElement)target;
            DefinitionRecord defRec = (DefinitionRecord)DefaultXBLManager.this.definitions.get(parent, this.importElement);
            if (defRec == null || defRec.template != template) {
                return;
            }
            ImportRecord ir = (ImportRecord)DefaultXBLManager.this.imports.get(this.importElement);
            DefaultXBLManager.this.removeTemplateElementListeners(template, ir);
            defRec.template = null;
            for (Node n2 = template.getNextSibling(); n2 != null; n2 = n2.getNextSibling()) {
                if (!(n2 instanceof XBLOMTemplateElement)) continue;
                defRec.template = (XBLOMTemplateElement)n2;
                break;
            }
            DefaultXBLManager.this.addTemplateElementListeners(defRec.template, ir);
            DefaultXBLManager.this.rebind(defRec.namespaceURI, defRec.localName, DefaultXBLManager.this.document.getDocumentElement());
        }
    }

    protected class DefNodeInsertedListener
    implements EventListener {
        protected Element importElement;

        public DefNodeInsertedListener(Element imp) {
            this.importElement = imp;
        }

        @Override
        public void handleEvent(Event evt) {
            MutationEvent mevt = (MutationEvent)evt;
            Node parent = mevt.getRelatedNode();
            if (!(parent instanceof XBLOMDefinitionElement)) {
                return;
            }
            EventTarget target = evt.getTarget();
            if (!(target instanceof XBLOMTemplateElement)) {
                return;
            }
            XBLOMTemplateElement template = (XBLOMTemplateElement)target;
            DefinitionRecord defRec = (DefinitionRecord)DefaultXBLManager.this.definitions.get(parent, this.importElement);
            if (defRec == null) {
                return;
            }
            ImportRecord ir = (ImportRecord)DefaultXBLManager.this.imports.get(this.importElement);
            if (defRec.template != null) {
                for (Node n2 = parent.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                    if (n2 == template) {
                        DefaultXBLManager.this.removeTemplateElementListeners(defRec.template, ir);
                        defRec.template = template;
                        break;
                    }
                    if (n2 != defRec.template) continue;
                    return;
                }
            } else {
                defRec.template = template;
            }
            DefaultXBLManager.this.addTemplateElementListeners(template, ir);
            DefaultXBLManager.this.rebind(defRec.namespaceURI, defRec.localName, DefaultXBLManager.this.document.getDocumentElement());
        }
    }

    protected class DefAttrListener
    implements EventListener {
        protected Element importElement;

        public DefAttrListener(Element imp) {
            this.importElement = imp;
        }

        @Override
        public void handleEvent(Event evt) {
            EventTarget target = evt.getTarget();
            if (!(target instanceof XBLOMDefinitionElement)) {
                return;
            }
            XBLOMDefinitionElement def = (XBLOMDefinitionElement)target;
            if (!DefaultXBLManager.this.isActiveDefinition(def, this.importElement)) {
                return;
            }
            MutationEvent mevt = (MutationEvent)evt;
            String attrName = mevt.getAttrName();
            if (attrName.equals("element")) {
                DefinitionRecord defRec = (DefinitionRecord)DefaultXBLManager.this.definitions.get(def, this.importElement);
                DefaultXBLManager.this.removeDefinition(defRec);
                DefaultXBLManager.this.addDefinition(def.getElementNamespaceURI(), def.getElementLocalName(), def, this.importElement);
            } else if (attrName.equals("ref") && mevt.getNewValue().length() != 0) {
                DefinitionRecord defRec = (DefinitionRecord)DefaultXBLManager.this.definitions.get(def, this.importElement);
                DefaultXBLManager.this.removeDefinition(defRec);
                DefaultXBLManager.this.addDefinitionRef(def);
            }
        }
    }

    protected class TemplateMutationListener
    implements EventListener {
        protected Element importElement;

        public TemplateMutationListener(Element imp) {
            this.importElement = imp;
        }

        @Override
        public void handleEvent(Event evt) {
            Node n2;
            for (n2 = (Node)((Object)evt.getTarget()); n2 != null && !(n2 instanceof XBLOMDefinitionElement); n2 = n2.getParentNode()) {
            }
            DefinitionRecord defRec = (DefinitionRecord)DefaultXBLManager.this.definitions.get(n2, this.importElement);
            if (defRec == null) {
                return;
            }
            DefaultXBLManager.this.rebind(defRec.namespaceURI, defRec.localName, DefaultXBLManager.this.document.getDocumentElement());
        }
    }

    protected class DocSubtreeListener
    implements EventListener {
        protected DocSubtreeListener() {
        }

        @Override
        public void handleEvent(Event evt) {
            Object[] defs = DefaultXBLManager.this.docRemovedListener.defsToBeRemoved.toArray();
            DefaultXBLManager.this.docRemovedListener.defsToBeRemoved.clear();
            for (Object def1 : defs) {
                XBLOMDefinitionElement def = (XBLOMDefinitionElement)def1;
                if (def.getAttributeNS(null, "ref").length() == 0) {
                    DefinitionRecord defRec = (DefinitionRecord)DefaultXBLManager.this.definitions.get(def, null);
                    DefaultXBLManager.this.removeDefinition(defRec);
                    continue;
                }
                DefaultXBLManager.this.removeDefinitionRef(def);
            }
            Object[] imps = DefaultXBLManager.this.docRemovedListener.importsToBeRemoved.toArray();
            DefaultXBLManager.this.docRemovedListener.importsToBeRemoved.clear();
            for (Object imp : imps) {
                DefaultXBLManager.this.removeImport((Element)imp);
            }
            Object[] nodes = DefaultXBLManager.this.docRemovedListener.nodesToBeInvalidated.toArray();
            DefaultXBLManager.this.docRemovedListener.nodesToBeInvalidated.clear();
            for (Object node : nodes) {
                DefaultXBLManager.this.invalidateChildNodes((Node)node);
            }
        }
    }

    protected class DocRemovedListener
    implements EventListener {
        protected LinkedList defsToBeRemoved = new LinkedList();
        protected LinkedList importsToBeRemoved = new LinkedList();
        protected LinkedList nodesToBeInvalidated = new LinkedList();

        protected DocRemovedListener() {
        }

        @Override
        public void handleEvent(Event evt) {
            Node parent;
            EventTarget target = evt.getTarget();
            if (target instanceof XBLOMDefinitionElement) {
                if (DefaultXBLManager.this.getXblBoundElement((Node)((Object)target)) == null) {
                    this.defsToBeRemoved.add(target);
                }
            } else if (target instanceof XBLOMImportElement && DefaultXBLManager.this.getXblBoundElement((Node)((Object)target)) == null) {
                this.importsToBeRemoved.add(target);
            }
            if ((parent = DefaultXBLManager.this.getXblParentNode((Node)((Object)target))) != null) {
                this.nodesToBeInvalidated.add(parent);
            }
        }
    }

    protected class DocInsertedListener
    implements EventListener {
        protected DocInsertedListener() {
        }

        @Override
        public void handleEvent(Event evt) {
            EventTarget target = evt.getTarget();
            if (target instanceof XBLOMDefinitionElement) {
                if (DefaultXBLManager.this.getXblBoundElement((Node)((Object)target)) == null) {
                    XBLOMDefinitionElement def = (XBLOMDefinitionElement)target;
                    if (def.getAttributeNS(null, "ref").length() == 0) {
                        DefaultXBLManager.this.addDefinition(def.getElementNamespaceURI(), def.getElementLocalName(), def, null);
                    } else {
                        DefaultXBLManager.this.addDefinitionRef(def);
                    }
                }
            } else if (target instanceof XBLOMImportElement) {
                if (DefaultXBLManager.this.getXblBoundElement((Node)((Object)target)) == null) {
                    DefaultXBLManager.this.addImport((Element)((Object)target));
                }
            } else {
                target = (evt = XBLEventSupport.getUltimateOriginalEvent(evt)).getTarget();
                Node parent = DefaultXBLManager.this.getXblParentNode((Node)((Object)target));
                if (parent != null) {
                    DefaultXBLManager.this.invalidateChildNodes(parent);
                }
                if (target instanceof BindableElement) {
                    for (Node n2 = ((Node)((Object)target)).getParentNode(); n2 != null; n2 = n2.getParentNode()) {
                        if (!(n2 instanceof BindableElement) || DefaultXBLManager.this.getRecord((Node)n2).definitionElement == null) continue;
                        return;
                    }
                    DefaultXBLManager.this.bind((Element)((Object)target));
                }
            }
        }
    }

    protected class ImportSubtreeListener
    implements EventListener {
        protected Element importElement;
        protected ImportRemovedListener importRemovedListener;

        public ImportSubtreeListener(Element imp, ImportRemovedListener irl) {
            this.importElement = imp;
            this.importRemovedListener = irl;
        }

        @Override
        public void handleEvent(Event evt) {
            Object[] defs = this.importRemovedListener.toBeRemoved.toArray();
            this.importRemovedListener.toBeRemoved.clear();
            for (Object def1 : defs) {
                XBLOMDefinitionElement def = (XBLOMDefinitionElement)def1;
                DefinitionRecord defRec = (DefinitionRecord)DefaultXBLManager.this.definitions.get(def, this.importElement);
                DefaultXBLManager.this.removeDefinition(defRec);
            }
        }
    }

    protected static class ImportRemovedListener
    implements EventListener {
        protected LinkedList toBeRemoved = new LinkedList();

        protected ImportRemovedListener() {
        }

        @Override
        public void handleEvent(Event evt) {
            this.toBeRemoved.add(evt.getTarget());
        }
    }

    protected class ImportInsertedListener
    implements EventListener {
        protected Element importElement;

        public ImportInsertedListener(Element importElement) {
            this.importElement = importElement;
        }

        @Override
        public void handleEvent(Event evt) {
            EventTarget target = evt.getTarget();
            if (target instanceof XBLOMDefinitionElement) {
                XBLOMDefinitionElement def = (XBLOMDefinitionElement)target;
                DefaultXBLManager.this.addDefinition(def.getElementNamespaceURI(), def.getElementLocalName(), def, this.importElement);
            }
        }
    }

    protected class ImportRecord {
        public Element importElement;
        public Node node;
        public DefNodeInsertedListener defNodeInsertedListener;
        public DefNodeRemovedListener defNodeRemovedListener;
        public DefAttrListener defAttrListener;
        public ImportInsertedListener importInsertedListener;
        public ImportRemovedListener importRemovedListener;
        public ImportSubtreeListener importSubtreeListener;
        public TemplateMutationListener templateMutationListener;

        public ImportRecord(Element imp, Node n2) {
            this.importElement = imp;
            this.node = n2;
            this.defNodeInsertedListener = new DefNodeInsertedListener(imp);
            this.defNodeRemovedListener = new DefNodeRemovedListener(imp);
            this.defAttrListener = new DefAttrListener(imp);
            this.importInsertedListener = new ImportInsertedListener(imp);
            this.importRemovedListener = new ImportRemovedListener();
            this.importSubtreeListener = new ImportSubtreeListener(imp, this.importRemovedListener);
            this.templateMutationListener = new TemplateMutationListener(imp);
        }
    }

    protected static class DefinitionRecord
    implements Comparable {
        public String namespaceURI;
        public String localName;
        public XBLOMDefinitionElement definition;
        public XBLOMTemplateElement template;
        public Element importElement;

        public DefinitionRecord(String ns, String ln, XBLOMDefinitionElement def, XBLOMTemplateElement t2, Element imp) {
            this.namespaceURI = ns;
            this.localName = ln;
            this.definition = def;
            this.template = t2;
            this.importElement = imp;
        }

        public boolean equals(Object other) {
            return this.compareTo(other) == 0;
        }

        public int compareTo(Object other) {
            AbstractNode n2;
            AbstractNode n1;
            DefinitionRecord rec = (DefinitionRecord)other;
            if (this.importElement == null) {
                n1 = this.definition;
                n2 = rec.importElement == null ? rec.definition : (AbstractNode)((Object)rec.importElement);
            } else if (rec.importElement == null) {
                n1 = (AbstractNode)((Object)this.importElement);
                n2 = rec.definition;
            } else if (this.definition.getOwnerDocument() == rec.definition.getOwnerDocument()) {
                n1 = this.definition;
                n2 = rec.definition;
            } else {
                n1 = (AbstractNode)((Object)this.importElement);
                n2 = (AbstractNode)((Object)rec.importElement);
            }
            short comp = n1.compareDocumentPosition(n2);
            if ((comp & 2) != 0) {
                return -1;
            }
            if ((comp & 4) != 0) {
                return 1;
            }
            return 0;
        }
    }
}

