/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import java.util.List;
import org.apache.batik.anim.dom.SVGOMAElement;
import org.apache.batik.anim.dom.SVGOMAnimationElement;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.CursorManager;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGAElement;

public class SVGAElementBridge
extends SVGGElementBridge {
    protected AnchorListener al;
    protected CursorMouseOverListener bl;
    protected CursorMouseOutListener cl;

    @Override
    public String getLocalName() {
        return "a";
    }

    @Override
    public Bridge getInstance() {
        return new SVGAElementBridge();
    }

    @Override
    public void buildGraphicsNode(BridgeContext ctx, Element e2, GraphicsNode node) {
        super.buildGraphicsNode(ctx, e2, node);
        if (ctx.isInteractive()) {
            NodeEventTarget target = (NodeEventTarget)((Object)e2);
            CursorHolder ch = new CursorHolder(CursorManager.DEFAULT_CURSOR);
            this.al = new AnchorListener(ctx.getUserAgent(), ch);
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.al, false, null);
            ctx.storeEventListenerNS(target, "http://www.w3.org/2001/xml-events", "click", this.al, false);
            this.bl = new CursorMouseOverListener(ctx.getUserAgent(), ch);
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.bl, false, null);
            ctx.storeEventListenerNS(target, "http://www.w3.org/2001/xml-events", "mouseover", this.bl, false);
            this.cl = new CursorMouseOutListener(ctx.getUserAgent(), ch);
            target.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.cl, false, null);
            ctx.storeEventListenerNS(target, "http://www.w3.org/2001/xml-events", "mouseout", this.cl, false);
        }
    }

    @Override
    public void dispose() {
        NodeEventTarget target = (NodeEventTarget)((Object)this.e);
        if (this.al != null) {
            target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "click", this.al, false);
            this.al = null;
        }
        if (this.bl != null) {
            target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", this.bl, false);
            this.bl = null;
        }
        if (this.cl != null) {
            target.removeEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", this.cl, false);
            this.cl = null;
        }
        super.dispose();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public static class MouseOutDefaultActionable
    implements Runnable {
        protected SVGAElement elt;
        protected UserAgent userAgent;
        protected CursorHolder holder;

        public MouseOutDefaultActionable(SVGAElement e2, UserAgent ua, CursorHolder ch) {
            this.elt = e2;
            this.userAgent = ua;
            this.holder = ch;
        }

        @Override
        public void run() {
            if (this.elt != null) {
                this.userAgent.displayMessage("");
            }
        }
    }

    public static class CursorMouseOutListener
    implements EventListener {
        protected UserAgent userAgent;
        protected CursorHolder holder;

        public CursorMouseOutListener(UserAgent ua, CursorHolder ch) {
            this.userAgent = ua;
            this.holder = ch;
        }

        @Override
        public void handleEvent(Event evt) {
            if (!(evt instanceof AbstractEvent)) {
                return;
            }
            AbstractEvent ae = (AbstractEvent)evt;
            List l2 = ae.getDefaultActions();
            if (l2 != null) {
                for (Object o2 : l2) {
                    if (!(o2 instanceof MouseOutDefaultActionable)) continue;
                    return;
                }
            }
            SVGAElement elt = (SVGAElement)evt.getCurrentTarget();
            ae.addDefaultAction(new MouseOutDefaultActionable(elt, this.userAgent, this.holder));
        }
    }

    public static class MouseOverDefaultActionable
    implements Runnable {
        protected Element target;
        protected SVGAElement elt;
        protected UserAgent userAgent;
        protected CursorHolder holder;

        public MouseOverDefaultActionable(Element t2, SVGAElement e2, UserAgent ua, CursorHolder ch) {
            this.target = t2;
            this.elt = e2;
            this.userAgent = ua;
            this.holder = ch;
        }

        @Override
        public void run() {
            if (CSSUtilities.isAutoCursor(this.target)) {
                this.holder.holdCursor(CursorManager.DEFAULT_CURSOR);
                this.userAgent.setSVGCursor(CursorManager.ANCHOR_CURSOR);
            }
            if (this.elt != null) {
                String href = this.elt.getHref().getAnimVal();
                this.userAgent.displayMessage(href);
            }
        }
    }

    public static class CursorMouseOverListener
    implements EventListener {
        protected UserAgent userAgent;
        protected CursorHolder holder;

        public CursorMouseOverListener(UserAgent ua, CursorHolder ch) {
            this.userAgent = ua;
            this.holder = ch;
        }

        @Override
        public void handleEvent(Event evt) {
            if (!(evt instanceof AbstractEvent)) {
                return;
            }
            AbstractEvent ae = (AbstractEvent)evt;
            List l2 = ae.getDefaultActions();
            if (l2 != null) {
                for (Object o2 : l2) {
                    if (!(o2 instanceof MouseOverDefaultActionable)) continue;
                    return;
                }
            }
            Element target = (Element)((Object)ae.getTarget());
            SVGAElement elt = (SVGAElement)ae.getCurrentTarget();
            ae.addDefaultAction(new MouseOverDefaultActionable(target, elt, this.userAgent, this.holder));
        }
    }

    public static class AnchorDefaultActionable
    implements Runnable {
        protected SVGOMAElement elt;
        protected UserAgent userAgent;
        protected CursorHolder holder;

        public AnchorDefaultActionable(SVGAElement e2, UserAgent ua, CursorHolder ch) {
            this.elt = (SVGOMAElement)e2;
            this.userAgent = ua;
            this.holder = ch;
        }

        @Override
        public void run() {
            Element refElt;
            String frag;
            this.userAgent.setSVGCursor(this.holder.getCursor());
            String href = this.elt.getHref().getAnimVal();
            ParsedURL purl = new ParsedURL(this.elt.getBaseURI(), href);
            SVGOMDocument doc = (SVGOMDocument)this.elt.getOwnerDocument();
            ParsedURL durl = doc.getParsedURL();
            if (purl.sameFile(durl) && (frag = purl.getRef()) != null && frag.length() != 0 && (refElt = doc.getElementById(frag)) instanceof SVGOMAnimationElement) {
                SVGOMAnimationElement aelt = (SVGOMAnimationElement)refElt;
                float t2 = aelt.getHyperlinkBeginTime();
                if (Float.isNaN(t2)) {
                    aelt.beginElement();
                } else {
                    doc.getRootElement().setCurrentTime(t2);
                }
                return;
            }
            this.userAgent.openLink(this.elt);
        }
    }

    public static class AnchorListener
    implements EventListener {
        protected UserAgent userAgent;
        protected CursorHolder holder;

        public AnchorListener(UserAgent ua, CursorHolder ch) {
            this.userAgent = ua;
            this.holder = ch;
        }

        @Override
        public void handleEvent(Event evt) {
            if (!(evt instanceof AbstractEvent)) {
                return;
            }
            AbstractEvent ae = (AbstractEvent)evt;
            List l2 = ae.getDefaultActions();
            if (l2 != null) {
                for (Object o2 : l2) {
                    if (!(o2 instanceof AnchorDefaultActionable)) continue;
                    return;
                }
            }
            SVGAElement elt = (SVGAElement)evt.getCurrentTarget();
            ae.addDefaultAction(new AnchorDefaultActionable(elt, this.userAgent, this.holder));
        }
    }

    public static class CursorHolder {
        Cursor cursor = null;

        public CursorHolder(Cursor c2) {
            this.cursor = c2;
        }

        public void holdCursor(Cursor c2) {
            this.cursor = c2;
        }

        public Cursor getCursor() {
            return this.cursor;
        }
    }
}

