/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.LinkedList;
import java.util.List;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.FontFace;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.FontFaceRule;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.ValueManager;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.SVGConstants;

public class CSSFontFace
extends FontFace
implements SVGConstants {
    GVTFontFamily fontFamily = null;

    public CSSFontFace(List srcs, String familyName, float unitsPerEm, String fontWeight, String fontStyle, String fontVariant, String fontStretch, float slope, String panose1, float ascent, float descent, float strikethroughPosition, float strikethroughThickness, float underlinePosition, float underlineThickness, float overlinePosition, float overlineThickness) {
        super(srcs, familyName, unitsPerEm, fontWeight, fontStyle, fontVariant, fontStretch, slope, panose1, ascent, descent, strikethroughPosition, strikethroughThickness, underlinePosition, underlineThickness, overlinePosition, overlineThickness);
    }

    protected CSSFontFace(String familyName) {
        super(familyName);
    }

    public static CSSFontFace createCSSFontFace(CSSEngine eng, FontFaceRule ffr) {
        StyleMap sm = ffr.getStyleMap();
        String familyName = CSSFontFace.getStringProp(sm, eng, 21);
        CSSFontFace ret = new CSSFontFace(familyName);
        Value v2 = sm.getValue(27);
        if (v2 != null) {
            ret.fontWeight = v2.getCssText();
        }
        if ((v2 = sm.getValue(25)) != null) {
            ret.fontStyle = v2.getCssText();
        }
        if ((v2 = sm.getValue(26)) != null) {
            ret.fontVariant = v2.getCssText();
        }
        if ((v2 = sm.getValue(24)) != null) {
            ret.fontStretch = v2.getCssText();
        }
        v2 = sm.getValue(41);
        ParsedURL base = ffr.getURL();
        if (v2 != null && v2 != ValueConstants.NONE_VALUE) {
            if (v2.getCssValueType() == 1) {
                ret.srcs = new LinkedList();
                ret.srcs.add(CSSFontFace.getSrcValue(v2, base));
            } else if (v2.getCssValueType() == 2) {
                ret.srcs = new LinkedList();
                for (int i2 = 0; i2 < v2.getLength(); ++i2) {
                    ret.srcs.add(CSSFontFace.getSrcValue(v2.item(i2), base));
                }
            }
        }
        return ret;
    }

    public static Object getSrcValue(Value v2, ParsedURL base) {
        if (v2.getCssValueType() != 1) {
            return null;
        }
        if (v2.getPrimitiveType() == 20) {
            if (base != null) {
                return new ParsedURL(base, v2.getStringValue());
            }
            return new ParsedURL(v2.getStringValue());
        }
        if (v2.getPrimitiveType() == 19) {
            return v2.getStringValue();
        }
        return null;
    }

    public static String getStringProp(StyleMap sm, CSSEngine eng, int pidx) {
        Value v2 = sm.getValue(pidx);
        ValueManager[] vms = eng.getValueManagers();
        if (v2 == null) {
            ValueManager vm = vms[pidx];
            v2 = vm.getDefaultValue();
        }
        while (v2.getCssValueType() == 2) {
            v2 = v2.item(0);
        }
        return v2.getStringValue();
    }

    public static float getFloatProp(StyleMap sm, CSSEngine eng, int pidx) {
        Value v2 = sm.getValue(pidx);
        ValueManager[] vms = eng.getValueManagers();
        if (v2 == null) {
            ValueManager vm = vms[pidx];
            v2 = vm.getDefaultValue();
        }
        while (v2.getCssValueType() == 2) {
            v2 = v2.item(0);
        }
        return v2.getFloatValue();
    }

    @Override
    public GVTFontFamily getFontFamily(BridgeContext ctx) {
        if (this.fontFamily != null) {
            return this.fontFamily;
        }
        this.fontFamily = super.getFontFamily(ctx);
        return this.fontFamily;
    }
}

