/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.io.File;
import org.apache.batik.apps.svgbrowser.JSVGViewerFrame;
import org.apache.batik.apps.svgbrowser.SquiggleInputHandler;
import org.apache.batik.util.ParsedURL;

public class SVGInputHandler
implements SquiggleInputHandler {
    public static final String[] SVG_MIME_TYPES = new String[]{"image/svg+xml"};
    public static final String[] SVG_FILE_EXTENSIONS = new String[]{".svg", ".svgz"};

    @Override
    public String[] getHandledMimeTypes() {
        return SVG_MIME_TYPES;
    }

    @Override
    public String[] getHandledExtensions() {
        return SVG_FILE_EXTENSIONS;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public void handle(ParsedURL purl, JSVGViewerFrame svgViewerFrame) {
        svgViewerFrame.getJSVGCanvas().loadSVGDocument(purl.toString());
    }

    @Override
    public boolean accept(File f2) {
        return f2 != null && f2.isFile() && this.accept(f2.getPath());
    }

    @Override
    public boolean accept(ParsedURL purl) {
        if (purl == null) {
            return false;
        }
        String path = purl.getPath();
        if (path == null) {
            return false;
        }
        return this.accept(path);
    }

    public boolean accept(String path) {
        if (path == null) {
            return false;
        }
        for (String SVG_FILE_EXTENSION : SVG_FILE_EXTENSIONS) {
            if (!path.endsWith(SVG_FILE_EXTENSION)) continue;
            return true;
        }
        return false;
    }
}

