/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.batik.anim.dom.AnimatedAttributeListener;
import org.apache.batik.anim.dom.AnimatedLiveAttributeValue;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGStylableElement;
import org.apache.batik.anim.dom.SVGStyleSheetProcessingInstruction;
import org.apache.batik.css.engine.CSSNavigableDocument;
import org.apache.batik.css.engine.CSSNavigableDocumentListener;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.dom.AbstractStylableDocument;
import org.apache.batik.dom.GenericAttr;
import org.apache.batik.dom.GenericAttrNS;
import org.apache.batik.dom.GenericCDATASection;
import org.apache.batik.dom.GenericComment;
import org.apache.batik.dom.GenericDocumentFragment;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericEntityReference;
import org.apache.batik.dom.GenericProcessingInstruction;
import org.apache.batik.dom.GenericText;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.events.EventSupport;
import org.apache.batik.dom.svg.IdContainer;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.dom.util.XMLSupport;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGLangSpace;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGOMDocument
extends AbstractStylableDocument
implements SVGDocument,
SVGConstants,
CSSNavigableDocument,
IdContainer {
    protected static final String RESOURCES = "org.apache.batik.dom.svg.resources.Messages";
    protected transient LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.svg.resources.Messages", this.getClass().getClassLoader());
    protected String referrer = "";
    protected ParsedURL url;
    protected transient boolean readonly;
    protected boolean isSVG12;
    protected HashMap cssNavigableDocumentListeners = new HashMap();
    protected AnimatedAttributeListener mainAnimatedAttributeListener = new AnimAttrListener();
    protected LinkedList animatedAttributeListeners = new LinkedList();
    protected transient SVGContext svgContext;

    protected SVGOMDocument() {
    }

    public SVGOMDocument(DocumentType dt, DOMImplementation impl) {
        super(dt, impl);
    }

    @Override
    public void setLocale(Locale l2) {
        super.setLocale(l2);
        this.localizableSupport.setLocale(l2);
    }

    @Override
    public String formatMessage(String key, Object[] args) throws MissingResourceException {
        try {
            return super.formatMessage(key, args);
        }
        catch (MissingResourceException e2) {
            return this.localizableSupport.formatMessage(key, args);
        }
    }

    @Override
    public String getTitle() {
        StringBuffer sb = new StringBuffer();
        boolean preserve = false;
        for (Node n2 = this.getDocumentElement().getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            String ns = n2.getNamespaceURI();
            if (ns == null || !ns.equals("http://www.w3.org/2000/svg") || !n2.getLocalName().equals("title")) continue;
            preserve = ((SVGLangSpace)((Object)n2)).getXMLspace().equals("preserve");
            for (n2 = n2.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
                if (n2.getNodeType() != 3) continue;
                sb.append(n2.getNodeValue());
            }
            break;
        }
        String s2 = sb.toString();
        return preserve ? XMLSupport.preserveXMLSpace(s2) : XMLSupport.defaultXMLSpace(s2);
    }

    @Override
    public String getReferrer() {
        return this.referrer;
    }

    public void setReferrer(String s2) {
        this.referrer = s2;
    }

    @Override
    public String getDomain() {
        return this.url == null ? null : this.url.getHost();
    }

    @Override
    public SVGSVGElement getRootElement() {
        return (SVGSVGElement)this.getDocumentElement();
    }

    @Override
    public String getURL() {
        return this.documentURI;
    }

    public URL getURLObject() {
        try {
            return new URL(this.documentURI);
        }
        catch (MalformedURLException e2) {
            return null;
        }
    }

    public ParsedURL getParsedURL() {
        return this.url;
    }

    public void setURLObject(URL url) {
        this.setParsedURL(new ParsedURL(url));
    }

    public void setParsedURL(ParsedURL url) {
        this.url = url;
        this.documentURI = url == null ? null : url.toString();
    }

    @Override
    public void setDocumentURI(String uri) {
        this.documentURI = uri;
        this.url = uri == null ? null : new ParsedURL(uri);
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        return new GenericElement(tagName.intern(), this);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return new GenericDocumentFragment(this);
    }

    @Override
    public Text createTextNode(String data) {
        return new GenericText(data, this);
    }

    @Override
    public Comment createComment(String data) {
        return new GenericComment(data, this);
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        return new GenericCDATASection(data, this);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if ("xml-stylesheet".equals(target)) {
            return new SVGStyleSheetProcessingInstruction(data, this, (StyleSheetFactory)((Object)this.getImplementation()));
        }
        return new GenericProcessingInstruction(target, data, this);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return new GenericAttr(name.intern(), this);
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        return new GenericEntityReference(name, this);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        if (namespaceURI == null) {
            return new GenericAttr(qualifiedName.intern(), this);
        }
        return new GenericAttrNS(namespaceURI.intern(), qualifiedName.intern(), this);
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        SVGDOMImplementation impl = (SVGDOMImplementation)this.implementation;
        return impl.createElementNS(this, namespaceURI, qualifiedName);
    }

    public boolean isSVG12() {
        return this.isSVG12;
    }

    public void setIsSVG12(boolean b2) {
        this.isSVG12 = b2;
    }

    @Override
    public boolean isId(Attr node) {
        if (node.getNamespaceURI() == null) {
            return "id".equals(node.getNodeName());
        }
        return node.getNodeName().equals("xml:id");
    }

    public void setSVGContext(SVGContext ctx) {
        this.svgContext = ctx;
    }

    public SVGContext getSVGContext() {
        return this.svgContext;
    }

    @Override
    public void addCSSNavigableDocumentListener(CSSNavigableDocumentListener l2) {
        if (this.cssNavigableDocumentListeners.containsKey(l2)) {
            return;
        }
        DOMNodeInsertedListenerWrapper nodeInserted = new DOMNodeInsertedListenerWrapper(l2);
        DOMNodeRemovedListenerWrapper nodeRemoved = new DOMNodeRemovedListenerWrapper(l2);
        DOMSubtreeModifiedListenerWrapper subtreeModified = new DOMSubtreeModifiedListenerWrapper(l2);
        DOMCharacterDataModifiedListenerWrapper cdataModified = new DOMCharacterDataModifiedListenerWrapper(l2);
        DOMAttrModifiedListenerWrapper attrModified = new DOMAttrModifiedListenerWrapper(l2);
        this.cssNavigableDocumentListeners.put(l2, new EventListener[]{nodeInserted, nodeRemoved, subtreeModified, cdataModified, attrModified});
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", nodeInserted, false, null);
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", nodeRemoved, false, null);
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", subtreeModified, false, null);
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", cdataModified, false, null);
        this.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", attrModified, false, null);
    }

    @Override
    public void removeCSSNavigableDocumentListener(CSSNavigableDocumentListener l2) {
        EventListener[] listeners = (EventListener[])this.cssNavigableDocumentListeners.get(l2);
        if (listeners == null) {
            return;
        }
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", listeners[0], false);
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", listeners[1], false);
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", listeners[2], false);
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", listeners[3], false);
        this.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", listeners[4], false);
        this.cssNavigableDocumentListeners.remove(l2);
    }

    protected AnimatedAttributeListener getAnimatedAttributeListener() {
        return this.mainAnimatedAttributeListener;
    }

    protected void overrideStyleTextChanged(CSSStylableElement e2, String text) {
        for (Object o2 : this.cssNavigableDocumentListeners.keySet()) {
            CSSNavigableDocumentListener l2 = (CSSNavigableDocumentListener)o2;
            l2.overrideStyleTextChanged(e2, text);
        }
    }

    protected void overrideStylePropertyRemoved(CSSStylableElement e2, String name) {
        for (Object o2 : this.cssNavigableDocumentListeners.keySet()) {
            CSSNavigableDocumentListener l2 = (CSSNavigableDocumentListener)o2;
            l2.overrideStylePropertyRemoved(e2, name);
        }
    }

    protected void overrideStylePropertyChanged(CSSStylableElement e2, String name, String value, String prio) {
        for (Object o2 : this.cssNavigableDocumentListeners.keySet()) {
            CSSNavigableDocumentListener l2 = (CSSNavigableDocumentListener)o2;
            l2.overrideStylePropertyChanged(e2, name, value, prio);
        }
    }

    public void addAnimatedAttributeListener(AnimatedAttributeListener aal) {
        if (this.animatedAttributeListeners.contains(aal)) {
            return;
        }
        this.animatedAttributeListeners.add(aal);
    }

    public void removeAnimatedAttributeListener(AnimatedAttributeListener aal) {
        this.animatedAttributeListeners.remove(aal);
    }

    @Override
    public CSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        if (elt instanceof SVGStylableElement && pseudoElt == null) {
            return ((SVGStylableElement)elt).getOverrideStyle();
        }
        return null;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public void setReadonly(boolean v2) {
        this.readonly = v2;
    }

    @Override
    protected Node newNode() {
        return new SVGOMDocument();
    }

    @Override
    protected Node copyInto(Node n2) {
        super.copyInto(n2);
        SVGOMDocument sd = (SVGOMDocument)n2;
        sd.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        sd.referrer = this.referrer;
        sd.url = this.url;
        return n2;
    }

    @Override
    protected Node deepCopyInto(Node n2) {
        super.deepCopyInto(n2);
        SVGOMDocument sd = (SVGOMDocument)n2;
        sd.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
        sd.referrer = this.referrer;
        sd.url = this.url;
        return n2;
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.localizableSupport = new LocalizableSupport(RESOURCES, this.getClass().getClassLoader());
    }

    protected class AnimAttrListener
    implements AnimatedAttributeListener {
        protected AnimAttrListener() {
        }

        @Override
        public void animatedAttributeChanged(Element e2, AnimatedLiveAttributeValue alav) {
            for (Object animatedAttributeListener : SVGOMDocument.this.animatedAttributeListeners) {
                AnimatedAttributeListener aal = (AnimatedAttributeListener)animatedAttributeListener;
                aal.animatedAttributeChanged(e2, alav);
            }
        }

        @Override
        public void otherAnimationChanged(Element e2, String type) {
            for (Object animatedAttributeListener : SVGOMDocument.this.animatedAttributeListeners) {
                AnimatedAttributeListener aal = (AnimatedAttributeListener)animatedAttributeListener;
                aal.otherAnimationChanged(e2, type);
            }
        }
    }

    protected static class DOMAttrModifiedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMAttrModifiedListenerWrapper(CSSNavigableDocumentListener l2) {
            this.listener = l2;
        }

        @Override
        public void handleEvent(Event evt) {
            evt = EventSupport.getUltimateOriginalEvent(evt);
            MutationEvent mevt = (MutationEvent)evt;
            this.listener.attrModified((Element)((Object)evt.getTarget()), (Attr)mevt.getRelatedNode(), mevt.getAttrChange(), mevt.getPrevValue(), mevt.getNewValue());
        }
    }

    protected static class DOMCharacterDataModifiedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMCharacterDataModifiedListenerWrapper(CSSNavigableDocumentListener l2) {
            this.listener = l2;
        }

        @Override
        public void handleEvent(Event evt) {
            evt = EventSupport.getUltimateOriginalEvent(evt);
            this.listener.characterDataModified((Node)((Object)evt.getTarget()));
        }
    }

    protected static class DOMSubtreeModifiedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMSubtreeModifiedListenerWrapper(CSSNavigableDocumentListener l2) {
            this.listener = l2;
        }

        @Override
        public void handleEvent(Event evt) {
            evt = EventSupport.getUltimateOriginalEvent(evt);
            this.listener.subtreeModified((Node)((Object)evt.getTarget()));
        }
    }

    protected static class DOMNodeRemovedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMNodeRemovedListenerWrapper(CSSNavigableDocumentListener l2) {
            this.listener = l2;
        }

        @Override
        public void handleEvent(Event evt) {
            evt = EventSupport.getUltimateOriginalEvent(evt);
            this.listener.nodeToBeRemoved((Node)((Object)evt.getTarget()));
        }
    }

    protected static class DOMNodeInsertedListenerWrapper
    implements EventListener {
        protected CSSNavigableDocumentListener listener;

        public DOMNodeInsertedListenerWrapper(CSSNavigableDocumentListener l2) {
            this.listener = l2;
        }

        @Override
        public void handleEvent(Event evt) {
            evt = EventSupport.getUltimateOriginalEvent(evt);
            this.listener.nodeInserted((Node)((Object)evt.getTarget()));
        }
    }
}

