/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.debug;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.BlankDebugEventListener;
import org.antlr.runtime.debug.DebugParser;
import org.antlr.runtime.misc.DoubleKeyMap;

public class Profiler
extends BlankDebugEventListener {
    public static final String DATA_SEP = "\t";
    public static final String newline = System.getProperty("line.separator");
    static boolean dump = false;
    public static final String Version = "3";
    public static final String RUNTIME_STATS_FILENAME = "runtime.stats";
    public DebugParser parser = null;
    protected int ruleLevel = 0;
    protected Token lastRealTokenTouchedInDecision;
    protected Set<String> uniqueRules = new HashSet<String>();
    protected Stack<String> currentGrammarFileName = new Stack();
    protected Stack<String> currentRuleName = new Stack();
    protected Stack<Integer> currentLine = new Stack();
    protected Stack<Integer> currentPos = new Stack();
    protected DoubleKeyMap<String, Integer, DecisionDescriptor> decisions = new DoubleKeyMap();
    protected List<DecisionEvent> decisionEvents = new ArrayList<DecisionEvent>();
    protected Stack<DecisionEvent> decisionStack = new Stack();
    protected int backtrackDepth;
    ProfileStats stats = new ProfileStats();

    public Profiler() {
    }

    public Profiler(DebugParser parser) {
        this.parser = parser;
    }

    public void enterRule(String grammarFileName, String ruleName) {
        ++this.ruleLevel;
        ++this.stats.numRuleInvocations;
        this.uniqueRules.add(grammarFileName + ":" + ruleName);
        this.stats.maxRuleInvocationDepth = Math.max(this.stats.maxRuleInvocationDepth, this.ruleLevel);
        this.currentGrammarFileName.push(grammarFileName);
        this.currentRuleName.push(ruleName);
    }

    public void exitRule(String grammarFileName, String ruleName) {
        --this.ruleLevel;
        this.currentGrammarFileName.pop();
        this.currentRuleName.pop();
    }

    public void examineRuleMemoization(IntStream input, int ruleIndex, int stopIndex, String ruleName) {
        if (dump) {
            System.out.println("examine memo " + ruleName + " at " + input.index() + ": " + stopIndex);
        }
        if (stopIndex == -1) {
            ++this.stats.numMemoizationCacheMisses;
            ++this.stats.numGuessingRuleInvocations;
            ++this.currentDecision().numMemoizationCacheMisses;
        } else {
            ++this.stats.numMemoizationCacheHits;
            ++this.currentDecision().numMemoizationCacheHits;
        }
    }

    public void memoize(IntStream input, int ruleIndex, int ruleStartIndex, String ruleName) {
        if (dump) {
            System.out.println("memoize " + ruleName);
        }
        ++this.stats.numMemoizationCacheEntries;
    }

    public void location(int line, int pos) {
        this.currentLine.push(new Integer(line));
        this.currentPos.push(new Integer(pos));
    }

    public void enterDecision(int decisionNumber, boolean couldBacktrack) {
        String g2;
        DecisionDescriptor descriptor;
        this.lastRealTokenTouchedInDecision = null;
        ++this.stats.numDecisionEvents;
        int startingLookaheadIndex = this.parser.getTokenStream().index();
        TokenStream input = this.parser.getTokenStream();
        if (dump) {
            System.out.println("enterDecision canBacktrack=" + couldBacktrack + " " + decisionNumber + " backtrack depth " + this.backtrackDepth + " @ " + input.get(input.index()) + " rule " + this.locationDescription());
        }
        if ((descriptor = this.decisions.get(g2 = this.currentGrammarFileName.peek(), new Integer(decisionNumber))) == null) {
            descriptor = new DecisionDescriptor();
            this.decisions.put(g2, new Integer(decisionNumber), descriptor);
            descriptor.decision = decisionNumber;
            descriptor.fileName = this.currentGrammarFileName.peek();
            descriptor.ruleName = this.currentRuleName.peek();
            descriptor.line = this.currentLine.peek();
            descriptor.pos = this.currentPos.peek();
            descriptor.couldBacktrack = couldBacktrack;
        }
        ++descriptor.n;
        DecisionEvent d2 = new DecisionEvent();
        this.decisionStack.push(d2);
        d2.decision = descriptor;
        d2.startTime = System.currentTimeMillis();
        d2.startIndex = startingLookaheadIndex;
    }

    public void exitDecision(int decisionNumber) {
        int depth;
        DecisionEvent d2 = this.decisionStack.pop();
        d2.stopTime = System.currentTimeMillis();
        int lastTokenIndex = this.lastRealTokenTouchedInDecision.getTokenIndex();
        int numHidden = this.getNumberOfHiddenTokens(d2.startIndex, lastTokenIndex);
        d2.k = depth = lastTokenIndex - d2.startIndex - numHidden + 1;
        d2.decision.maxk = Math.max(d2.decision.maxk, depth);
        if (dump) {
            System.out.println("exitDecision " + decisionNumber + " in " + d2.decision.ruleName + " lookahead " + d2.k + " max token " + this.lastRealTokenTouchedInDecision);
        }
        this.decisionEvents.add(d2);
    }

    public void consumeToken(Token token) {
        if (dump) {
            System.out.println("consume token " + token);
        }
        if (!this.inDecision()) {
            ++this.stats.numTokens;
            return;
        }
        if (this.lastRealTokenTouchedInDecision == null || this.lastRealTokenTouchedInDecision.getTokenIndex() < token.getTokenIndex()) {
            this.lastRealTokenTouchedInDecision = token;
        }
        DecisionEvent d2 = this.currentDecision();
        int thisRefIndex = token.getTokenIndex();
        int numHidden = this.getNumberOfHiddenTokens(d2.startIndex, thisRefIndex);
        int depth = thisRefIndex - d2.startIndex - numHidden + 1;
        if (dump) {
            System.out.println("consume " + thisRefIndex + " " + depth + " tokens ahead in " + d2.decision.ruleName + "-" + d2.decision.decision + " start index " + d2.startIndex);
        }
    }

    public boolean inDecision() {
        return this.decisionStack.size() > 0;
    }

    public void consumeHiddenToken(Token token) {
        if (!this.inDecision()) {
            ++this.stats.numHiddenTokens;
        }
    }

    public void LT(int i2, Token t2) {
        if (this.inDecision() && i2 > 0) {
            DecisionEvent d2 = this.currentDecision();
            if (dump) {
                System.out.println("LT(" + i2 + ")=" + t2 + " index " + t2.getTokenIndex() + " relative to " + d2.decision.ruleName + "-" + d2.decision.decision + " start index " + d2.startIndex);
            }
            if (this.lastRealTokenTouchedInDecision == null || this.lastRealTokenTouchedInDecision.getTokenIndex() < t2.getTokenIndex()) {
                this.lastRealTokenTouchedInDecision = t2;
                if (dump) {
                    System.out.println("set last token " + this.lastRealTokenTouchedInDecision);
                }
            }
        }
    }

    public void beginBacktrack(int level) {
        if (dump) {
            System.out.println("enter backtrack " + level);
        }
        ++this.backtrackDepth;
        DecisionEvent e2 = this.currentDecision();
        if (e2.decision.couldBacktrack) {
            ++this.stats.numBacktrackOccurrences;
            ++e2.decision.numBacktrackOccurrences;
            e2.backtracks = true;
        }
    }

    public void endBacktrack(int level, boolean successful) {
        if (dump) {
            System.out.println("exit backtrack " + level + ": " + successful);
        }
        --this.backtrackDepth;
    }

    public void mark(int i2) {
        if (dump) {
            System.out.println("mark " + i2);
        }
    }

    public void rewind(int i2) {
        if (dump) {
            System.out.println("rewind " + i2);
        }
    }

    public void rewind() {
        if (dump) {
            System.out.println("rewind");
        }
    }

    protected DecisionEvent currentDecision() {
        return this.decisionStack.peek();
    }

    public void recognitionException(RecognitionException e2) {
        ++this.stats.numReportedErrors;
    }

    public void semanticPredicate(boolean result, String predicate) {
        ++this.stats.numSemanticPredicates;
        if (this.inDecision()) {
            DecisionEvent d2 = this.currentDecision();
            d2.evalSemPred = true;
            ++d2.decision.numSemPredEvals;
            if (dump) {
                System.out.println("eval " + predicate + " in " + d2.decision.ruleName + "-" + d2.decision.decision);
            }
        }
    }

    public void terminate() {
        Iterator<Object> i$ = this.decisionEvents.iterator();
        while (i$.hasNext()) {
            DecisionEvent e2 = i$.next();
            e2.decision.avgk += (float)e2.k;
            this.stats.avgkPerDecisionEvent += (float)e2.k;
            if (!e2.backtracks) continue;
            this.stats.avgkPerBacktrackingDecisionEvent += (float)e2.k;
        }
        this.stats.averageDecisionPercentBacktracks = 0.0f;
        i$ = this.decisions.values().iterator();
        while (i$.hasNext()) {
            DecisionDescriptor d2 = (DecisionDescriptor)i$.next();
            ++this.stats.numDecisionsCovered;
            d2.avgk = (float)((double)d2.avgk / (double)d2.n);
            if (d2.couldBacktrack) {
                ++this.stats.numDecisionsThatPotentiallyBacktrack;
                float percentBacktracks = (float)d2.numBacktrackOccurrences / (float)d2.n;
                this.stats.averageDecisionPercentBacktracks += percentBacktracks;
            }
            if (d2.numBacktrackOccurrences <= 0) continue;
            ++this.stats.numDecisionsThatDoBacktrack;
        }
        this.stats.averageDecisionPercentBacktracks /= (float)this.stats.numDecisionsThatPotentiallyBacktrack;
        this.stats.averageDecisionPercentBacktracks *= 100.0f;
        this.stats.avgkPerDecisionEvent /= (float)this.stats.numDecisionEvents;
        this.stats.avgkPerBacktrackingDecisionEvent = (float)((double)this.stats.avgkPerBacktrackingDecisionEvent / (double)this.stats.numBacktrackOccurrences);
        System.err.println(this.toString());
        System.err.println(this.getDecisionStatsDump());
    }

    public void setParser(DebugParser parser) {
        this.parser = parser;
    }

    public String toNotifyString() {
        StringBuffer buf = new StringBuffer();
        buf.append(Version);
        buf.append('\t');
        buf.append(this.parser.getClass().getName());
        return buf.toString();
    }

    public String toString() {
        return Profiler.toString(this.getReport());
    }

    public ProfileStats getReport() {
        this.stats.Version = Version;
        this.stats.name = this.parser.getClass().getName();
        this.stats.numUniqueRulesInvoked = this.uniqueRules.size();
        return this.stats;
    }

    public DoubleKeyMap getDecisionStats() {
        return this.decisions;
    }

    public List getDecisionEvents() {
        return this.decisionEvents;
    }

    public static String toString(ProfileStats stats) {
        StringBuffer buf = new StringBuffer();
        buf.append("ANTLR Runtime Report; Profile Version ");
        buf.append(stats.Version);
        buf.append(newline);
        buf.append("parser name ");
        buf.append(stats.name);
        buf.append(newline);
        buf.append("Number of rule invocations ");
        buf.append(stats.numRuleInvocations);
        buf.append(newline);
        buf.append("Number of unique rules visited ");
        buf.append(stats.numUniqueRulesInvoked);
        buf.append(newline);
        buf.append("Number of decision events ");
        buf.append(stats.numDecisionEvents);
        buf.append(newline);
        buf.append("Overall average k per decision event ");
        buf.append(stats.avgkPerDecisionEvent);
        buf.append(newline);
        buf.append("Number of backtracking occurrences (can be multiple per decision) ");
        buf.append(stats.numBacktrackOccurrences);
        buf.append(newline);
        buf.append("Overall average k per decision event that backtracks ");
        buf.append(stats.avgkPerBacktrackingDecisionEvent);
        buf.append(newline);
        buf.append("Number of rule invocations while backtracking ");
        buf.append(stats.numGuessingRuleInvocations);
        buf.append(newline);
        buf.append("num decisions that potentially backtrack ");
        buf.append(stats.numDecisionsThatPotentiallyBacktrack);
        buf.append(newline);
        buf.append("num decisions that do backtrack ");
        buf.append(stats.numDecisionsThatDoBacktrack);
        buf.append(newline);
        buf.append("num decisions that potentially backtrack but don't ");
        buf.append(stats.numDecisionsThatPotentiallyBacktrack - stats.numDecisionsThatDoBacktrack);
        buf.append(newline);
        buf.append("average % of time a potentially backtracking decision backtracks ");
        buf.append(stats.averageDecisionPercentBacktracks);
        buf.append(newline);
        buf.append("num unique decisions covered ");
        buf.append(stats.numDecisionsCovered);
        buf.append(newline);
        buf.append("max rule invocation nesting depth ");
        buf.append(stats.maxRuleInvocationDepth);
        buf.append(newline);
        buf.append("rule memoization cache size ");
        buf.append(stats.numMemoizationCacheEntries);
        buf.append(newline);
        buf.append("number of rule memoization cache hits ");
        buf.append(stats.numMemoizationCacheHits);
        buf.append(newline);
        buf.append("number of rule memoization cache misses ");
        buf.append(stats.numMemoizationCacheMisses);
        buf.append(newline);
        buf.append("number of tokens ");
        buf.append(stats.numTokens);
        buf.append(newline);
        buf.append("number of hidden tokens ");
        buf.append(stats.numHiddenTokens);
        buf.append(newline);
        buf.append("number of char ");
        buf.append(stats.numCharsMatched);
        buf.append(newline);
        buf.append("number of hidden char ");
        buf.append(stats.numHiddenCharsMatched);
        buf.append(newline);
        buf.append("number of syntax errors ");
        buf.append(stats.numReportedErrors);
        buf.append(newline);
        return buf.toString();
    }

    public String getDecisionStatsDump() {
        StringBuffer buf = new StringBuffer();
        buf.append("location");
        buf.append(DATA_SEP);
        buf.append("n");
        buf.append(DATA_SEP);
        buf.append("avgk");
        buf.append(DATA_SEP);
        buf.append("maxk");
        buf.append(DATA_SEP);
        buf.append("synpred");
        buf.append(DATA_SEP);
        buf.append("sempred");
        buf.append(DATA_SEP);
        buf.append("canbacktrack");
        buf.append("\n");
        Iterator<String> i$ = this.decisions.keySet().iterator();
        while (i$.hasNext()) {
            String fileName = i$.next();
            Iterator<Integer> i$2 = this.decisions.keySet(fileName).iterator();
            while (i$2.hasNext()) {
                int d2 = i$2.next();
                DecisionDescriptor s2 = this.decisions.get(fileName, new Integer(d2));
                buf.append(s2.decision);
                buf.append("@");
                buf.append(this.locationDescription(s2.fileName, s2.ruleName, s2.line, s2.pos));
                buf.append(DATA_SEP);
                buf.append(s2.n);
                buf.append(DATA_SEP);
                buf.append(String.format("%.2f", new Float(s2.avgk)));
                buf.append(DATA_SEP);
                buf.append(s2.maxk);
                buf.append(DATA_SEP);
                buf.append(s2.numBacktrackOccurrences);
                buf.append(DATA_SEP);
                buf.append(s2.numSemPredEvals);
                buf.append(DATA_SEP);
                buf.append(s2.couldBacktrack ? "1" : "0");
                buf.append(newline);
            }
        }
        return buf.toString();
    }

    protected int[] trim(int[] X2, int n2) {
        if (n2 < X2.length) {
            int[] trimmed = new int[n2];
            System.arraycopy(X2, 0, trimmed, 0, n2);
            X2 = trimmed;
        }
        return X2;
    }

    protected int[] toArray(List a2) {
        int[] x2 = new int[a2.size()];
        for (int i2 = 0; i2 < a2.size(); ++i2) {
            Integer I2 = (Integer)a2.get(i2);
            x2[i2] = I2;
        }
        return x2;
    }

    public int getNumberOfHiddenTokens(int i2, int j2) {
        int n2 = 0;
        TokenStream input = this.parser.getTokenStream();
        for (int ti = i2; ti < input.size() && ti <= j2; ++ti) {
            Token t2 = input.get(ti);
            if (t2.getChannel() == 0) continue;
            ++n2;
        }
        return n2;
    }

    protected String locationDescription() {
        return this.locationDescription(this.currentGrammarFileName.peek(), this.currentRuleName.peek(), this.currentLine.peek(), this.currentPos.peek());
    }

    protected String locationDescription(String file, String rule, int line, int pos) {
        return file + ":" + line + ":" + pos + "(" + rule + ")";
    }

    public static class DecisionEvent {
        public DecisionDescriptor decision;
        public int startIndex;
        public int k;
        public boolean backtracks;
        public boolean evalSemPred;
        public long startTime;
        public long stopTime;
        public int numMemoizationCacheHits;
        public int numMemoizationCacheMisses;
    }

    public static class DecisionDescriptor {
        public int decision;
        public String fileName;
        public String ruleName;
        public int line;
        public int pos;
        public boolean couldBacktrack;
        public int n;
        public float avgk;
        public int maxk;
        public int numBacktrackOccurrences;
        public int numSemPredEvals;
    }

    public static class ProfileStats {
        public String Version;
        public String name;
        public int numRuleInvocations;
        public int numUniqueRulesInvoked;
        public int numDecisionEvents;
        public int numDecisionsCovered;
        public int numDecisionsThatPotentiallyBacktrack;
        public int numDecisionsThatDoBacktrack;
        public int maxRuleInvocationDepth;
        public float avgkPerDecisionEvent;
        public float avgkPerBacktrackingDecisionEvent;
        public float averageDecisionPercentBacktracks;
        public int numBacktrackOccurrences;
        public int numFixedDecisions;
        public int minDecisionMaxFixedLookaheads;
        public int maxDecisionMaxFixedLookaheads;
        public int avgDecisionMaxFixedLookaheads;
        public int stddevDecisionMaxFixedLookaheads;
        public int numCyclicDecisions;
        public int minDecisionMaxCyclicLookaheads;
        public int maxDecisionMaxCyclicLookaheads;
        public int avgDecisionMaxCyclicLookaheads;
        public int stddevDecisionMaxCyclicLookaheads;
        public int numSemanticPredicates;
        public int numTokens;
        public int numHiddenTokens;
        public int numCharsMatched;
        public int numHiddenCharsMatched;
        public int numReportedErrors;
        public int numMemoizationCacheHits;
        public int numMemoizationCacheMisses;
        public int numGuessingRuleInvocations;
        public int numMemoizationCacheEntries;
    }
}

