/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.Tool;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAOptimizer;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Label;
import org.antlr.analysis.LookaheadSet;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.Transition;
import org.antlr.codegen.ACyclicDFACodeGenerator;
import org.antlr.codegen.Target;
import org.antlr.grammar.v3.ANTLRLexer;
import org.antlr.grammar.v3.ANTLRParser;
import org.antlr.grammar.v3.ActionTranslator;
import org.antlr.grammar.v3.CodeGenTreeWalker;
import org.antlr.misc.BitSet;
import org.antlr.misc.IntSet;
import org.antlr.misc.Interval;
import org.antlr.misc.IntervalSet;
import org.antlr.misc.Utils;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.tool.AttributeScope;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.Rule;
import org.stringtemplate.v4.AutoIndentWriter;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerator {
    public static final int MSCL_DEFAULT = 300;
    public static int MAX_SWITCH_CASE_LABELS = 300;
    public static final int MSA_DEFAULT = 3;
    public static int MIN_SWITCH_ALTS = 3;
    public boolean GENERATE_SWITCHES_WHEN_POSSIBLE = true;
    public static boolean LAUNCH_ST_INSPECTOR = false;
    public static final int MADSI_DEFAULT = 60;
    public static int MAX_ACYCLIC_DFA_STATES_INLINE = 60;
    public static String classpathTemplateRootDirectoryName = "org/antlr/codegen/templates";
    public Grammar grammar;
    protected String language;
    public Target target = null;
    protected STGroup templates;
    protected STGroup baseTemplates;
    protected ST recognizerST;
    protected ST outputFileST;
    protected ST headerFileST;
    protected int uniqueLabelNumber = 1;
    protected Tool tool;
    protected boolean debug;
    protected boolean trace;
    protected boolean profile;
    protected int lineWidth = 72;
    public ACyclicDFACodeGenerator acyclicDFAGenerator = new ACyclicDFACodeGenerator(this);
    public static final String VOCAB_FILE_EXTENSION = ".tokens";
    protected static final String vocabFilePattern = "<tokens:{it|<it.name>=<it.type>\n}><literals:{it|<it.name>=<it.type>\n}>";

    public CodeGenerator(Tool tool, Grammar grammar, String language) {
        this.tool = tool;
        this.grammar = grammar;
        this.language = language;
        this.target = CodeGenerator.loadLanguageTarget(language);
    }

    public static Target loadLanguageTarget(String language) {
        Target target = null;
        String targetName = new StringBuffer().append("org.antlr.codegen.").append(language).append("Target").toString();
        try {
            Class<?> c2 = Class.forName(targetName);
            target = (Target)c2.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            target = new Target();
        }
        catch (InstantiationException ie) {
            ErrorManager.error(23, (Object)targetName, ie);
        }
        catch (IllegalAccessException cnfe) {
            ErrorManager.error(23, (Object)targetName, cnfe);
        }
        return target;
    }

    public void loadTemplates(String language) {
        String langDir = new StringBuffer().append(classpathTemplateRootDirectoryName).append("/").append(language).toString();
        STGroupFile coreTemplates = new STGroupFile(new StringBuffer().append(langDir).append("/").append(language).append(".stg").toString());
        this.baseTemplates = coreTemplates;
        if (coreTemplates == null) {
            ErrorManager.error(20, language);
            return;
        }
        String outputOption = (String)this.grammar.getOption("output");
        if (outputOption != null && outputOption.equals("AST")) {
            if (this.debug && this.grammar.type != 1) {
                STGroupFile dbgTemplates = new STGroupFile(new StringBuffer().append(langDir).append("/Dbg.stg").toString());
                dbgTemplates.importTemplates(coreTemplates);
                this.baseTemplates = dbgTemplates;
                STGroupFile astTemplates = new STGroupFile(new StringBuffer().append(langDir).append("/AST.stg").toString());
                astTemplates.importTemplates(dbgTemplates);
                STGroupFile astParserTemplates = astTemplates;
                if (this.grammar.type == 3) {
                    astParserTemplates = new STGroupFile(new StringBuffer().append(langDir).append("/ASTTreeParser.stg").toString());
                    astParserTemplates.importTemplates(astTemplates);
                } else {
                    astParserTemplates = new STGroupFile(new StringBuffer().append(langDir).append("/ASTParser.stg").toString());
                    astParserTemplates.importTemplates(astTemplates);
                }
                STGroupFile astDbgTemplates = new STGroupFile(new StringBuffer().append(langDir).append("/ASTDbg.stg").toString());
                astDbgTemplates.importTemplates(astParserTemplates);
                this.templates = astDbgTemplates;
                dbgTemplates.iterateAcrossValues = true;
                astDbgTemplates.iterateAcrossValues = true;
                astParserTemplates.iterateAcrossValues = true;
            } else {
                STGroupFile astTemplates = new STGroupFile(new StringBuffer().append(langDir).append("/AST.stg").toString());
                astTemplates.importTemplates(coreTemplates);
                STGroupFile astParserTemplates = astTemplates;
                if (this.grammar.type == 3) {
                    astParserTemplates = new STGroupFile(new StringBuffer().append(langDir).append("/ASTTreeParser.stg").toString());
                    astParserTemplates.importTemplates(astTemplates);
                } else {
                    astParserTemplates = new STGroupFile(new StringBuffer().append(langDir).append("/ASTParser.stg").toString());
                    astParserTemplates.importTemplates(astTemplates);
                }
                this.templates = astParserTemplates;
                astTemplates.iterateAcrossValues = true;
                astParserTemplates.iterateAcrossValues = true;
            }
        } else if (outputOption != null && outputOption.equals("template")) {
            if (this.debug && this.grammar.type != 1) {
                STGroupFile dbgTemplates = new STGroupFile(new StringBuffer().append(langDir).append("/Dbg.stg").toString());
                dbgTemplates.importTemplates(coreTemplates);
                this.baseTemplates = dbgTemplates;
                STGroupFile stTemplates = new STGroupFile(new StringBuffer().append(langDir).append("/ST.stg").toString());
                stTemplates.importTemplates(dbgTemplates);
                this.templates = stTemplates;
                dbgTemplates.iterateAcrossValues = true;
            } else {
                STGroupFile stTemplates = new STGroupFile(new StringBuffer().append(langDir).append("/ST.stg").toString());
                stTemplates.importTemplates(coreTemplates);
                this.templates = stTemplates;
            }
            this.templates.iterateAcrossValues = true;
        } else if (this.debug && this.grammar.type != 1) {
            STGroupFile dbgTemplates = new STGroupFile(new StringBuffer().append(langDir).append("/Dbg.stg").toString());
            dbgTemplates.importTemplates(coreTemplates);
            this.baseTemplates = this.templates = dbgTemplates;
            this.baseTemplates.iterateAcrossValues = true;
        } else {
            this.templates = coreTemplates;
            coreTemplates.iterateAcrossValues = true;
        }
    }

    public ST genRecognizer() {
        this.loadTemplates(this.language);
        if (this.templates == null) {
            return null;
        }
        if (ErrorManager.doNotAttemptAnalysis()) {
            return null;
        }
        this.target.performGrammarAnalysis(this, this.grammar);
        if (ErrorManager.doNotAttemptCodeGen()) {
            return null;
        }
        DFAOptimizer optimizer = new DFAOptimizer(this.grammar);
        optimizer.optimize();
        this.outputFileST = this.templates.getInstanceOf("outputFile");
        if (this.templates.isDefined("headerFile")) {
            this.headerFileST = this.templates.getInstanceOf("headerFile");
        } else {
            this.headerFileST = new ST(this.templates, "xyz");
            this.headerFileST.add("cyclicDFAs", null);
        }
        boolean filterMode = this.grammar.getOption("filter") != null && this.grammar.getOption("filter").equals("true");
        boolean canBacktrack = this.grammar.getSyntacticPredicates() != null || this.grammar.composite.getRootGrammar().atLeastOneBacktrackOption || filterMode;
        Map<String, Map<String, Object>> actions = this.grammar.getActions();
        this.verifyActionScopesOkForTarget(actions);
        this.translateActionAttributeReferences(actions);
        ST gateST = this.templates.getInstanceOf("actionGate");
        if (filterMode) {
            gateST = this.templates.getInstanceOf("filteringActionGate");
        }
        this.grammar.setSynPredGateIfNotAlready(gateST);
        this.headerFileST.add("actions", actions);
        this.outputFileST.add("actions", actions);
        this.headerFileST.add("buildTemplate", new Boolean(this.grammar.buildTemplate()));
        this.outputFileST.add("buildTemplate", new Boolean(this.grammar.buildTemplate()));
        this.headerFileST.add("buildAST", new Boolean(this.grammar.buildAST()));
        this.outputFileST.add("buildAST", new Boolean(this.grammar.buildAST()));
        this.outputFileST.add("rewriteMode", this.grammar.rewriteMode());
        this.headerFileST.add("rewriteMode", this.grammar.rewriteMode());
        this.outputFileST.add("backtracking", canBacktrack);
        this.headerFileST.add("backtracking", canBacktrack);
        String memoize = (String)this.grammar.getOption("memoize");
        this.outputFileST.add("memoize", new Boolean(this.grammar.atLeastOneRuleMemoizes || Boolean.valueOf(memoize != null && memoize.equals("true")) != false && canBacktrack));
        this.headerFileST.add("memoize", new Boolean(this.grammar.atLeastOneRuleMemoizes || Boolean.valueOf(memoize != null && memoize.equals("true")) != false && canBacktrack));
        this.outputFileST.add("trace", this.trace);
        this.headerFileST.add("trace", this.trace);
        this.outputFileST.add("profile", this.profile);
        this.headerFileST.add("profile", this.profile);
        if (this.grammar.type == 1) {
            this.recognizerST = this.templates.getInstanceOf("lexer");
            this.outputFileST.add("LEXER", true);
            this.headerFileST.add("LEXER", true);
            this.recognizerST.add("filterMode", filterMode);
        } else if (this.grammar.type == 2 || this.grammar.type == 4) {
            this.recognizerST = this.templates.getInstanceOf("parser");
            this.outputFileST.add("PARSER", true);
            this.headerFileST.add("PARSER", true);
        } else {
            this.recognizerST = this.templates.getInstanceOf("treeParser");
            this.outputFileST.add("TREE_PARSER", true);
            this.headerFileST.add("TREE_PARSER", true);
            this.recognizerST.add("filterMode", filterMode);
        }
        this.outputFileST.add("recognizer", this.recognizerST);
        this.headerFileST.add("recognizer", this.recognizerST);
        this.outputFileST.add("actionScope", this.grammar.getDefaultActionScope(this.grammar.type));
        this.headerFileST.add("actionScope", this.grammar.getDefaultActionScope(this.grammar.type));
        String targetAppropriateFileNameString = this.target.getTargetStringLiteralFromString(this.grammar.getFileName());
        this.outputFileST.add("fileName", targetAppropriateFileNameString);
        this.headerFileST.add("fileName", targetAppropriateFileNameString);
        this.outputFileST.add("ANTLRVersion", this.tool.VERSION);
        this.headerFileST.add("ANTLRVersion", this.tool.VERSION);
        this.outputFileST.add("generatedTimestamp", Tool.getCurrentTimeStamp());
        this.headerFileST.add("generatedTimestamp", Tool.getCurrentTimeStamp());
        CodeGenTreeWalker gen = new CodeGenTreeWalker(new CommonTreeNodeStream(this.grammar.getGrammarTree()));
        try {
            gen.grammar_(this.grammar, this.recognizerST, this.outputFileST, this.headerFileST);
        }
        catch (RecognitionException re) {
            ErrorManager.error(15, re);
        }
        this.genTokenTypeConstants(this.recognizerST);
        this.genTokenTypeConstants(this.outputFileST);
        this.genTokenTypeConstants(this.headerFileST);
        if (this.grammar.type != 1) {
            this.genTokenTypeNames(this.recognizerST);
            this.genTokenTypeNames(this.outputFileST);
            this.genTokenTypeNames(this.headerFileST);
        }
        Set<String> synpredNames = null;
        if (this.grammar.synPredNamesUsedInDFA.size() > 0) {
            synpredNames = this.grammar.synPredNamesUsedInDFA;
        }
        this.outputFileST.add("synpreds", synpredNames);
        this.headerFileST.add("synpreds", synpredNames);
        this.recognizerST.add("grammar", this.grammar);
        if (LAUNCH_ST_INSPECTOR) {
            this.outputFileST.inspect();
            if (this.templates.isDefined("headerFile")) {
                this.headerFileST.inspect();
            }
        }
        try {
            this.target.genRecognizerFile(this.tool, this, this.grammar, this.outputFileST);
            if (this.templates.isDefined("headerFile")) {
                ST extST = this.templates.getInstanceOf("headerFileExtension");
                this.target.genRecognizerHeaderFile(this.tool, this, this.grammar, this.headerFileST, extST.render());
            }
            ST tokenVocabSerialization = this.genTokenVocabOutput();
            String vocabFileName = this.getVocabFileName();
            if (vocabFileName != null) {
                this.write(tokenVocabSerialization, vocabFileName);
            }
        }
        catch (IOException ioe) {
            ErrorManager.error(1, ioe);
        }
        return this.outputFileST;
    }

    protected void verifyActionScopesOkForTarget(Map actions) {
        Set actionScopeKeySet = actions.keySet();
        for (String scope : actionScopeKeySet) {
            if (this.target.isValidActionScope(this.grammar.type, scope)) continue;
            Map scopeActions = (Map)actions.get(scope);
            GrammarAST actionAST = (GrammarAST)scopeActions.values().iterator().next();
            ErrorManager.grammarError(143, this.grammar, actionAST.getToken(), scope, this.grammar.getGrammarTypeString());
        }
    }

    protected void translateActionAttributeReferences(Map actions) {
        Set actionScopeKeySet = actions.keySet();
        for (String scope : actionScopeKeySet) {
            Map scopeActions = (Map)actions.get(scope);
            this.translateActionAttributeReferencesForSingleScope(null, scopeActions);
        }
    }

    public void translateActionAttributeReferencesForSingleScope(Rule r2, Map scopeActions) {
        String ruleName = null;
        if (r2 != null) {
            ruleName = r2.name;
        }
        Set actionNameSet = scopeActions.keySet();
        for (String name : actionNameSet) {
            GrammarAST actionAST = (GrammarAST)scopeActions.get(name);
            List chunks = this.translateAction(ruleName, actionAST);
            scopeActions.put(name, chunks);
        }
    }

    public void generateLocalFOLLOW(GrammarAST referencedElementNode, String referencedElementName, String enclosingRuleName, int elementIndex) {
        NFAState followingNFAState = referencedElementNode.followingNFAState;
        LookaheadSet follow = null;
        if (followingNFAState != null) {
            follow = this.grammar.FIRST(followingNFAState);
        }
        if (follow == null) {
            ErrorManager.internalError("no follow state or cannot compute follow");
            follow = new LookaheadSet();
        }
        if (follow.member(-1)) {
            follow.remove(-1);
        }
        List tokenTypeList = null;
        long[] words = null;
        if (follow.tokenTypeSet == null) {
            words = new long[1];
            tokenTypeList = new ArrayList();
        } else {
            BitSet bits = BitSet.of(follow.tokenTypeSet);
            words = bits.toPackedArray();
            tokenTypeList = follow.tokenTypeSet.toList();
        }
        String[] wordStrings = new String[words.length];
        for (int j2 = 0; j2 < words.length; ++j2) {
            long w2 = words[j2];
            wordStrings[j2] = this.target.getTarget64BitStringFromValue(w2);
        }
        this.recognizerST.addAggr("bitsets.{name,inName,bits,tokenTypes,tokenIndex}", referencedElementName, enclosingRuleName, wordStrings, tokenTypeList, Utils.integer(elementIndex));
        this.outputFileST.addAggr("bitsets.{name,inName,bits,tokenTypes,tokenIndex}", referencedElementName, enclosingRuleName, wordStrings, tokenTypeList, Utils.integer(elementIndex));
        this.headerFileST.addAggr("bitsets.{name,inName,bits,tokenTypes,tokenIndex}", referencedElementName, enclosingRuleName, wordStrings, tokenTypeList, Utils.integer(elementIndex));
    }

    public ST genLookaheadDecision(ST recognizerST, DFA dfa) {
        ST decisionST;
        if (dfa.canInlineDecision()) {
            decisionST = this.acyclicDFAGenerator.genFixedLookaheadDecision(this.getTemplates(), dfa);
        } else {
            dfa.createStateTables(this);
            this.outputFileST.add("cyclicDFAs", dfa);
            this.headerFileST.add("cyclicDFAs", dfa);
            decisionST = this.templates.getInstanceOf("dfaDecision");
            String description = dfa.getNFADecisionStartState().getDescription();
            description = this.target.getTargetStringLiteralFromString(description);
            if (description != null) {
                decisionST.add("description", description);
            }
            decisionST.add("decisionNumber", Utils.integer(dfa.getDecisionNumber()));
        }
        return decisionST;
    }

    public ST generateSpecialState(DFAState s2) {
        ST stateST = this.templates.getInstanceOf("cyclicDFAState");
        stateST.add("needErrorClause", true);
        stateST.add("semPredState", s2.isResolvedWithPredicates());
        stateST.add("stateNumber", new Integer(s2.stateNumber));
        stateST.add("decisionNumber", new Integer(s2.dfa.decisionNumber));
        boolean foundGatedPred = false;
        ST eotST = null;
        for (int i2 = 0; i2 < s2.getNumberOfTransitions(); ++i2) {
            DFAState t2;
            SemanticContext preds;
            ST edgeST;
            Transition edge = s2.transition(i2);
            if (edge.label.getAtom() == -2) {
                edgeST = this.templates.getInstanceOf("eotDFAEdge");
                stateST.remove("needErrorClause");
                eotST = edgeST;
            } else {
                edgeST = this.templates.getInstanceOf("cyclicDFAEdge");
                ST exprST = this.genLabelExpr(this.templates, edge, 1);
                edgeST.add("labelExpr", exprST);
            }
            edgeST.add("edgeNumber", Utils.integer(i2 + 1));
            edgeST.add("targetStateNumber", Utils.integer(edge.target.stateNumber));
            if (!edge.label.isSemanticPredicate() && (preds = (t2 = (DFAState)edge.target).getGatedPredicatesInNFAConfigurations()) != null) {
                foundGatedPred = true;
                ST predST = preds.genExpr(this, this.getTemplates(), t2.dfa);
                edgeST.add("predicates", predST.render());
            }
            if (edge.label.getAtom() == -2) continue;
            stateST.add("edges", edgeST);
        }
        if (foundGatedPred) {
            stateST.add("semPredState", new Boolean(foundGatedPred));
        }
        if (eotST != null) {
            stateST.add("edges", eotST);
        }
        return stateST;
    }

    protected ST genLabelExpr(STGroup templates, Transition edge, int k2) {
        Label label = edge.label;
        if (label.isSemanticPredicate()) {
            return this.genSemanticPredicateExpr(templates, edge);
        }
        if (label.isSet()) {
            return this.genSetExpr(templates, label.getSet(), k2, true);
        }
        ST eST = templates.getInstanceOf("lookaheadTest");
        eST.add("atom", this.getTokenTypeAsTargetLabel(label.getAtom()));
        eST.add("atomAsInt", Utils.integer(label.getAtom()));
        eST.add("k", Utils.integer(k2));
        return eST;
    }

    protected ST genSemanticPredicateExpr(STGroup templates, Transition edge) {
        DFA dfa = ((DFAState)edge.target).dfa;
        Label label = edge.label;
        SemanticContext semCtx = label.getSemanticContext();
        return semCtx.genExpr(this, templates, dfa);
    }

    public ST genSetExpr(STGroup templates, IntSet set, int k2, boolean partOfDFA) {
        if (!(set instanceof IntervalSet)) {
            throw new IllegalArgumentException("unable to generate expressions for non IntervalSet objects");
        }
        IntervalSet iset = (IntervalSet)set;
        if (iset.getIntervals() == null || iset.getIntervals().size() == 0) {
            ST emptyST = new ST(templates, "");
            emptyST.impl.name = "empty-set-expr";
            return emptyST;
        }
        String testSTName = "lookaheadTest";
        String testRangeSTName = "lookaheadRangeTest";
        if (!partOfDFA) {
            testSTName = "isolatedLookaheadTest";
            testRangeSTName = "isolatedLookaheadRangeTest";
        }
        ST setST = templates.getInstanceOf("setTest");
        Iterator<Interval> iter = iset.getIntervals().iterator();
        int rangeNumber = 1;
        while (iter.hasNext()) {
            ST eST;
            Interval I2 = iter.next();
            int a2 = I2.a;
            int b2 = I2.b;
            if (a2 == b2) {
                eST = templates.getInstanceOf(testSTName);
                eST.add("atom", this.getTokenTypeAsTargetLabel(a2));
                eST.add("atomAsInt", Utils.integer(a2));
            } else {
                eST = templates.getInstanceOf(testRangeSTName);
                eST.add("lower", this.getTokenTypeAsTargetLabel(a2));
                eST.add("lowerAsInt", Utils.integer(a2));
                eST.add("upper", this.getTokenTypeAsTargetLabel(b2));
                eST.add("upperAsInt", Utils.integer(b2));
                eST.add("rangeNumber", Utils.integer(rangeNumber));
            }
            eST.add("k", Utils.integer(k2));
            setST.add("ranges", eST);
            ++rangeNumber;
        }
        return setST;
    }

    protected void genTokenTypeConstants(ST code) {
        for (String tokenID : this.grammar.getTokenIDs()) {
            int tokenType = this.grammar.getTokenType(tokenID);
            if (tokenType != -1 && tokenType < 4) continue;
            code.addAggr("tokens.{name,type}", tokenID, Utils.integer(tokenType));
        }
    }

    protected void genTokenTypeNames(ST code) {
        for (int t2 = 4; t2 <= this.grammar.getMaxTokenType(); ++t2) {
            String tokenName = this.grammar.getTokenDisplayName(t2);
            if (tokenName == null) continue;
            tokenName = this.target.getTargetStringLiteralFromString(tokenName, true);
            code.add("tokenNames", tokenName);
        }
    }

    public String getTokenTypeAsTargetLabel(int ttype) {
        if (this.grammar.type == 1) {
            String name = this.grammar.getTokenDisplayName(ttype);
            return this.target.getTargetCharLiteralFromANTLRCharLiteral(this, name);
        }
        return this.target.getTokenTypeAsTargetLabel(this, ttype);
    }

    protected ST genTokenVocabOutput() {
        ST vocabFileST = new ST(vocabFilePattern);
        vocabFileST.add("literals", null);
        vocabFileST.add("tokens", null);
        vocabFileST.impl.name = "vocab-file";
        for (String tokenID : this.grammar.getTokenIDs()) {
            int tokenType = this.grammar.getTokenType(tokenID);
            if (tokenType < 4) continue;
            vocabFileST.addAggr("tokens.{name,type}", tokenID, Utils.integer(tokenType));
        }
        for (String literal : this.grammar.getStringLiterals()) {
            int tokenType = this.grammar.getTokenType(literal);
            if (tokenType < 4) continue;
            vocabFileST.addAggr("tokens.{name,type}", literal, Utils.integer(tokenType));
        }
        return vocabFileST;
    }

    public List translateAction(String ruleName, GrammarAST actionTree) {
        if (actionTree.getType() == 66) {
            return this.translateArgAction(ruleName, actionTree);
        }
        ActionTranslator translator = new ActionTranslator(this, ruleName, actionTree);
        List chunks = translator.translateToChunks();
        chunks = this.target.postProcessAction(chunks, actionTree.token);
        return chunks;
    }

    public List<ST> translateArgAction(String ruleName, GrammarAST actionTree) {
        String actionText = actionTree.token.getText();
        List<String> args = CodeGenerator.getListOfArgumentsFromAction(actionText, 44);
        ArrayList<ST> translatedArgs = new ArrayList<ST>();
        for (String arg : args) {
            if (arg == null) continue;
            CommonToken actionToken = new CommonToken(50, arg);
            ActionTranslator translator = new ActionTranslator(this, ruleName, actionToken, actionTree.outerAltNum);
            List chunks = translator.translateToChunks();
            chunks = this.target.postProcessAction(chunks, actionToken);
            ST catST = new ST(this.templates, "<chunks>");
            catST.add("chunks", chunks);
            translatedArgs.add(catST);
        }
        if (translatedArgs.size() == 0) {
            return null;
        }
        return translatedArgs;
    }

    public static List<String> getListOfArgumentsFromAction(String actionText, int separatorChar) {
        ArrayList<String> args = new ArrayList<String>();
        CodeGenerator.getListOfArgumentsFromAction(actionText, 0, -1, separatorChar, args);
        return args;
    }

    public static int getListOfArgumentsFromAction(String actionText, int start, int targetChar, int separatorChar, List<String> args) {
        String arg;
        int p2;
        if (actionText == null) {
            return -1;
        }
        actionText = actionText.replaceAll("//.*\n", "");
        int n2 = actionText.length();
        int last = p2 = start;
        block8: while (p2 < n2 && actionText.charAt(p2) != targetChar) {
            char c2 = actionText.charAt(p2);
            switch (c2) {
                case '\'': {
                    ++p2;
                    while (p2 < n2 && actionText.charAt(p2) != '\'') {
                        if (actionText.charAt(p2) == '\\' && p2 + 1 < n2 && actionText.charAt(p2 + 1) == '\'') {
                            ++p2;
                        }
                        ++p2;
                    }
                    ++p2;
                    continue block8;
                }
                case '\"': {
                    ++p2;
                    while (p2 < n2 && actionText.charAt(p2) != '\"') {
                        if (actionText.charAt(p2) == '\\' && p2 + 1 < n2 && actionText.charAt(p2 + 1) == '\"') {
                            ++p2;
                        }
                        ++p2;
                    }
                    ++p2;
                    continue block8;
                }
                case '(': {
                    p2 = CodeGenerator.getListOfArgumentsFromAction(actionText, p2 + 1, 41, separatorChar, args);
                    continue block8;
                }
                case '{': {
                    p2 = CodeGenerator.getListOfArgumentsFromAction(actionText, p2 + 1, 125, separatorChar, args);
                    continue block8;
                }
                case '<': {
                    if (actionText.indexOf(62, p2 + 1) >= p2) {
                        p2 = CodeGenerator.getListOfArgumentsFromAction(actionText, p2 + 1, 62, separatorChar, args);
                        continue block8;
                    }
                    ++p2;
                    continue block8;
                }
                case '[': {
                    p2 = CodeGenerator.getListOfArgumentsFromAction(actionText, p2 + 1, 93, separatorChar, args);
                    continue block8;
                }
            }
            if (c2 == separatorChar && targetChar == -1) {
                String arg2 = actionText.substring(last, p2);
                args.add(arg2.trim());
                last = p2 + 1;
            }
            ++p2;
        }
        if (targetChar == -1 && p2 <= n2 && (arg = actionText.substring(last, p2).trim()).length() > 0) {
            args.add(arg.trim());
        }
        return ++p2;
    }

    public ST translateTemplateConstructor(String ruleName, int outerAltNum, Token actionToken, String templateActionText) {
        ANTLRLexer lexer = new ANTLRLexer(new ANTLRStringStream(templateActionText));
        lexer.setFileName(this.grammar.getFileName());
        ANTLRParser parser = ANTLRParser.createParser(new CommonTokenStream(lexer));
        parser.setFileName(this.grammar.getFileName());
        ANTLRParser.rewrite_template_return parseResult = null;
        try {
            parseResult = parser.rewrite_template();
        }
        catch (RecognitionException re) {
            ErrorManager.grammarError(146, this.grammar, actionToken, templateActionText);
        }
        catch (Exception tse) {
            ErrorManager.internalError("can't parse template action", tse);
        }
        GrammarAST rewriteTree = (GrammarAST)parseResult.getTree();
        CodeGenTreeWalker gen = new CodeGenTreeWalker(new CommonTreeNodeStream(rewriteTree));
        gen.init(this.grammar);
        gen.setCurrentRuleName(ruleName);
        gen.setOuterAltNum(outerAltNum);
        ST st = null;
        try {
            st = gen.rewrite_template();
        }
        catch (RecognitionException re) {
            ErrorManager.error(15, re);
        }
        return st;
    }

    public void issueInvalidScopeError(String x2, String y2, Rule enclosingRule, Token actionToken, int outerAltNum) {
        Rule r2 = this.grammar.getRule(x2);
        AttributeScope scope = this.grammar.getGlobalScope(x2);
        if (scope == null && r2 != null) {
            scope = r2.ruleScope;
        }
        if (scope == null) {
            ErrorManager.grammarError(140, this.grammar, actionToken, x2);
        } else if (scope.getAttribute(y2) == null) {
            ErrorManager.grammarError(141, this.grammar, actionToken, x2, y2);
        }
    }

    public void issueInvalidAttributeError(String x2, String y2, Rule enclosingRule, Token actionToken, int outerAltNum) {
        if (enclosingRule == null) {
            ErrorManager.grammarError(111, this.grammar, actionToken, x2, y2);
            return;
        }
        Grammar.LabelElementPair label = enclosingRule.getRuleLabel(x2);
        if (label != null || enclosingRule.getRuleRefsInAlt(x2, outerAltNum) != null) {
            Rule refdRule;
            AttributeScope scope;
            String refdRuleName = x2;
            if (label != null) {
                refdRuleName = enclosingRule.getRuleLabel((String)x2).referencedRuleName;
            }
            if ((scope = (refdRule = this.grammar.getRule(refdRuleName)).getAttributeScope(y2)) == null) {
                ErrorManager.grammarError(116, this.grammar, actionToken, refdRuleName, y2);
            } else if (scope.isParameterScope) {
                ErrorManager.grammarError(115, this.grammar, actionToken, refdRuleName, y2);
            } else if (scope.isDynamicRuleScope) {
                ErrorManager.grammarError(112, this.grammar, actionToken, refdRuleName, y2);
            }
        }
    }

    public void issueInvalidAttributeError(String x2, Rule enclosingRule, Token actionToken, int outerAltNum) {
        if (enclosingRule == null) {
            ErrorManager.grammarError(111, this.grammar, actionToken, x2);
            return;
        }
        Grammar.LabelElementPair label = enclosingRule.getRuleLabel(x2);
        AttributeScope scope = enclosingRule.getAttributeScope(x2);
        if (label != null || enclosingRule.getRuleRefsInAlt(x2, outerAltNum) != null || enclosingRule.name.equals(x2)) {
            ErrorManager.grammarError(117, this.grammar, actionToken, x2);
        } else if (scope != null && scope.isDynamicRuleScope) {
            ErrorManager.grammarError(142, this.grammar, actionToken, x2);
        } else {
            ErrorManager.grammarError(114, this.grammar, actionToken, x2);
        }
    }

    public STGroup getTemplates() {
        return this.templates;
    }

    public STGroup getBaseTemplates() {
        return this.baseTemplates;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
        if (profile) {
            this.setDebug(true);
        }
    }

    public ST getRecognizerST() {
        return this.outputFileST;
    }

    public String getRecognizerFileName(String name, int type) {
        ST extST = this.templates.getInstanceOf("codeFileExtension");
        String recognizerName = this.grammar.getRecognizerName();
        return new StringBuffer().append(recognizerName).append(extST.render()).toString();
    }

    public String getVocabFileName() {
        if (this.grammar.isBuiltFromString()) {
            return null;
        }
        return new StringBuffer().append(this.grammar.name).append(VOCAB_FILE_EXTENSION).toString();
    }

    public void write(ST code, String fileName) throws IOException {
        Writer w2 = this.tool.getOutputFile(this.grammar, fileName);
        AutoIndentWriter wr = new AutoIndentWriter(w2);
        wr.setLineWidth(this.lineWidth);
        code.write(wr);
        w2.close();
    }

    protected boolean canGenerateSwitch(DFAState s2) {
        if (!this.GENERATE_SWITCHES_WHEN_POSSIBLE) {
            return false;
        }
        int size = 0;
        for (int i2 = 0; i2 < s2.getNumberOfTransitions(); ++i2) {
            int EOTPredicts;
            Transition edge = s2.transition(i2);
            if (edge.label.isSemanticPredicate()) {
                return false;
            }
            if (edge.label.getAtom() == -2 && (EOTPredicts = ((DFAState)edge.target).getUniquelyPredictedAlt()) == -1) {
                return false;
            }
            if (((DFAState)edge.target).getGatedPredicatesInNFAConfigurations() != null) {
                return false;
            }
            size += edge.label.getSet().size();
        }
        return s2.getNumberOfTransitions() >= MIN_SWITCH_ALTS && size <= MAX_SWITCH_CASE_LABELS;
    }

    public String createUniqueLabel(String name) {
        return new StringBuffer().append(name).append(this.uniqueLabelNumber++).toString();
    }
}

