/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAContext;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.IntSet;
import org.antlr.misc.MultiMap;
import org.antlr.misc.OrderedHashSet;
import org.antlr.misc.Utils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFAState
extends State {
    public static final int INITIAL_NUM_TRANSITIONS = 4;
    public static final int PREDICTED_ALT_UNSET = -2;
    public DFA dfa;
    protected List<Transition> transitions = new ArrayList<Transition>(4);
    protected int k;
    protected int acceptStateReachable = -2;
    protected boolean resolvedWithPredicates = false;
    public boolean abortedDueToRecursionOverflow = false;
    protected boolean abortedDueToMultipleRecursiveAlts = false;
    protected int cachedHashCode;
    protected int cachedUniquelyPredicatedAlt = -2;
    public int minAltInConfigurations = Integer.MAX_VALUE;
    public boolean atLeastOneConfigurationHasAPredicate = false;
    public OrderedHashSet<NFAConfiguration> nfaConfigurations = new OrderedHashSet();
    public List<NFAConfiguration> configurationsWithLabeledEdges = new ArrayList<NFAConfiguration>();
    protected Set<NFAConfiguration> closureBusy = new HashSet<NFAConfiguration>();
    protected OrderedHashSet<Label> reachableLabels;

    public DFAState(DFA dfa) {
        this.dfa = dfa;
    }

    public void reset() {
        this.configurationsWithLabeledEdges = null;
        this.closureBusy = null;
        this.reachableLabels = null;
    }

    @Override
    public Transition transition(int i2) {
        return this.transitions.get(i2);
    }

    @Override
    public int getNumberOfTransitions() {
        return this.transitions.size();
    }

    @Override
    public void addTransition(Transition t2) {
        this.transitions.add(t2);
    }

    public int addTransition(DFAState target, Label label) {
        this.transitions.add(new Transition(label, (State)target));
        return this.transitions.size() - 1;
    }

    public Transition getTransition(int trans) {
        return this.transitions.get(trans);
    }

    public void removeTransition(int trans) {
        this.transitions.remove(trans);
    }

    public void addNFAConfiguration(NFAState state, NFAConfiguration c2) {
        Label label;
        if (this.nfaConfigurations.contains(c2)) {
            return;
        }
        this.nfaConfigurations.add(c2);
        if (c2.alt < this.minAltInConfigurations) {
            this.minAltInConfigurations = c2.alt;
        }
        if (c2.semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) {
            this.atLeastOneConfigurationHasAPredicate = true;
        }
        this.cachedHashCode += c2.state + c2.alt;
        if (state.transition[0] != null && !(label = state.transition[0].label).isEpsilon() && !label.isSemanticPredicate()) {
            this.configurationsWithLabeledEdges.add(c2);
            if (state.transition[1] == null) {
                c2.singleAtomTransitionEmanating = true;
            }
            this.addReachableLabel(label);
        }
    }

    public NFAConfiguration addNFAConfiguration(NFAState state, int alt, NFAContext context, SemanticContext semanticContext) {
        NFAConfiguration c2 = new NFAConfiguration(state.stateNumber, alt, context, semanticContext);
        this.addNFAConfiguration(state, c2);
        return c2;
    }

    protected void addReachableLabel(Label label) {
        IntSet t2;
        if (this.reachableLabels == null) {
            this.reachableLabels = new OrderedHashSet();
        }
        if (this.reachableLabels.contains(label)) {
            return;
        }
        IntSet remainder = t2 = label.getSet();
        int n2 = this.reachableLabels.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Label rl = this.reachableLabels.get(i2);
            if (!Label.intersect(label, rl)) continue;
            IntSet s_i = rl.getSet();
            IntSet intersection = s_i.and(t2);
            this.reachableLabels.set(i2, new Label(intersection));
            IntSet existingMinusNewElements = s_i.subtract(t2);
            if (!existingMinusNewElements.isNil()) {
                Label newLabel = new Label(existingMinusNewElements);
                this.reachableLabels.add(newLabel);
            }
            if ((remainder = t2.subtract(s_i)).isNil()) break;
            t2 = remainder;
        }
        if (!remainder.isNil()) {
            Label newLabel = new Label(remainder);
            this.reachableLabels.add(newLabel);
        }
    }

    public OrderedHashSet getReachableLabels() {
        return this.reachableLabels;
    }

    public void setNFAConfigurations(OrderedHashSet<NFAConfiguration> configs) {
        this.nfaConfigurations = configs;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            return super.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object o2) {
        DFAState other = (DFAState)o2;
        return this.nfaConfigurations.equals(other.nfaConfigurations);
    }

    public int getUniquelyPredictedAlt() {
        if (this.cachedUniquelyPredicatedAlt != -2) {
            return this.cachedUniquelyPredicatedAlt;
        }
        int alt = -1;
        int numConfigs = this.nfaConfigurations.size();
        for (int i2 = 0; i2 < numConfigs; ++i2) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i2);
            if (configuration.resolved) continue;
            if (alt == -1) {
                alt = configuration.alt;
                continue;
            }
            if (configuration.alt == alt) continue;
            return -1;
        }
        this.cachedUniquelyPredicatedAlt = alt;
        return alt;
    }

    public int getUniqueAlt() {
        int alt = -1;
        int numConfigs = this.nfaConfigurations.size();
        for (int i2 = 0; i2 < numConfigs; ++i2) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i2);
            if (alt == -1) {
                alt = configuration.alt;
                continue;
            }
            if (configuration.alt == alt) continue;
            return -1;
        }
        return alt;
    }

    public Set getDisabledAlternatives() {
        LinkedHashSet<Integer> disabled = new LinkedHashSet<Integer>();
        int numConfigs = this.nfaConfigurations.size();
        for (int i2 = 0; i2 < numConfigs; ++i2) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i2);
            if (!configuration.resolved) continue;
            disabled.add(Utils.integer(configuration.alt));
        }
        return disabled;
    }

    protected Set getNonDeterministicAlts() {
        int user_k = this.dfa.getUserMaxLookahead();
        if (user_k > 0 && user_k == this.k) {
            return this.getAltSet();
        }
        if (this.abortedDueToMultipleRecursiveAlts || this.abortedDueToRecursionOverflow) {
            return this.getAltSet();
        }
        return this.getConflictingAlts();
    }

    protected Set<Integer> getConflictingAlts() {
        HashSet<Integer> nondeterministicAlts = new HashSet<Integer>();
        int numConfigs = this.nfaConfigurations.size();
        if (numConfigs <= 1) {
            return null;
        }
        MultiMap<Integer, NFAConfiguration> stateToConfigListMap = new MultiMap<Integer, NFAConfiguration>();
        for (int i2 = 0; i2 < numConfigs; ++i2) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i2);
            Integer stateI = Utils.integer(configuration.state);
            stateToConfigListMap.map(stateI, configuration);
        }
        Set states = stateToConfigListMap.keySet();
        int numPotentialConflicts = 0;
        for (Integer stateI : states) {
            boolean thisStateHasPotentialProblem = false;
            List configsForState = (List)stateToConfigListMap.get(stateI);
            int alt = 0;
            int numConfigsForState = configsForState.size();
            for (int i3 = 0; i3 < numConfigsForState && numConfigsForState > 1; ++i3) {
                NFAConfiguration c2 = (NFAConfiguration)configsForState.get(i3);
                if (alt == 0) {
                    alt = c2.alt;
                    continue;
                }
                if (c2.alt == alt || this.dfa.nfa.grammar.type == 1 && this.dfa.decisionNFAStartState.enclosingRule.name.equals("Tokens")) continue;
                ++numPotentialConflicts;
                thisStateHasPotentialProblem = true;
            }
            if (thisStateHasPotentialProblem) continue;
            stateToConfigListMap.put(stateI, null);
        }
        if (numPotentialConflicts == 0) {
            return null;
        }
        for (Integer stateI : states) {
            List configsForState = (List)stateToConfigListMap.get(stateI);
            int numConfigsForState = 0;
            if (configsForState != null) {
                numConfigsForState = configsForState.size();
            }
            for (int i4 = 0; i4 < numConfigsForState; ++i4) {
                NFAConfiguration s2 = (NFAConfiguration)configsForState.get(i4);
                for (int j2 = i4 + 1; j2 < numConfigsForState; ++j2) {
                    NFAConfiguration t2 = (NFAConfiguration)configsForState.get(j2);
                    if (s2.alt == t2.alt || !s2.context.conflictsWith(t2.context)) continue;
                    nondeterministicAlts.add(Utils.integer(s2.alt));
                    nondeterministicAlts.add(Utils.integer(t2.alt));
                }
            }
        }
        if (nondeterministicAlts.size() == 0) {
            return null;
        }
        return nondeterministicAlts;
    }

    public Set getAltSet() {
        int numConfigs = this.nfaConfigurations.size();
        HashSet<Integer> alts = new HashSet<Integer>();
        for (int i2 = 0; i2 < numConfigs; ++i2) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i2);
            alts.add(Utils.integer(configuration.alt));
        }
        if (alts.size() == 0) {
            return null;
        }
        return alts;
    }

    public Set getGatedSyntacticPredicatesInNFAConfigurations() {
        int numConfigs = this.nfaConfigurations.size();
        HashSet<SemanticContext> synpreds = new HashSet<SemanticContext>();
        for (int i2 = 0; i2 < numConfigs; ++i2) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i2);
            SemanticContext gatedPredExpr = configuration.semanticContext.getGatedPredicateContext();
            if (gatedPredExpr == null || !configuration.semanticContext.isSyntacticPredicate()) continue;
            synpreds.add(configuration.semanticContext);
        }
        if (synpreds.size() == 0) {
            return null;
        }
        return synpreds;
    }

    public SemanticContext getGatedPredicatesInNFAConfigurations() {
        SemanticContext unionOfPredicatesFromAllAlts = null;
        int numConfigs = this.nfaConfigurations.size();
        for (int i2 = 0; i2 < numConfigs; ++i2) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i2);
            SemanticContext gatedPredExpr = configuration.semanticContext.getGatedPredicateContext();
            if (gatedPredExpr == null) {
                return null;
            }
            if (!this.acceptState && configuration.semanticContext.isSyntacticPredicate()) continue;
            unionOfPredicatesFromAllAlts = unionOfPredicatesFromAllAlts == null ? gatedPredExpr : SemanticContext.or(unionOfPredicatesFromAllAlts, gatedPredExpr);
        }
        if (unionOfPredicatesFromAllAlts instanceof SemanticContext.TruePredicate) {
            return null;
        }
        return unionOfPredicatesFromAllAlts;
    }

    public int getAcceptStateReachable() {
        return this.acceptStateReachable;
    }

    public void setAcceptStateReachable(int acceptStateReachable) {
        this.acceptStateReachable = acceptStateReachable;
    }

    public boolean isResolvedWithPredicates() {
        return this.resolvedWithPredicates;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(new StringBuffer().append(this.stateNumber).append(":{").toString());
        for (int i2 = 0; i2 < this.nfaConfigurations.size(); ++i2) {
            NFAConfiguration configuration = this.nfaConfigurations.get(i2);
            if (i2 > 0) {
                buf.append(", ");
            }
            buf.append(configuration);
        }
        buf.append("}");
        return buf.toString();
    }

    public int getLookaheadDepth() {
        return this.k;
    }

    public void setLookaheadDepth(int k2) {
        this.k = k2;
        if (k2 > this.dfa.max_k) {
            this.dfa.max_k = k2;
        }
    }
}

