/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yfiles.view;

import com.yworks.yfiles.graphml.c;
import com.yworks.yfiles.utils.T;
import com.yworks.yfiles.view.DashStyle;
import com.yworks.yfiles.view.DashStyles;
import com.yworks.yfiles.view.Freezable;
import com.yworks.yfiles.view.Pens;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@T(\u0102=true, \u0103=true, \u0101=false)
public class Pen
extends Freezable {
    private Paint paint;
    private int endCap;
    private int lineJoin;
    private DashStyle dashStyle;
    private double miterLimit;
    private double thickness;
    private BasicStroke strokeCache;

    public Pen() {
        this.setEndCap(0);
        this.setLineJoin(0);
        this.setMiterLimit(10.0);
        this.setThickness(1.0);
        this.setDashStyle(DashStyle.getSolid());
        this.setPaint(Color.BLACK);
    }

    public Pen(@Nullable Paint paint) {
        this();
        this.setPaint(paint);
    }

    public Pen(Paint paint, double d2) {
        this();
        this.setPaint(paint);
        this.setThickness(d2);
    }

    @Nullable
    @c(\u0108="Black", \u0106=Color.class)
    @T(\u0101=false, \u0102=true)
    public final Paint getPaint() {
        return this.paint;
    }

    @c(\u0108="Black", \u0106=Color.class)
    @T(\u0101=false, \u0102=true)
    public final void setPaint(@Nullable Paint paint) {
        this.checkMutability();
        this.paint = paint;
    }

    @c(\u0107=0, \u0104=c.A.INT_TYPE)
    @T(\u0101=false, \u0102=true)
    public final int getEndCap() {
        return this.endCap;
    }

    @c(\u0107=0, \u0104=c.A.INT_TYPE)
    @T(\u0101=false, \u0102=true)
    public final void setEndCap(int n2) {
        this.checkMutability();
        this.endCap = n2;
    }

    @c(\u0107=0, \u0104=c.A.INT_TYPE)
    @T(\u0101=false, \u0102=true)
    public final int getLineJoin() {
        return this.lineJoin;
    }

    @c(\u0107=0, \u0104=c.A.INT_TYPE)
    @T(\u0101=false, \u0102=true)
    public final void setLineJoin(int n2) {
        this.checkMutability();
        this.lineJoin = n2;
    }

    @Nonnull
    @c(\u0108="Solid", \u0106=DashStyle.class)
    @T(\u0101=false, \u0102=true)
    public final DashStyle getDashStyle() {
        return this.dashStyle;
    }

    @c(\u0108="Solid", \u0106=DashStyle.class)
    @T(\u0101=false, \u0102=true)
    public final void setDashStyle(@Nonnull DashStyle dashStyle) {
        this.checkMutability();
        this.dashStyle = dashStyle;
    }

    @c(\u0103=10.0, \u0104=c.A.DOUBLE_TYPE)
    @T(\u0101=false, \u0102=true)
    public final double getMiterLimit() {
        return this.miterLimit;
    }

    @c(\u0103=10.0, \u0104=c.A.DOUBLE_TYPE)
    @T(\u0101=false, \u0102=true)
    public final void setMiterLimit(double d2) {
        this.checkMutability();
        this.miterLimit = d2;
    }

    @c(\u0103=1.0, \u0104=c.A.DOUBLE_TYPE)
    @T(\u0101=false, \u0102=true)
    public final double getThickness() {
        return this.thickness;
    }

    @c(\u0103=1.0, \u0104=c.A.DOUBLE_TYPE)
    @T(\u0101=false, \u0102=true)
    public final void setThickness(double d2) {
        this.checkMutability();
        this.thickness = d2;
    }

    @Override
    protected void freezeCore() {
        super.freezeCore();
        this.setDashStyle((DashStyle)this.getDashStyle().clone());
        this.getDashStyle().freeze();
    }

    @Override
    public Pen clone() {
        if (this.isFrozen()) {
            return this;
        }
        return this.cloneCurrentValue();
    }

    @Nonnull
    public final Pen cloneCurrentValue() {
        Pen pen = new Pen(this.paint, this.thickness);
        pen.setDashStyle((DashStyle)this.dashStyle.clone());
        pen.setEndCap(this.endCap);
        pen.setLineJoin(this.lineJoin);
        pen.setMiterLimit(this.miterLimit);
        return pen;
    }

    public static Pen getAliceBlue() {
        return Pens.getAliceBlue();
    }

    public static Pen getAntiqueWhite() {
        return Pens.getAntiqueWhite();
    }

    public static Pen getAqua() {
        return Pens.getAqua();
    }

    public static Pen getAquamarine() {
        return Pens.getAquamarine();
    }

    public static Pen getAzure() {
        return Pens.getAzure();
    }

    public static Pen getBeige() {
        return Pens.getBeige();
    }

    public static Pen getBisque() {
        return Pens.getBisque();
    }

    public static Pen getBlack() {
        return Pens.getBlack();
    }

    public static Pen getBlanchedAlmond() {
        return Pens.getBlanchedAlmond();
    }

    public static Pen getBlue() {
        return Pens.getBlue();
    }

    public static Pen getBlueViolet() {
        return Pens.getBlueViolet();
    }

    public static Pen getBrown() {
        return Pens.getBrown();
    }

    public static Pen getBurlyWood() {
        return Pens.getBurlyWood();
    }

    public static Pen getCadetBlue() {
        return Pens.getCadetBlue();
    }

    public static Pen getChartreuse() {
        return Pens.getChartreuse();
    }

    public static Pen getChocolate() {
        return Pens.getChocolate();
    }

    public static Pen getCoral() {
        return Pens.getCoral();
    }

    public static Pen getCornflowerBlue() {
        return Pens.getCornflowerBlue();
    }

    public static Pen getCornsilk() {
        return Pens.getCornsilk();
    }

    public static Pen getCrimson() {
        return Pens.getCrimson();
    }

    public static Pen getCyan() {
        return Pens.getCyan();
    }

    public static Pen getDarkBlue() {
        return Pens.getDarkBlue();
    }

    public static Pen getDarkCyan() {
        return Pens.getDarkCyan();
    }

    public static Pen getDarkGoldenrod() {
        return Pens.getDarkGoldenrod();
    }

    public static Pen getDarkGray() {
        return Pens.getDarkGray();
    }

    public static Pen getDarkGreen() {
        return Pens.getDarkGreen();
    }

    public static Pen getDarkKhaki() {
        return Pens.getDarkKhaki();
    }

    public static Pen getDarkMagenta() {
        return Pens.getDarkMagenta();
    }

    public static Pen getDarkOliveGreen() {
        return Pens.getDarkOliveGreen();
    }

    public static Pen getDarkOrange() {
        return Pens.getDarkOrange();
    }

    public static Pen getDarkOrchid() {
        return Pens.getDarkOrchid();
    }

    public static Pen getDarkRed() {
        return Pens.getDarkRed();
    }

    public static Pen getDarkSalmon() {
        return Pens.getDarkSalmon();
    }

    public static Pen getDarkSeaGreen() {
        return Pens.getDarkSeaGreen();
    }

    public static Pen getDarkSlateBlue() {
        return Pens.getDarkSlateBlue();
    }

    public static Pen getDarkSlateGray() {
        return Pens.getDarkSlateGray();
    }

    public static Pen getDarkTurquoise() {
        return Pens.getDarkTurquoise();
    }

    public static Pen getDarkViolet() {
        return Pens.getDarkViolet();
    }

    public static Pen getDeepPink() {
        return Pens.getDeepPink();
    }

    public static Pen getDeepSkyBlue() {
        return Pens.getDeepSkyBlue();
    }

    public static Pen getDimGray() {
        return Pens.getDimGray();
    }

    public static Pen getDodgerBlue() {
        return Pens.getDodgerBlue();
    }

    public static Pen getFirebrick() {
        return Pens.getFirebrick();
    }

    public static Pen getFloralWhite() {
        return Pens.getFloralWhite();
    }

    public static Pen getForestGreen() {
        return Pens.getForestGreen();
    }

    public static Pen getFuchsia() {
        return Pens.getFuchsia();
    }

    public static Pen getGainsboro() {
        return Pens.getGainsboro();
    }

    public static Pen getGhostWhite() {
        return Pens.getGhostWhite();
    }

    public static Pen getGold() {
        return Pens.getGold();
    }

    public static Pen getGoldenrod() {
        return Pens.getGoldenrod();
    }

    public static Pen getGray() {
        return Pens.getGray();
    }

    public static Pen getGreen() {
        return Pens.getGreen();
    }

    public static Pen getGreenYellow() {
        return Pens.getGreenYellow();
    }

    public static Pen getHoneydew() {
        return Pens.getHoneydew();
    }

    public static Pen getHotPink() {
        return Pens.getHotPink();
    }

    public static Pen getIndianRed() {
        return Pens.getIndianRed();
    }

    public static Pen getIndigo() {
        return Pens.getIndigo();
    }

    public static Pen getIvory() {
        return Pens.getIvory();
    }

    public static Pen getKhaki() {
        return Pens.getKhaki();
    }

    public static Pen getLavender() {
        return Pens.getLavender();
    }

    public static Pen getLavenderBlush() {
        return Pens.getLavenderBlush();
    }

    public static Pen getLawnGreen() {
        return Pens.getLawnGreen();
    }

    public static Pen getLemonChiffon() {
        return Pens.getLemonChiffon();
    }

    public static Pen getLightBlue() {
        return Pens.getLightBlue();
    }

    public static Pen getLightCoral() {
        return Pens.getLightCoral();
    }

    public static Pen getLightCyan() {
        return Pens.getLightCyan();
    }

    public static Pen getLightGoldenrodYellow() {
        return Pens.getLightGoldenrodYellow();
    }

    public static Pen getLightGray() {
        return Pens.getLightGray();
    }

    public static Pen getLightGreen() {
        return Pens.getLightGreen();
    }

    public static Pen getLightPink() {
        return Pens.getLightPink();
    }

    public static Pen getLightSalmon() {
        return Pens.getLightSalmon();
    }

    public static Pen getLightSeaGreen() {
        return Pens.getLightSeaGreen();
    }

    public static Pen getLightSkyBlue() {
        return Pens.getLightSkyBlue();
    }

    public static Pen getLightSlateGray() {
        return Pens.getLightSlateGray();
    }

    public static Pen getLightSteelBlue() {
        return Pens.getLightSteelBlue();
    }

    public static Pen getLightYellow() {
        return Pens.getLightYellow();
    }

    public static Pen getLime() {
        return Pens.getLime();
    }

    public static Pen getLimeGreen() {
        return Pens.getLimeGreen();
    }

    public static Pen getLinen() {
        return Pens.getLinen();
    }

    public static Pen getMagenta() {
        return Pens.getMagenta();
    }

    public static Pen getMaroon() {
        return Pens.getMaroon();
    }

    public static Pen getMediumAquamarine() {
        return Pens.getMediumAquamarine();
    }

    public static Pen getMediumBlue() {
        return Pens.getMediumBlue();
    }

    public static Pen getMediumOrchid() {
        return Pens.getMediumOrchid();
    }

    public static Pen getMediumPurple() {
        return Pens.getMediumPurple();
    }

    public static Pen getMediumSeaGreen() {
        return Pens.getMediumSeaGreen();
    }

    public static Pen getMediumSlateBlue() {
        return Pens.getMediumSlateBlue();
    }

    public static Pen getMediumSpringGreen() {
        return Pens.getMediumSpringGreen();
    }

    public static Pen getMediumTurquoise() {
        return Pens.getMediumTurquoise();
    }

    public static Pen getMediumVioletRed() {
        return Pens.getMediumVioletRed();
    }

    public static Pen getMidnightBlue() {
        return Pens.getMidnightBlue();
    }

    public static Pen getMintCream() {
        return Pens.getMintCream();
    }

    public static Pen getMistyRose() {
        return Pens.getMistyRose();
    }

    public static Pen getMoccasin() {
        return Pens.getMoccasin();
    }

    public static Pen getNavajoWhite() {
        return Pens.getNavajoWhite();
    }

    public static Pen getNavy() {
        return Pens.getNavy();
    }

    public static Pen getOldLace() {
        return Pens.getOldLace();
    }

    public static Pen getOlive() {
        return Pens.getOlive();
    }

    public static Pen getOliveDrab() {
        return Pens.getOliveDrab();
    }

    public static Pen getOrange() {
        return Pens.getOrange();
    }

    public static Pen getOrangeRed() {
        return Pens.getOrangeRed();
    }

    public static Pen getOrchid() {
        return Pens.getOrchid();
    }

    public static Pen getPaleGoldenrod() {
        return Pens.getPaleGoldenrod();
    }

    public static Pen getPaleGreen() {
        return Pens.getPaleGreen();
    }

    public static Pen getPaleTurquoise() {
        return Pens.getPaleTurquoise();
    }

    public static Pen getPaleVioletRed() {
        return Pens.getPaleVioletRed();
    }

    public static Pen getPapayaWhip() {
        return Pens.getPapayaWhip();
    }

    public static Pen getPeachPuff() {
        return Pens.getPeachPuff();
    }

    public static Pen getPeru() {
        return Pens.getPeru();
    }

    public static Pen getPink() {
        return Pens.getPink();
    }

    public static Pen getPlum() {
        return Pens.getPlum();
    }

    public static Pen getPowderBlue() {
        return Pens.getPowderBlue();
    }

    public static Pen getPurple() {
        return Pens.getPurple();
    }

    public static Pen getRed() {
        return Pens.getRed();
    }

    public static Pen getRosyBrown() {
        return Pens.getRosyBrown();
    }

    public static Pen getRoyalBlue() {
        return Pens.getRoyalBlue();
    }

    public static Pen getSaddleBrown() {
        return Pens.getSaddleBrown();
    }

    public static Pen getSalmon() {
        return Pens.getSalmon();
    }

    public static Pen getSandyBrown() {
        return Pens.getSandyBrown();
    }

    public static Pen getSeaGreen() {
        return Pens.getSeaGreen();
    }

    public static Pen getSeaShell() {
        return Pens.getSeaShell();
    }

    public static Pen getSienna() {
        return Pens.getSienna();
    }

    public static Pen getSilver() {
        return Pens.getSilver();
    }

    public static Pen getSkyBlue() {
        return Pens.getSkyBlue();
    }

    public static Pen getSlateBlue() {
        return Pens.getSlateBlue();
    }

    public static Pen getSlateGray() {
        return Pens.getSlateGray();
    }

    public static Pen getSnow() {
        return Pens.getSnow();
    }

    public static Pen getSpringGreen() {
        return Pens.getSpringGreen();
    }

    public static Pen getSteelBlue() {
        return Pens.getSteelBlue();
    }

    public static Pen getTan() {
        return Pens.getTan();
    }

    public static Pen getTeal() {
        return Pens.getTeal();
    }

    public static Pen getThistle() {
        return Pens.getThistle();
    }

    public static Pen getTomato() {
        return Pens.getTomato();
    }

    public static Pen getTransparent() {
        return Pens.getTransparent();
    }

    public static Pen getTurquoise() {
        return Pens.getTurquoise();
    }

    public static Pen getViolet() {
        return Pens.getViolet();
    }

    public static Pen getWheat() {
        return Pens.getWheat();
    }

    public static Pen getWhite() {
        return Pens.getWhite();
    }

    public static Pen getWhiteSmoke() {
        return Pens.getWhiteSmoke();
    }

    public static Pen getYellow() {
        return Pens.getYellow();
    }

    public static Pen getYellowGreen() {
        return Pens.getYellowGreen();
    }

    public void commit(Graphics2D graphics2D) {
        if (this.paint != null) {
            graphics2D.setPaint(this.paint);
        }
        graphics2D.setStroke(this.createStroke());
    }

    private Stroke createStroke() {
        BasicStroke basicStroke;
        if (this.strokeCache != null) {
            return this.strokeCache;
        }
        if (this.usesDashes()) {
            float[] fArray = this.createStrokeDashArray();
            int n2 = this.endCap == 0 ? 2 : this.endCap;
            basicStroke = new BasicStroke((float)this.thickness, n2, this.lineJoin, (float)this.miterLimit, fArray, (float)this.dashStyle.getOffset());
        } else {
            basicStroke = new BasicStroke((float)this.thickness, this.endCap, this.lineJoin, (float)this.miterLimit);
        }
        if (this.isFrozen()) {
            this.strokeCache = basicStroke;
        }
        return basicStroke;
    }

    private float[] createStrokeDashArray() {
        List<Double> list = this.dashStyle.getDashes();
        float[] fArray = new float[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            fArray[i2] = (float)((double)list.get(i2).floatValue() * this.thickness);
        }
        return fArray;
    }

    private boolean usesDashes() {
        List<Double> list = this.dashStyle.getDashes();
        return list != null && !DashStyles.getSolid().equals(this.dashStyle);
    }

    @Override
    public boolean isFrozen() {
        return super.isFrozen();
    }
}

