/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.impl.HeaderParser;
import com.sun.java.help.search.ChangedCharSetException;
import com.sun.java.help.search.DefaultIndexBuilder;
import com.sun.java.help.search.DefaultIndexerKit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.help.search.ConfigFile;
import javax.help.search.IndexerKit;

public class Indexer {
    String dbName = "JavaHelpSearch";
    PrintStream verbose = null;
    PrintStream logStream = null;
    short docNumber;
    private DefaultIndexBuilder indexBuilder = null;
    private ConfigFile config;
    private String title;
    private String header;
    private boolean firstHeader = false;
    String lastPCdata;
    int currentPos;
    boolean openTagSeen = false;
    boolean inPre = false;
    boolean inTitle = false;
    boolean inFirstHeader = false;
    boolean inOption = false;
    int inBlock = 0;
    String sourcepath;
    private IndexerKit kit;
    private Hashtable typeHandlers;
    private String defaultCharSetName = "ISO8859_1";
    private String charSetName;
    private String defaultLang = Locale.getDefault().toString();
    private String lang;
    private static final Hashtable kitRegistry = new Hashtable();
    private static final Hashtable kitTypeRegistry = new Hashtable();
    private static final Hashtable kitLoaderRegistry = new Hashtable();
    private static boolean debugFlag;

    public static void main(String[] stringArray) {
        Indexer indexer = new Indexer();
        try {
            indexer.compile(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Indexer() {
        if (this.dbName.lastIndexOf("/") != this.dbName.length() - 1) {
            this.dbName = this.dbName.concat("/");
        }
        this.docNumber = 0;
    }

    public void compile(String[] stringArray) throws Exception {
        long l2 = System.currentTimeMillis();
        String string = null;
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        this.sourcepath = "";
        boolean bl = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-db")) {
                if (n2 + 1 < stringArray.length) {
                    this.dbName = stringArray[++n2];
                    if (this.dbName.lastIndexOf("/") != this.dbName.length() - 1) {
                        this.dbName = this.dbName.concat("/");
                    }
                } else {
                    System.out.println(stringArray[n2] + "-db requires argument");
                }
            } else if (stringArray[n2].equals("-sourcepath")) {
                if (n2 + 1 < stringArray.length) {
                    this.sourcepath = stringArray[++n2];
                } else {
                    System.out.println(stringArray[n2] + "-sourcepath requires argument");
                }
            } else if (stringArray[n2].equals("-locale")) {
                if (n2 + 1 < stringArray.length) {
                    this.defaultLang = stringArray[++n2];
                } else {
                    System.out.println(stringArray[n2] + "-locale requires argument");
                }
            } else if (stringArray[n2].equals("-logfile")) {
                if (n2 + 1 < stringArray.length) {
                    String string2 = stringArray[++n2];
                    try {
                        this.logStream = new PrintStream(new FileOutputStream(string2), true);
                        System.setErr(this.logStream);
                        System.setOut(this.logStream);
                        this.verbose = this.logStream;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.out.println("Couldn't create logFile " + string2);
                    }
                } else {
                    System.out.println(stringArray[n2] + "-logfile requires argument");
                }
            } else if (stringArray[n2].equals("-verbose")) {
                this.verbose = System.out;
            } else if (stringArray[n2].equals("-nostopwords")) {
                bl = true;
            } else if (stringArray[n2].equals("-c")) {
                if (n2 + 1 < stringArray.length) {
                    string = stringArray[++n2];
                } else {
                    System.out.println(stringArray[n2] + "-c requires argument");
                }
            } else {
                if (stringArray[n2].startsWith("-")) {
                    System.out.println("Unknown argument '" + stringArray[n2] + "'");
                    this.showUsage();
                    return;
                }
                vector.addElement(stringArray[n2]);
            }
            ++n2;
        }
        this.config = new ConfigFile(string, vector2, bl);
        vector2 = this.config.getFiles();
        int n3 = vector.size();
        int n4 = 0;
        while (n4 < n3) {
            vector2 = this.loadFiles((String)vector.elementAt(n4), vector2);
            ++n4;
        }
        n3 = vector2.size();
        if (n3 == 0) {
            System.out.println("No files specified to index");
            this.showUsage();
            return;
        }
        this.indexBuilder = new DefaultIndexBuilder(this.dbName);
        this.indexBuilder.storeStopWords(this.config.getStopWords());
        int n5 = 0;
        while (n5 < n3) {
            String string3 = (String)vector2.elementAt(n5);
            URL uRL = new URL("file", "", this.sourcepath + string3);
            InputStream inputStream = uRL.openStream();
            URLConnection uRLConnection = uRL.openConnection();
            String string4 = uRLConnection.getContentType();
            this.setContentType(string4);
            if (this.kit != null) {
                try {
                    if (this.verbose != null) {
                        this.verbose.println("   File: '" + string3 + "'");
                        this.verbose.println("    URL: '" + this.config.getURLString(string3) + "'");
                    }
                    this.parseFile(inputStream, string3, false);
                    inputStream.close();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println("File: '" + string3 + "' encoding " + this.charSetName + " not supported");
                    inputStream.close();
                }
                catch (IOException iOException) {
                    if (debugFlag) {
                        iOException.printStackTrace();
                    }
                    System.out.println("I/O exception occurred in file '" + this.sourcepath + string3 + "'");
                    inputStream.close();
                }
            }
            ++n5;
        }
        long l3 = System.currentTimeMillis() - l2;
        long l4 = System.currentTimeMillis() - l2 - l3;
        if (this.verbose != null) {
            this.verbose.println("        Parse time: " + (double)l3 / 1000.0 + " s");
        }
        this.indexBuilder.close();
    }

    void parseFile(InputStream inputStream, String string, boolean bl) throws IOException {
        try {
            this.kit.parse(new InputStreamReader(inputStream, this.charSetName), string, bl, this.indexBuilder, this.config);
        }
        catch (ChangedCharSetException changedCharSetException) {
            String string2 = changedCharSetException.getCharSetSpec();
            if (changedCharSetException.keyEqualsCharSet()) {
                this.charSetName = string2;
            } else {
                this.setCharsetFromContentTypeParameters(string2);
            }
            inputStream.close();
            URL uRL = new URL("file", "", this.sourcepath + string);
            inputStream = uRL.openStream();
            this.parseFile(inputStream, string, true);
        }
    }

    public Vector loadFiles(String string, Vector vector) {
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n2 = 0;
            while (n2 < stringArray.length) {
                vector = this.loadFiles(file.getPath() + File.separator + stringArray[n2], vector);
                ++n2;
            }
        } else {
            vector.addElement(string);
        }
        return vector;
    }

    public void showUsage() {
        System.out.println(" Usage:   java JavaHelp.Index options file ...");
        System.out.println(" Options: -c file   config file");
        System.out.println("          -db file  generated database file name");
        System.out.println("          -verbose  verbose documentation");
        System.out.println("          -nostopwords ignore stop words");
        System.out.println("          -locale language_country_variant");
        System.out.println("          -logfile log file name");
        System.out.println("Note: config file composition:");
        System.out.println("          IndexRemove /public_html/JavaHelp/demo");
        System.out.println("          IndexPrepend ..");
        System.out.println("          StopWords word1 ... wordN");
        System.out.println("          StopWordsFile stopWordFileName");
        System.out.println("          File /public_html/JavaHelp/demo/first.html");
        System.out.println("          File=/public_html/JavaHelp/demo/second.html");
        System.out.println("          ...");
    }

    public final void setContentType(String string) {
        Object object;
        this.charSetName = this.defaultCharSetName;
        this.lang = this.defaultLang;
        Indexer.debug("type=" + string);
        int n2 = string.indexOf(";");
        if (n2 > -1) {
            object = string.substring(n2);
            string = string.substring(0, n2).trim();
            this.setCharsetFromContentTypeParameters((String)object);
        }
        if (!(this.kit != null && string.equals(this.kit.getContentType()) || (object = this.getIndexerKitForContentType(string)) == null)) {
            this.kit = object;
        }
        this.kit.setLocale(this.lang);
    }

    private void setCharsetFromContentTypeParameters(String string) {
        String string2 = null;
        try {
            HeaderParser headerParser;
            int n2 = string.indexOf(59);
            if (n2 > -1 && n2 < string.length() - 1) {
                string = string.substring(n2 + 1);
            }
            if (string.length() > 0 && (string2 = (headerParser = new HeaderParser(string)).findValue("charset")) != null) {
                this.charSetName = string2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            System.err.println("Indexer.getCharsetFromContentTypeParameters failed on: " + string);
            exception.printStackTrace();
        }
    }

    public IndexerKit getIndexerKitForContentType(String string) {
        IndexerKit indexerKit;
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        if ((indexerKit = (IndexerKit)this.typeHandlers.get(string)) == null && (indexerKit = Indexer.createIndexerKitForContentType(string)) != null) {
            this.setIndexerKitForContentType(string, indexerKit);
        }
        if (indexerKit == null) {
            indexerKit = new DefaultIndexerKit();
            this.setIndexerKitForContentType(string, indexerKit);
        }
        return indexerKit;
    }

    public void setIndexerKitForContentType(String string, IndexerKit indexerKit) {
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        this.typeHandlers.put(string, indexerKit);
    }

    public static IndexerKit createIndexerKitForContentType(String string) {
        Indexer.debug("Getting IndexerKit for " + string);
        IndexerKit indexerKit = null;
        indexerKit = (IndexerKit)kitRegistry.get(string);
        if (indexerKit == null) {
            String string2 = (String)kitTypeRegistry.get(string);
            ClassLoader classLoader = (ClassLoader)kitLoaderRegistry.get(string);
            try {
                Class<?> clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                indexerKit = (IndexerKit)clazz.newInstance();
                kitRegistry.put(string, indexerKit);
            }
            catch (Throwable throwable) {
                if (debugFlag) {
                    throwable.printStackTrace();
                }
                indexerKit = null;
            }
        }
        if (indexerKit != null) {
            return (IndexerKit)indexerKit.clone();
        }
        return null;
    }

    public static void registerIndexerKitForContentType(String string, String string2, ClassLoader classLoader) {
        kitTypeRegistry.put(string, string2);
        if (classLoader != null) {
            kitLoaderRegistry.put(string, classLoader);
        }
    }

    private static void debug(String string) {
        if (debugFlag) {
            System.out.println("Indexer: " + string);
        }
    }

    static {
        Indexer.registerIndexerKitForContentType("text/plain", "com.sun.java.help.search.PlainTextIndexerKit", null);
        Indexer.registerIndexerKitForContentType("text/html", "com.sun.java.help.search.HTMLIndexerKit", null);
        debugFlag = false;
    }
}

