/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import java.io.IOException;
import java.io.Reader;
import java.text.BreakIterator;
import java.util.Locale;
import javax.help.search.ConfigFile;
import javax.help.search.IndexBuilder;
import javax.help.search.IndexerKit;

public class DefaultIndexerKit
extends IndexerKit {
    protected boolean documentStarted;
    private boolean debugFlag = false;

    public DefaultIndexerKit() {
        this.locale = Locale.getDefault();
    }

    public Object clone() {
        return new DefaultIndexerKit();
    }

    public String getContentType() {
        return "";
    }

    public void parse(Reader reader, String string, boolean bl, IndexBuilder indexBuilder, ConfigFile configFile) throws IOException {
        this.debug("parsing " + string);
    }

    public int parseIntoTokens(String string, int n2) {
        int n3 = n2;
        try {
            BreakIterator breakIterator = BreakIterator.getWordInstance(this.locale);
            breakIterator.setText(string);
            int n4 = breakIterator.first();
            int n5 = breakIterator.next();
            while (n5 != -1) {
                int n6;
                String string2 = new String(string.substring(n4, n5));
                string2 = string2.trim();
                if ((string2 = string2.toLowerCase(this.locale)).length() > 1) {
                    this.storeToken(string2, n3 + n4);
                } else if (string2.length() == 1 && ((n6 = Character.getType(string2.charAt(0))) == 9 || n6 == 10 || n6 == 2 || n6 == 5 || n6 == 11 || n6 == 3 || n6 == 0 || n6 == 1)) {
                    this.storeToken(string2, n3 + n4);
                }
                n4 = n5;
                n5 = breakIterator.next();
            }
            n3 += string.length();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n3;
    }

    protected void startStoreDocument(String string) throws Exception {
        if (this.config == null || this.builder == null) {
            throw new Exception("ConfigFile and/or IndexBuilder not set");
        }
        this.builder.openDocument(this.config.getURLString(string));
    }

    protected void endStoreDocument() throws Exception {
        if (this.config == null || this.builder == null) {
            throw new Exception("ConfigFile and/or IndexBuilder not set");
        }
        this.builder.closeDocument();
    }

    protected void storeToken(String string, int n2) throws Exception {
        if (this.config == null || this.builder == null) {
            throw new Exception("ConfigFile and/or IndexBuilder not set");
        }
        if (!this.documentStarted) {
            try {
                this.startStoreDocument(this.file);
                this.documentStarted = true;
            }
            catch (Exception exception) {
                if (this.debugFlag) {
                    exception.printStackTrace();
                }
                throw new IOException("Can't store Document");
            }
        }
        this.builder.storeLocation(string, n2);
    }

    protected void storeTitle(String string) throws Exception {
        if (this.config == null || this.builder == null) {
            throw new Exception("ConfigFile and/or IndexBuilder not set");
        }
        this.builder.storeTitle(string);
    }

    private void debug(String string) {
        if (this.debugFlag) {
            System.err.println("DefaultIndexKit: " + string);
        }
    }
}

