/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.RAFFile;
import java.io.IOException;

class Block {
    public static final int HEADERLEN = 8;
    public static final int IDLEN = 4;
    public int number;
    public boolean isLeaf = true;
    public int free = 0;
    public byte[] data = null;
    private static boolean debug = false;

    public Block(int n2) {
        this.data = new byte[n2 - 8];
    }

    public void setBlockNumber(int n2) {
        this.number = n2;
    }

    public void setFree(int n2) {
    }

    public int integerAt(int n2) {
        return (((this.data[n2++] & 0xFF) << 8 | this.data[n2++] & 0xFF) << 8 | this.data[n2++] & 0xFF) << 8 | this.data[n2] & 0xFF;
    }

    public void setIntegerAt(int n2, int n3) {
        int n4 = n2 + 3;
        while (n4 >= n2) {
            this.data[n4] = (byte)(n3 & 0xFF);
            --n4;
            n3 >>>= 8;
        }
    }

    public static Block readIn(RAFFile rAFFile, Block block) throws IOException {
        Block.debug("readIn");
        block.number = rAFFile.readInt();
        int n2 = rAFFile.readInt();
        block.isLeaf = (n2 & Integer.MIN_VALUE) != 0;
        block.free = n2 & Integer.MAX_VALUE;
        rAFFile.readFully(block.data);
        return block;
    }

    public void writeOut(RAFFile rAFFile) throws IOException {
        rAFFile.writeInt(this.number);
        rAFFile.writeInt(this.free | (this.isLeaf ? Integer.MIN_VALUE : 0));
        rAFFile.write(this.data);
    }

    private static void debug(String string) {
        if (debug) {
            System.err.println("Block: " + string);
        }
    }
}

