/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.metal.MetalBumps;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

class BumpBuffer {
    static final int IMAGE_SIZE = 64;
    static Dimension imageSize = new Dimension(64, 64);
    transient Image image;
    Color topColor;
    Color shadowColor;
    Color backColor;
    private GraphicsConfiguration gc;

    public BumpBuffer(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
        this.gc = graphicsConfiguration;
        this.topColor = color;
        this.shadowColor = color2;
        this.backColor = color3;
        this.createImage();
        this.fillBumpBuffer();
    }

    public boolean hasSameConfiguration(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
        if (this.gc != null ? !this.gc.equals(graphicsConfiguration) : graphicsConfiguration != null) {
            return false;
        }
        if (this.backColor != null ? !this.backColor.equals(color3) : color3 != null) {
            return false;
        }
        if (this.shadowColor != null ? !this.shadowColor.equals(color2) : color2 != null) {
            return false;
        }
        return !(this.topColor != null ? !this.topColor.equals(color) : color != null);
    }

    public Image getImage() {
        return this.image;
    }

    public Dimension getImageSize() {
        return imageSize;
    }

    private void fillBumpBuffer() {
        int n2;
        int n3;
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(this.backColor);
        graphics.fillRect(0, 0, 64, 64);
        graphics.setColor(this.topColor);
        for (n3 = 0; n3 < 64; n3 += 4) {
            for (n2 = 0; n2 < 64; n2 += 4) {
                graphics.drawLine(n3, n2, n3, n2);
                graphics.drawLine(n3 + 2, n2 + 2, n3 + 2, n2 + 2);
            }
        }
        graphics.setColor(this.shadowColor);
        for (n3 = 0; n3 < 64; n3 += 4) {
            for (n2 = 0; n2 < 64; n2 += 4) {
                graphics.drawLine(n3 + 1, n2 + 1, n3 + 1, n2 + 1);
                graphics.drawLine(n3 + 3, n2 + 3, n3 + 3, n2 + 3);
            }
        }
        graphics.dispose();
    }

    private void createImage() {
        if (this.gc != null) {
            this.image = this.gc.createCompatibleImage(64, 64, this.backColor != MetalBumps.ALPHA ? 1 : 2);
        } else {
            int[] nArray = new int[]{this.backColor.getRGB(), this.topColor.getRGB(), this.shadowColor.getRGB()};
            IndexColorModel indexColorModel = new IndexColorModel(8, 3, nArray, 0, false, this.backColor == MetalBumps.ALPHA ? 0 : -1, 0);
            this.image = new BufferedImage(64, 64, 13, indexColorModel);
        }
    }
}

