/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonUI;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.basic.UIAction;
import com.jidesoft.plaf.vsnet.VsnetMenuUI;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SecurityUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public class BasicJideSplitButtonUI
extends VsnetMenuUI {
    protected ThemePainter _painter;
    protected Color _shadowColor;
    protected Color _darkShadowColor;
    protected Color _highlight;
    protected Color _lightHighlightColor;
    protected int _splitButtonMargin = 12;
    protected int _splitButtonMarginOnMenu = 20;
    protected boolean _isFloatingIcon = false;
    private FocusListener _focusListener;
    private static final String propertyPrefix = "JideSplitButton";

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicJideSplitButtonUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    @Override
    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._isFloatingIcon = UIDefaultsLookup.getBoolean("Icon.floating");
        this._shadowColor = UIDefaultsLookup.getColor("JideButton.shadow");
        this._darkShadowColor = UIDefaultsLookup.getColor("JideButton.darkShadow");
        this._highlight = UIDefaultsLookup.getColor("JideButton.highlight");
        this._lightHighlightColor = UIDefaultsLookup.getColor("JideButton.light");
        this.menuItem.setRolloverEnabled(true);
        super.installDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        this._painter = null;
        this._shadowColor = null;
        this._highlight = null;
        this._lightHighlightColor = null;
        this._darkShadowColor = null;
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this._focusListener == null) {
            this._focusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    BasicJideSplitButtonUI.this.menuItem.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    BasicJideSplitButtonUI.this.menuItem.repaint();
                }
            };
        }
        this.menuItem.addFocusListener(this._focusListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this._focusListener != null) {
            this.menuItem.removeFocusListener(this._focusListener);
        }
    }

    static Object getUIOfType(ComponentUI componentUI, Class clazz) {
        if (clazz.isInstance(componentUI)) {
            return componentUI;
        }
        return null;
    }

    public InputMap getInputMap(int n2, JComponent jComponent) {
        BasicJideSplitButtonUI basicJideSplitButtonUI;
        if (n2 == 0 && (basicJideSplitButtonUI = (BasicJideSplitButtonUI)BasicJideSplitButtonUI.getUIOfType(((JideSplitButton)jComponent).getUI(), BasicJideSplitButtonUI.class)) != null) {
            return (InputMap)UIDefaultsLookup.get(basicJideSplitButtonUI.getPropertyPrefix() + ".focusInputMap");
        }
        return null;
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        JMenuItem jMenuItem = this.menuItem;
        LazyActionMap.installLazyActionMap(jMenuItem, BasicJideSplitButtonUI.class, "JideSplitButton.actionMap");
        InputMap inputMap = this.getInputMap(0, jMenuItem);
        SwingUtilities.replaceUIInputMap(jMenuItem, 0, inputMap);
    }

    @Override
    protected void uninstallKeyboardActions() {
        JMenuItem jMenuItem = this.menuItem;
        SwingUtilities.replaceUIInputMap(jMenuItem, 2, null);
        SwingUtilities.replaceUIInputMap(jMenuItem, 0, null);
        SwingUtilities.replaceUIActionMap(jMenuItem, null);
        super.uninstallKeyboardActions();
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    @Override
    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        JideSplitButton jideSplitButton;
        int n2;
        int n3;
        ButtonModel buttonModel = jMenuItem.getModel();
        int n4 = JideSwingUtilities.getOrientationOf(jMenuItem);
        if (n4 == 0) {
            n3 = jMenuItem.getWidth();
            n2 = jMenuItem.getHeight();
        } else {
            n3 = jMenuItem.getHeight();
            n2 = jMenuItem.getWidth();
        }
        n4 = 0;
        Object object = jMenuItem.getClientProperty("JideSplitButton.alwaysPaintBackground");
        boolean bl = object instanceof Boolean ? ((Boolean)object).booleanValue() : jMenuItem.isOpaque();
        if (!((JMenu)jMenuItem).isTopLevelMenu()) {
            super.paintBackground(graphics, jMenuItem, color);
            if (jMenuItem.isEnabled()) {
                if (buttonModel.isArmed() || buttonModel.isPressed() || this.isMouseOver()) {
                    graphics.setColor(this.selectionForeground);
                    graphics.drawLine(n3 - this._splitButtonMarginOnMenu, 0, n3 - this._splitButtonMarginOnMenu, n2 - 2);
                    JideSwingUtilities.paintArrow(graphics, this.selectionForeground, n3 - this._splitButtonMarginOnMenu / 2 - 2, n2 / 2 - 3, 7, 1);
                } else {
                    graphics.setColor(this.getForegroundOfState(jMenuItem));
                    graphics.drawLine(n3 - this._splitButtonMarginOnMenu, 0, n3 - this._splitButtonMarginOnMenu, n2 - 2);
                    JideSwingUtilities.paintArrow(graphics, this.getForegroundOfState(jMenuItem), n3 - this._splitButtonMarginOnMenu / 2 - 2, n2 / 2 - 3, 7, 1);
                }
            } else {
                graphics.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                graphics.drawLine(n3 - this._splitButtonMarginOnMenu, 0, n3 - this._splitButtonMarginOnMenu, n2 - 2);
                JideSwingUtilities.paintArrow(graphics, UIDefaultsLookup.getColor("controlDkShadow"), n3 - this._splitButtonMarginOnMenu / 2 - 2, n2 / 2 - 3, 7, 1);
            }
            return;
        }
        if (bl) {
            if (jMenuItem.getParent() != null) {
                graphics.setColor(jMenuItem.getParent().getBackground());
            } else {
                graphics.setColor(jMenuItem.getBackground());
            }
            graphics.fillRect(0, 0, n3, n2);
        }
        if ((jideSplitButton = (JideSplitButton)jMenuItem).getButtonStyle() == 0) {
            if (buttonModel.isSelected()) {
                if (this.isAlwaysDropdown(jideSplitButton)) {
                    Rectangle rectangle = new Rectangle(0, 0, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 3);
                } else if (jideSplitButton.getClientProperty("JButton.segmentPosition") != null) {
                    Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 6);
                    }
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 1);
                } else {
                    Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 3);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 5);
                    }
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 3);
                    this.getPainter().paintSelectedMenu(jideSplitButton, graphics, new Rectangle(0, 0, n3, n2), n4, 3);
                }
            } else if (buttonModel.isArmed() || buttonModel.isPressed()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 1);
                } else if (bl) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 4);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
            } else if (buttonModel instanceof SplitButtonModel && ((DefaultSplitButtonModel)buttonModel).isButtonSelected()) {
                if ((this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                    Rectangle rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 1);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 4);
                    }
                } else {
                    Rectangle rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 0);
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 3);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 5);
                    }
                }
            } else if ((jideSplitButton.isRolloverEnabled() && this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                if (this.isAlwaysDropdown(jideSplitButton)) {
                    Rectangle rectangle = new Rectangle(0, 0, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                } else {
                    Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                    } else if (bl) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 6);
                    }
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                }
            } else if (bl) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isEnabled() && jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(graphics, rectangle, 0);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, 0, 0);
                } else {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, 0, 4);
                }
                if ("true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                    JideSwingUtilities.fillGradient(graphics, rectangle, 0);
                }
            }
        } else if (jideSplitButton.getButtonStyle() == 2) {
            if (buttonModel.isSelected()) {
                this.getPainter().paintSelectedMenu(jideSplitButton, graphics, new Rectangle(0, 0, n3, n2), n4, 3);
            } else if (buttonModel.isArmed() || buttonModel.isPressed()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                if (!jideSplitButton.isOpaque()) {
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    this.paintSunkenBorder(graphics, rectangle);
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.paintRaisedBorder(graphics, rectangle);
                }
            } else if (buttonModel instanceof SplitButtonModel && ((DefaultSplitButtonModel)buttonModel).isButtonSelected()) {
                if ((this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                    Rectangle rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    }
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                        this.paintSunkenBorder(graphics, rectangle);
                        rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                        this.paintRaisedBorder(graphics, rectangle);
                    }
                } else {
                    Rectangle rectangle;
                    if (jideSplitButton.isOpaque()) {
                        rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                        JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    }
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                        this.paintSunkenBorder(graphics, rectangle);
                    }
                }
            } else if ((jideSplitButton.isRolloverEnabled() && this.isMouseOver() || jideSplitButton.hasFocus()) && buttonModel.isEnabled()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isButtonEnabled()) {
                    JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                JideSwingUtilities.paintBackground(graphics, rectangle, this._highlight, this._highlight);
                if (this.isAlwaysDropdown(jideSplitButton)) {
                    rectangle = new Rectangle(0, 0, n3, n2);
                    this.paintRaisedBorder(graphics, rectangle);
                } else {
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    this.paintRaisedBorder(graphics, rectangle);
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.paintRaisedBorder(graphics, rectangle);
                }
            } else if (jideSplitButton.isOpaque()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 0);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 0);
            }
        } else if (jideSplitButton.getButtonStyle() == 1) {
            if (buttonModel.isSelected()) {
                this.getPainter().paintSelectedMenu(jideSplitButton, graphics, new Rectangle(0, 0, n3, n2), n4, 3);
            } else if (buttonModel.isArmed() || buttonModel.isPressed()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 1);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                if (!jideSplitButton.isOpaque()) {
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    this.paintSunken2Border(graphics, rectangle);
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.paintRaisedBorder(graphics, rectangle);
                }
            } else if (buttonModel instanceof SplitButtonModel && ((DefaultSplitButtonModel)buttonModel).isButtonSelected()) {
                if (this.isMouseOver() && buttonModel.isEnabled()) {
                    Rectangle rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 1);
                    }
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                        this.paintSunken2Border(graphics, rectangle);
                        rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                        this.paintRaisedBorder(graphics, rectangle);
                    }
                } else {
                    Rectangle rectangle;
                    if (jideSplitButton.isOpaque()) {
                        rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 0);
                    }
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 3);
                    if (!jideSplitButton.isOpaque()) {
                        rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                        this.paintSunken2Border(graphics, rectangle);
                        rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                        this.paintRaisedBorder(graphics, rectangle);
                    }
                }
            } else if (jideSplitButton.isRolloverEnabled() && this.isMouseOver() && buttonModel.isEnabled()) {
                if (this.isAlwaysDropdown(jideSplitButton)) {
                    Rectangle rectangle = new Rectangle(0, 0, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                    this.paintRaised2Border(graphics, rectangle);
                } else {
                    Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    if (jideSplitButton.isButtonEnabled()) {
                        this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                    }
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 2);
                    rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                    this.paintRaised2Border(graphics, rectangle);
                    rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                    this.paintRaised2Border(graphics, rectangle);
                }
            } else if (jideSplitButton.isOpaque()) {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                if (jideSplitButton.isButtonEnabled()) {
                    this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 0);
                }
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                this.getPainter().paintButtonBackground(jideSplitButton, graphics, rectangle, n4, 0);
            } else if (this.isAlwaysDropdown(jideSplitButton)) {
                Rectangle rectangle = new Rectangle(0, 0, n3, n2);
                this.paintRaisedBorder(graphics, rectangle);
            } else {
                Rectangle rectangle = this.getButtonRect(jideSplitButton, n4, n3, n2);
                this.paintRaisedBorder(graphics, rectangle);
                rectangle = this.getDropDownRect(jideSplitButton, n4, n3, n2);
                this.paintRaisedBorder(graphics, rectangle);
            }
        }
        this.paintArrow(jMenuItem, graphics);
    }

    protected void paintArrow(JMenuItem jMenuItem, Graphics graphics) {
        int n2;
        int n3;
        int n4 = JideSwingUtilities.getOrientationOf(jMenuItem);
        if (n4 == 0) {
            n3 = jMenuItem.getWidth();
            n2 = jMenuItem.getHeight();
        } else {
            n3 = jMenuItem.getHeight();
            n2 = jMenuItem.getWidth();
        }
        int n5 = jMenuItem.getComponentOrientation().isLeftToRight() ? n3 - 9 : 4;
        if (jMenuItem.isEnabled()) {
            JideSwingUtilities.paintArrow(graphics, this.getForegroundOfState(jMenuItem), n5, n2 / 2 - 1, 5, 0);
        } else {
            JideSwingUtilities.paintArrow(graphics, UIDefaultsLookup.getColor("controlShadow"), n5, n2 / 2 - 1, 5, 0);
        }
    }

    protected Rectangle getDropDownRect(JComponent jComponent, int n2, int n3, int n4) {
        Object object = jComponent.getClientProperty("JButton.segmentPosition");
        Rectangle rectangle = jComponent.getComponentOrientation().isLeftToRight() ? new Rectangle(n3 - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n4) : new Rectangle(0, 0, this._splitButtonMargin - this.getOffset(), n4);
        if (object != null && !"only".equals(object)) {
            if ("first".equals(object)) {
                if (n2 == 0) {
                    ++rectangle.width;
                } else {
                    ++rectangle.height;
                }
            } else if ("middle".equals(object)) {
                if (n2 == 0) {
                    ++rectangle.width;
                } else {
                    ++rectangle.height;
                }
            } else if ("last".equals(object)) {
                // empty if block
            }
        }
        return rectangle;
    }

    protected Rectangle getButtonRect(JComponent jComponent, int n2, int n3, int n4) {
        Rectangle rectangle = n2 == 0 && jComponent.getComponentOrientation().isLeftToRight() ? new Rectangle(0, 0, n3 - this._splitButtonMargin, n4) : new Rectangle(this._splitButtonMargin - 1, 0, n3 - this._splitButtonMargin, n4);
        return rectangle;
    }

    protected void paintSunkenBorder(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    protected void paintSunken2Border(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._darkShadowColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 2);
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 3, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 3);
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.x, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    protected void paintRaised2Border(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.drawLine(rectangle.x + rectangle.width - 2, 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.setColor(this._darkShadowColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    protected void paintRaisedBorder(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this._lightHighlightColor);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(this._shadowColor);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(color);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getPreferredSize(jComponent);
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        boolean bl = JideSwingUtilities.getOrientationOf(jComponent) == 0;
        Dimension dimension = JideSwingUtilities.getPreferredButtonSize(abstractButton, this.defaultTextIconGap, true);
        if (BasicJideButtonUI.shouldWrapText(jComponent)) {
            if (jComponent instanceof JideSplitButton) {
                dimension.width += BasicJideSplitButtonUI.getAdjustExtraWidth(abstractButton, abstractButton.getText(), 8);
            }
        } else {
            dimension.width += this.getRightMargin();
            if (this.isDownArrowVisible(abstractButton.getParent())) {
                ++dimension.width;
            }
        }
        if (bl) {
            return dimension;
        }
        return new Dimension(dimension.height, dimension.width);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getMinimumSize(jComponent);
        }
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
                dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
            } else {
                dimension.height = (int)((float)dimension.height - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
            }
        }
        return dimension;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getMaximumSize(jComponent);
        }
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
                dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
            } else {
                dimension.height = (int)((float)dimension.height + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
            }
        }
        return dimension;
    }

    @Override
    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        Object object;
        int n2;
        ButtonModel buttonModel = jMenuItem.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (!(jMenuItem instanceof JMenu) || !((JMenu)jMenuItem).isTopLevelMenu()) {
            n2 = UIDefaultsLookup.getInt("MenuItem.textIconGap");
            int n3 = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
            if (jMenuItem.getComponentOrientation().isLeftToRight()) {
                rectangle.x = n3 + n2;
            } else {
                object = fontMetrics.getStringBounds(string, graphics);
                rectangle.x = (int)((double)(jMenuItem.getWidth() - n3 - n2) + ((RectangularShape)object).getWidth() + (double)(4 + jMenuItem.getHeight() / 2 - 1));
            }
        } else if (!jMenuItem.getComponentOrientation().isLeftToRight() && jMenuItem.getComponentOrientation().isHorizontal()) {
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            rectangle.x = (int)((double)(jMenuItem.getWidth() - rectangle.x) - rectangle2D.getWidth() + (double)(4 + jMenuItem.getHeight() / 2 - 1));
        }
        n2 = jMenuItem.getDisplayedMnemonicIndex();
        if (WindowsLookAndFeel.isMnemonicHidden()) {
            n2 = -1;
        }
        Color color = graphics.getColor();
        if (!buttonModel.isEnabled() || jMenuItem instanceof JideSplitButton && !((JideSplitButton)jMenuItem).isButtonEnabled()) {
            if (jMenuItem.getParent() != null) {
                graphics.setColor(jMenuItem.getParent().getBackground().brighter());
                this.drawStringUnderlineCharAt(jMenuItem, graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(jMenuItem.getParent().getBackground().darker());
            }
            this.drawStringUnderlineCharAt(jMenuItem, graphics, string, n2, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        } else {
            object = this.getForegroundOfState(jMenuItem);
            if (object == null || object instanceof UIResource) {
                if (buttonModel.isSelected()) {
                    graphics.setColor(this.selectionForeground);
                } else {
                    graphics.setColor((Color)object);
                }
            } else {
                graphics.setColor((Color)object);
            }
            this.drawStringUnderlineCharAt(jMenuItem, graphics, string, n2, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
        graphics.setColor(color);
    }

    private Color getForegroundOfState(JMenuItem jMenuItem) {
        int n2 = JideSwingUtilities.getButtonState(jMenuItem);
        Color color = null;
        if (jMenuItem instanceof ComponentStateSupport) {
            color = ((ComponentStateSupport)((Object)jMenuItem)).getForegroundOfState(n2);
        }
        if (color == null || color instanceof UIResource) {
            color = jMenuItem.getForeground();
        }
        return color;
    }

    protected void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n2, int n3, int n4) {
        JideSwingUtilities.drawStringUnderlineCharAt(jComponent, graphics, string, n2, n3, n4);
    }

    @Override
    protected void paintIcon(JMenuItem jMenuItem, Graphics graphics) {
        Icon icon;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (jMenuItem.getIcon() != null && (icon = this.getIcon(jMenuItem)) != null) {
            boolean bl;
            if (!jMenuItem.getComponentOrientation().isLeftToRight() && jMenuItem.getComponentOrientation().isHorizontal()) {
                BasicJideSplitButtonUI.iconRect.x = jMenuItem.getWidth() - BasicJideSplitButtonUI.iconRect.x - icon.getIconWidth() + (4 + jMenuItem.getHeight() / 2 - 1);
            }
            boolean bl2 = bl = buttonModel.isEnabled() && (!(buttonModel instanceof SplitButtonModel) || ((SplitButtonModel)buttonModel).isButtonEnabled());
            if (this.isFloatingIcon() && bl) {
                if (buttonModel.isRollover() && !buttonModel.isPressed() && !buttonModel.isSelected()) {
                    if (!"true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                        if (icon instanceof ImageIcon) {
                            ImageIcon imageIcon = IconsFactory.createGrayImage(((ImageIcon)icon).getImage());
                            imageIcon.paintIcon(jMenuItem, graphics, BasicJideSplitButtonUI.iconRect.x + 1, BasicJideSplitButtonUI.iconRect.y + 1);
                        } else {
                            ImageIcon imageIcon = IconsFactory.createGrayImage(jMenuItem, icon);
                            imageIcon.paintIcon(jMenuItem, graphics, BasicJideSplitButtonUI.iconRect.x + 1, BasicJideSplitButtonUI.iconRect.y + 1);
                        }
                        icon.paintIcon(jMenuItem, graphics, BasicJideSplitButtonUI.iconRect.x - 1, BasicJideSplitButtonUI.iconRect.y - 1);
                    } else {
                        icon.paintIcon(jMenuItem, graphics, BasicJideSplitButtonUI.iconRect.x, BasicJideSplitButtonUI.iconRect.y);
                    }
                } else {
                    icon.paintIcon(jMenuItem, graphics, BasicJideSplitButtonUI.iconRect.x, BasicJideSplitButtonUI.iconRect.y);
                }
            } else {
                icon.paintIcon(jMenuItem, graphics, BasicJideSplitButtonUI.iconRect.x, BasicJideSplitButtonUI.iconRect.y);
            }
        }
    }

    @Override
    protected boolean isFloatingIcon() {
        return this._isFloatingIcon;
    }

    @Override
    protected Icon getIcon(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = abstractButton.getIcon();
        Icon icon2 = null;
        if (!buttonModel.isEnabled() || !((JideSplitButton)this.menuItem).isButtonEnabled()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            if (icon2 == null) {
                icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(abstractButton, icon);
            }
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon2 = abstractButton.getPressedIcon();
            if (icon2 != null) {
                // empty if block
            }
        } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getRolloverSelectedIcon() : abstractButton.getRolloverIcon();
        } else if (buttonModel.isSelected()) {
            icon2 = abstractButton.getSelectedIcon();
        }
        if (icon2 != null) {
            icon = icon2;
        }
        return icon;
    }

    protected int getOffset() {
        return 0;
    }

    protected boolean isAlwaysDropdown(JMenuItem jMenuItem) {
        return jMenuItem instanceof JideSplitButton && ((JideSplitButton)jMenuItem).isAlwaysDropdown();
    }

    @Override
    protected int getRightMargin() {
        return this._splitButtonMargin - 1;
    }

    public static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("pressed"));
        lazyActionMap.put(new Actions("released"));
        lazyActionMap.put(new Actions("downPressed"));
        lazyActionMap.put(new Actions("downReleased"));
    }

    @Override
    protected void updateMnemonicBinding() {
        super.updateMnemonicBinding();
        int n2 = this.menuItem.getModel().getMnemonic();
        if (n2 != 0 && this.windowInputMap != null) {
            int[] nArray = (int[])UIDefaultsLookup.get("Menu.shortcutKeys");
            if (nArray == null) {
                nArray = new int[]{8};
            }
            for (int n3 : nArray) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(n2, n3, false), "pressed");
                this.windowInputMap.put(KeyStroke.getKeyStroke(n2, n3, true), "released");
            }
        }
    }

    protected static void downButtonPressed(JMenu jMenu) {
        Object object;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        if (jMenu.isTopLevelMenu()) {
            if (jMenu.isSelected()) {
                menuSelectionManager.clearSelectedPath();
            } else {
                object = BasicJideSplitButtonUI.getFirstParentMenuElement(jMenu);
                if (object != null && object instanceof MenuElement) {
                    ArrayList<MenuElement[]> arrayList = new ArrayList<MenuElement[]>();
                    while (object instanceof MenuElement) {
                        arrayList.add(0, (MenuElement[])object);
                        if (object instanceof JPopupMenu) {
                            object = (Container)((JPopupMenu)object).getInvoker();
                            continue;
                        }
                        object = BasicJideSplitButtonUI.getFirstParentMenuElement((Component)object);
                    }
                    MenuElement[] menuElementArray = new MenuElement[arrayList.size() + 1];
                    for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                        Container container = (Container)arrayList.get(i2);
                        menuElementArray[i2] = (MenuElement)((Object)container);
                    }
                    menuElementArray[arrayList.size()] = jMenu;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                } else {
                    MenuElement[] menuElementArray = new MenuElement[]{jMenu};
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }
        if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length > 0 && object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu()) {
            if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                BasicJideSplitButtonUI.appendPath(object, jMenu.getPopupMenu());
            } else {
                BasicJideSplitButtonUI.setupPostTimer(jMenu);
            }
        }
    }

    protected static Container getFirstParentMenuElement(Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof MenuElement)) continue;
            return container;
        }
        return null;
    }

    public static int getAdjustExtraWidth(Component component, String string, int n2) {
        String[] stringArray = BasicJideSplitButtonUI.getWrappedText(string);
        Font font = component.getFont();
        FontMetrics fontMetrics = component.getFontMetrics(font);
        int n3 = fontMetrics.stringWidth(stringArray[0]);
        int n4 = stringArray.length <= 1 ? 0 : fontMetrics.stringWidth(stringArray[1]);
        int n5 = Math.max(n3, n4);
        int n6 = Math.max(n3, n4 += n2);
        return n6 - n5;
    }

    public static String getMaxLengthWord(String string) {
        if (string.indexOf(32) == -1) {
            return string;
        }
        int n2 = string.length();
        int n3 = -1;
        int n4 = string.length() / 2;
        int n5 = -1;
        while ((n5 = string.indexOf(32, n5 + 1)) != -1) {
            int n6 = Math.abs(n5 - n4);
            if (n6 >= n2) continue;
            n2 = n6;
            n3 = n5;
        }
        return n3 >= n4 ? string.substring(0, n3) : string.substring(n3 + 1);
    }

    public static String[] getWrappedText(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length <= 2) {
            return stringArray;
        }
        if (stringArray.length >= 3) {
            int n2 = string.length();
            int n3 = -1;
            int n4 = -1;
            int n5 = string.length() / 2;
            while ((n4 = string.indexOf(32, n4 + 1)) != -1) {
                int n6 = Math.abs(n4 - n5);
                if (n6 >= n2) continue;
                n2 = n6;
                n3 = n4;
            }
            return new String[]{string.substring(0, n3), string.substring(n3 + 1)};
        }
        return stringArray;
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";
        private static final String DOWN_PRESS = "downPressed";
        private static final String DOWN_RELEASE = "downReleased";

        Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            String string = this.getName();
            if (PRESS.equals(string) && ((JideSplitButton)abstractButton).isAlwaysDropdown()) {
                string = DOWN_PRESS;
            }
            if (PRESS.equals(string)) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
                if (!abstractButton.hasFocus()) {
                    abstractButton.requestFocus();
                }
            } else if (RELEASE.equals(string)) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            } else if (DOWN_PRESS.equals(string)) {
                BasicJideSplitButtonUI.downButtonPressed((JMenu)abstractButton);
            } else if (DOWN_RELEASE.equals(string)) {
                // empty if block
            }
        }

        @Override
        public boolean isEnabled(Object object) {
            return object == null || !(object instanceof AbstractButton) || ((AbstractButton)object).getModel().isEnabled();
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.cancelMenuIfNecessary(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            BasicJideSplitButtonUI.this.setMouseOver(true);
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (this.isClickOnButton(mouseEvent, jMenu)) {
                if (((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                    jMenu.getModel().setArmed(true);
                    jMenu.getModel().setPressed(true);
                }
                if (!jMenu.hasFocus() && jMenu.isRequestFocusEnabled()) {
                    jMenu.requestFocus();
                }
            } else {
                BasicJideSplitButtonUI.downButtonPressed(jMenu);
            }
        }

        private boolean isClickOnButton(MouseEvent mouseEvent, JMenu jMenu) {
            if (((JideSplitButton)jMenu).isAlwaysDropdown()) {
                return false;
            }
            boolean bl = false;
            if (BasicJideButtonUI.shouldWrapText(BasicJideSplitButtonUI.this.menuItem)) {
                int n2 = 27;
                if (JideSwingUtilities.getOrientationOf(BasicJideSplitButtonUI.this.menuItem) == 0) {
                    if (mouseEvent.getPoint().getY() < (double)(jMenu.getHeight() - n2)) {
                        bl = true;
                    }
                } else if (mouseEvent.getPoint().getY() < (double)(jMenu.getHeight() - n2)) {
                    bl = true;
                }
            } else {
                int n3;
                int n4 = n3 = ((JMenu)BasicJideSplitButtonUI.this.menuItem).isTopLevelMenu() ? BasicJideSplitButtonUI.this._splitButtonMargin : BasicJideSplitButtonUI.this._splitButtonMarginOnMenu;
                if (JideSwingUtilities.getOrientationOf(BasicJideSplitButtonUI.this.menuItem) == 0) {
                    if (jMenu.getComponentOrientation().isLeftToRight()) {
                        if (mouseEvent.getPoint().getX() < (double)(jMenu.getWidth() - n3)) {
                            bl = true;
                        }
                    } else if (mouseEvent.getPoint().getX() >= (double)n3) {
                        bl = true;
                    }
                } else if (mouseEvent.getPoint().getY() < (double)(jMenu.getHeight() - n3)) {
                    bl = true;
                }
            }
            return bl;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            if (!this.isClickOnButton(mouseEvent, jMenu)) {
                BasicJideSplitButtonUI.this.menuItem.getModel().setArmed(false);
                BasicJideSplitButtonUI.this.menuItem.getModel().setPressed(false);
            }
            this.cancelMenuIfNecessary(mouseEvent);
        }

        private void cancelMenuIfNecessary(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            if (this.isClickOnButton(mouseEvent, jMenu) && ((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    jMenu.getModel().setPressed(false);
                    jMenu.getModel().setArmed(false);
                } else {
                    jMenu.getModel().setArmed(false);
                    jMenu.getModel().setPressed(false);
                }
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                for (int i2 = menuElementArray.length - 1; i2 >= 0; --i2) {
                    MenuElement menuElement = menuElementArray[i2];
                    if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf(jMenu)) continue;
                    jMenu.getModel().setRollover(false);
                    BasicJideSplitButtonUI.this.setMouseOver(false);
                    menuSelectionManager.clearSelectedPath();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!jMenu.isTopLevelMenu()) {
                if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        BasicJideSplitButtonUI.appendPath(BasicJideSplitButtonUI.this.getPath(), jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(BasicJideSplitButtonUI.this.getPath());
                        BasicJideSplitButtonUI.setupPostTimer(jMenu);
                    }
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                MenuElement[] menuElementArray2 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray2);
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                BasicJideSplitButtonUI.this.setMouseOver(true);
            }
            BasicJideSplitButtonUI.this.menuItem.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            BasicJideSplitButtonUI.this.setMouseOver(false);
            BasicJideSplitButtonUI.this.menuItem.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)BasicJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            if (BasicJideSplitButtonUI.this.menuItem instanceof JideSplitButton) {
                if (this.isClickOnButton(mouseEvent, (JMenu)BasicJideSplitButtonUI.this.menuItem)) {
                    ((SplitButtonModel)((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).getModel()).setButtonRollover(true);
                } else {
                    ((SplitButtonModel)((JideSplitButton)BasicJideSplitButtonUI.this.menuItem).getModel()).setButtonRollover(false);
                }
            }
        }
    }
}

