/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.plaf.basic.BasicJideOptionPaneUI;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class JideOptionPane
extends JOptionPane {
    private static final long serialVersionUID = 1916857052448620771L;
    private Object _title;
    private Object _details;
    public static final String DETAILS_PROPERTY = "details";
    public static final String TITLE_PROPERTY = "title";
    public static final int CLOSE_OPTION = 3;

    public JideOptionPane() {
        this.initComponents();
    }

    public JideOptionPane(Object object) {
        super(object);
        this.initComponents();
    }

    public JideOptionPane(Object object, int n2) {
        super(object, n2);
        this.initComponents();
    }

    public JideOptionPane(Object object, int n2, int n3) {
        super(object, n2, n3);
        this.initComponents();
    }

    public JideOptionPane(Object object, int n2, int n3, Icon icon) {
        super(object, n2, n3, icon);
        this.initComponents();
    }

    public JideOptionPane(Object object, int n2, int n3, Icon icon, Object[] objectArray) {
        super(object, n2, n3, icon, objectArray);
        this.initComponents();
    }

    public JideOptionPane(Object object, int n2, int n3, Icon icon, Object[] objectArray, Object object2) {
        super(object, n2, n3, icon, objectArray, object2);
        this.initComponents();
    }

    protected void initComponents() {
    }

    @Override
    public void setOptionType(int n2) {
        if (n2 != -1 && n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3) {
            throw new RuntimeException("JOptionPane: option type must be one of JOptionPane.DEFAULT_OPTION, JOptionPane.YES_NO_OPTION, JOptionPane.YES_NO_CANCEL_OPTION or JOptionPane.OK_CANCEL_OPTION");
        }
        int n3 = this.optionType;
        this.optionType = n2;
        this.firePropertyChange("optionType", n3, this.optionType);
    }

    public void setDetails(Object object) {
        Object object2 = this._details;
        this._details = object;
        this.firePropertyChange(DETAILS_PROPERTY, object2, this._details);
    }

    public Object getDetails() {
        return this._details;
    }

    public Object getTitle() {
        return this._title;
    }

    public void setTitle(Object object) {
        Object object2 = this._title;
        this._title = object;
        this.firePropertyChange(TITLE_PROPERTY, object2, this._title);
    }

    public void setDetailsVisible(boolean bl) {
        ((BasicJideOptionPaneUI)this.getUI()).setDetailsVisible(bl);
    }

    public String getResourceString(String string) {
        return ButtonResources.getResourceBundle(this.getLocale()).getString(string);
    }

    public boolean isDetailsVisible() {
        return ((BasicJideOptionPaneUI)this.getUI()).isDetailsVisible();
    }

    @Override
    public void setLocale(Locale locale) {
        if (!JideSwingUtilities.equals(locale, this.getLocale())) {
            super.setLocale(locale);
            this.updateUI();
        }
    }

    public static String showInputDialog(Object object) throws HeadlessException {
        return JideOptionPane.showInputDialog(null, object);
    }

    public static String showInputDialog(Object object, Object object2) {
        return JideOptionPane.showInputDialog(null, object, object2);
    }

    public static String showInputDialog(Component component, Object object) throws HeadlessException {
        return JideOptionPane.showInputDialog(component, object, UIManager.getString("OptionPane.inputDialogTitle"), 3);
    }

    public static String showInputDialog(Component component, Object object, Object object2) {
        return (String)JideOptionPane.showInputDialog(component, object, UIManager.getString("OptionPane.inputDialogTitle"), 3, null, null, object2);
    }

    public static String showInputDialog(Component component, Object object, String string, int n2) throws HeadlessException {
        return (String)JideOptionPane.showInputDialog(component, object, string, n2, null, null, null);
    }

    public static Object showInputDialog(Component component, Object object, String string, int n2, Icon icon, Object[] objectArray, Object object2) throws HeadlessException {
        JideOptionPane jideOptionPane = new JideOptionPane(object, n2, 2, icon, null, null);
        if (component != null) {
            jideOptionPane.setLocale(component.getLocale());
        }
        jideOptionPane.setWantsInput(true);
        jideOptionPane.setSelectionValues(objectArray);
        jideOptionPane.setInitialSelectionValue(object2);
        jideOptionPane.setComponentOrientation((component == null ? JideOptionPane.getRootFrame() : component).getComponentOrientation());
        int n3 = JideOptionPane.styleFromMessageType(n2);
        JDialog jDialog = jideOptionPane.createDialog(component, string, n3);
        jideOptionPane.selectInitialValue();
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object3 = jideOptionPane.getInputValue();
        if (object3 == UNINITIALIZED_VALUE) {
            return null;
        }
        return object3;
    }

    private static int styleFromMessageType(int n2) {
        switch (n2) {
            case 0: {
                return 4;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 3;
            }
        }
        return 2;
    }

    public static void showMessageDialog(Component component, Object object) throws HeadlessException {
        JideOptionPane.showMessageDialog(component, object, UIManager.getString("OptionPane.messageDialogTitle"), 1);
    }

    public static void showMessageDialog(Component component, Object object, String string, int n2) throws HeadlessException {
        JideOptionPane.showMessageDialog(component, object, string, n2, null);
    }

    public static void showMessageDialog(Component component, Object object, String string, int n2, Icon icon) throws HeadlessException {
        JideOptionPane.showOptionDialog(component, object, string, -1, n2, icon, null, null);
    }

    public static int showConfirmDialog(Component component, Object object) throws HeadlessException {
        return JideOptionPane.showConfirmDialog(component, object, UIManager.getString("OptionPane.titleText"), 1);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n2) throws HeadlessException {
        return JideOptionPane.showConfirmDialog(component, object, string, n2, 3);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n2, int n3) throws HeadlessException {
        return JideOptionPane.showConfirmDialog(component, object, string, n2, n3, null);
    }

    public static int showConfirmDialog(Component component, Object object, String string, int n2, int n3, Icon icon) throws HeadlessException {
        return JideOptionPane.showOptionDialog(component, object, string, n2, n3, icon, null, null);
    }

    public static int showOptionDialog(Component component, Object object, String string, int n2, int n3, Icon icon, Object[] objectArray, Object object2) throws HeadlessException {
        JideOptionPane jideOptionPane = new JideOptionPane(object, n3, n2, icon, objectArray, object2);
        if (component != null) {
            jideOptionPane.setLocale(component.getLocale());
        }
        jideOptionPane.setInitialValue(object2);
        jideOptionPane.setComponentOrientation((component == null ? JideOptionPane.getRootFrame() : component).getComponentOrientation());
        int n4 = JideOptionPane.styleFromMessageType(n3);
        JDialog jDialog = jideOptionPane.createDialog(component, string, n4);
        jideOptionPane.selectInitialValue();
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object3 = jideOptionPane.getValue();
        if (object3 == null) {
            return -1;
        }
        if (objectArray == null) {
            if (object3 instanceof Integer) {
                return (Integer)object3;
            }
            return -1;
        }
        int n5 = objectArray.length;
        for (int i2 = 0; i2 < n5; ++i2) {
            if (!objectArray[i2].equals(object3)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public JDialog createDialog(Component component, String string) throws HeadlessException {
        int n2 = JideOptionPane.styleFromMessageType(this.getMessageType());
        return this.createDialog(component, string, n2);
    }

    @Override
    public JDialog createDialog(String string) throws HeadlessException {
        int n2 = JideOptionPane.styleFromMessageType(this.getMessageType());
        JDialog jDialog = new JDialog((Dialog)null, string, true);
        this.initDialog(jDialog, n2, null);
        return jDialog;
    }

    private JDialog createDialog(Component component, String string, int n2) throws HeadlessException {
        Window window = JideOptionPane.getWindowForComponent(component);
        JDialog jDialog = window instanceof Frame ? new JDialog((Frame)window, string, true) : new JDialog((Dialog)window, string, true);
        this.initDialog(jDialog, n2, component);
        return jDialog;
    }

    private void initDialog(final JDialog jDialog, int n2, Component component) {
        boolean bl;
        jDialog.setComponentOrientation(this.getComponentOrientation());
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        jDialog.setResizable(false);
        if (JDialog.isDefaultLookAndFeelDecorated() && (bl = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            jDialog.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(n2);
        }
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        WindowAdapter windowAdapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JideOptionPane.this.setValue(null);
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                if (!this.gotFocus) {
                    JideOptionPane.this.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        };
        jDialog.addWindowListener(windowAdapter);
        jDialog.addWindowFocusListener(windowAdapter);
        jDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                JideOptionPane.this.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (jDialog.isVisible() && propertyChangeEvent.getSource() == JideOptionPane.this && propertyChangeEvent.getPropertyName().equals("value") && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    jDialog.setVisible(false);
                }
            }
        });
    }

    public static Frame getFrameForComponent(Component component) throws HeadlessException {
        if (component == null) {
            return JideOptionPane.getRootFrame();
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        return JOptionPane.getFrameForComponent(component.getParent());
    }

    static Window getWindowForComponent(Component component) throws HeadlessException {
        if (component == null) {
            return JideOptionPane.getRootFrame();
        }
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return JideOptionPane.getWindowForComponent(component.getParent());
    }
}

