.SS ACCOUNT
The ACCOUNT target is a high performance accounting system for large
local networks. It allows per-IP accounting in whole prefixes of IPv4
addresses with size of up to /8 without the need to add individual
accounting rule for each IP address.
.PP
The ACCOUNT is designed to be queried for data every second or at
least every ten seconds. It is written as kernel module to handle high
bandwidths without packet loss.
.PP
The largest possible subnet size is 24 bit, meaning for example 10.0.0.0/8
network. ACCOUNT uses fixed internal data structures
which speeds up the processing of each packet. Furthermore,
accounting data for one complete 192.168.1.X/24 network takes 4 KB of
memory. Memory for 16-bit or 24-bit networks is only allocated when
needed.
.PP
To optimize the kernel<->userspace data transfer a bit more, the
kernel module only transfers information about IPs, where the src/dst
packet counter is not 0. This saves precious kernel time.
.PP
There is no /proc interface as it would be too slow for continuous access.
The read-and-flush query operation is the fastest, as no internal data
snapshot needs to be created&copied for all data. Use the "read"
operation without flush only for debugging purposes!
.PP
Usage:
.PP
ACCOUNT takes two mandatory parameters:
.TP
\fB\-\-addr\fR \fInetwork\fP\fB/\fP\fInetmask\fR
where \fInetwork\fP\fB/\fP\fInetmask\fP is the subnet to account for, in CIDR syntax
.TP
\fB\-\-tname\fP \fINAME\fP
where \fINAME\fP is the name of the table where the accounting information
should be stored
.PP
The subnet 0.0.0.0/0 is a special case: all data are then stored in the src_bytes
and src_packets structure of slot "0". This is useful if you want
to account the overall traffic to/from your internet provider.
.PP
The data can be queried using the userspace libxt_ACCOUNT_cl library,
and by the reference implementation to show usage of this library,
the \fBiptaccount\fP(8) tool.
.PP
Here is an example of use:
.PP
iptables \-A FORWARD \-j ACCOUNT \-\-addr 0.0.0.0/0 \-\-tname all_outgoing;
iptables \-A FORWARD \-j ACCOUNT \-\-addr 192.168.1.0/24 \-\-tname sales;
.PP
This creates two tables called "all_outgoing" and "sales" which can be
queried using the userspace library/iptaccount tool.
.PP
Note that this target is non-terminating \(em the packet destined to it
will continue traversing the chain in which it has been used.
.PP
Also note that once a table has been defined for specific CIDR address/netmask
block, it can be referenced multiple times using \-j ACCOUNT, provided
that both the original table name and address/netmask block are specified.
.PP
For more information go to https://www.intra2net.com/en/developer/ipt_ACCOUNT/
.SS CHAOS
.PP
Causes confusion on the other end by doing odd things with incoming packets.
CHAOS will randomly reply (or not) with one of its configurable subtargets:
.TP
\fB\-\-delude\fP
Use the REJECT and DELUDE targets as a base to do a sudden or deferred
connection reset, fooling some network scanners to return non-deterministic
(randomly open/closed) results, and in case it is deemed open, it is actually
closed/filtered.
.TP
\fB\-\-tarpit\fP
Use the REJECT and TARPIT target as a base to hold the connection until it
times out. This consumes conntrack entries when connection tracking is loaded
(which usually is on most machines), and routers between you and the Internet
may fail to do their connection tracking if they have to handle more
connections than they can.
.PP
The randomness factor of not replying vs. replying can be set during load-time
of the xt_CHAOS module or during runtime in /sys/modules/xt_CHAOS/parameters.
.PP
See https://inai.de/projects/chaostables/ for more information
about CHAOS, DELUDE and lscan.
.SS DELUDE
.PP
The DELUDE target will reply to a SYN packet with SYN-ACK, and to all other
packets with an RST. This will terminate the connection much like REJECT, but
network scanners doing TCP half-open discovery can be spoofed to make them
believe the port is open rather than closed/filtered.
.SS DHCPMAC
.PP
In conjunction with ebtables, DHCPMAC can be used to completely change all MAC
addresses from and to a VMware-based virtual machine. This is needed because
VMware does not allow one to set a non-VMware MAC address before an operating
system is booted (and the MAC be changed with `ip link set eth0 address
aa:bb..`).
.TP
\fB\-\-set\-mac\fP \fIaa:bb:cc:dd:ee:ff\fP[\fB/\fP\fImask\fP]
Replace the client host MAC address field in the DHCP message with the given
MAC address. This option is mandatory. The \fImask\fP parameter specifies the
prefix length of bits to change.
.PP
EXAMPLE, replacing all addresses from one of VMware's assigned vendor IDs
(00:50:56) addresses with something else:
.PP
iptables \-t mangle \-A FORWARD \-p udp \-\-dport 67 \-m physdev
\-\-physdev\-in vmnet1 \-m dhcpmac \-\-mac 00:50:56:00:00:00/24 \-j DHCPMAC
\-\-set\-mac ab:cd:ef:00:00:00/24
.PP
iptables \-t mangle \-A FORWARD \-p udp \-\-dport 68 \-m physdev
\-\-physdev\-out vmnet1 \-m dhcpmac \-\-mac ab:cd:ef:00:00:00/24 \-j DHCPMAC
\-\-set\-mac 00:50:56:00:00:00/24
.PP
(This assumes there is a bridge interface that has vmnet1 as a port. You will
also need to add appropriate ebtables rules to change the MAC address of the
Ethernet headers.)
.SS DNETMAP
.PP
The \fBDNETMAP\fR target allows dynamic two-way 1:1 mapping of IPv4 subnets. A
single rule can map a private subnet to a shorter public subnet, creating and
maintaining unambiguous private-public IP address bindings. The second rule can
be used to map new flows to a private subnet according to maintained bindings.
The target allows efficient public IPv4 space usage and unambiguous NAT at the
same time.
.PP
The target can be used only in the \fBnat\fR table in \fBPOSTROUTING\fR or
\fBOUTPUT\fR chains for SNAT, and in \fBPREROUTING\fR for DNAT. Only flows
directed to bound addresses will be DNATed. The packet continues chain
traversal if there is no free postnat address to be assigned to the prenat
address. The default binding \fBTTL\fR is \fI10 minutes\fR and can be changed
using the \fBdefault_ttl\fR module option. The default address hash size is 256
and can be changed using the \fBhash_size\fR module option.
.TP
\fB\-\-prefix\fR \fIaddr\fR\fB/\fR\fImask\fR
The network subnet to map to. If not specified, all existing prefixes are used.
.TP
\fB\-\-reuse\fR
Reuse the entry for a given prenat address from any prefix even if the
binding's TTL is < 0.
.TP
\fB\-\-persistent\fR
Set the prefix to be persistent. It will not be removed after deleting the last
iptables rule. The option is effective only in the first rule for a given
prefix. If you need to change persistency for an existing prefix, please use
the procfs interface described below.
.TP
\fB\-\-static\fR
Do not create dynamic mappings using this rule. Use static mappings only. Note
that you need to create static mappings via the procfs interface for this rule
for this option to have any effect.
.TP
\fB\-\-ttl\fR \fIseconds\fR
Reset the binding's TTL value to \fIseconds\fR. If a negative value is
specified, the binding's TTL is kept unchanged. If this option is not
specified, then the default TTL value (600s) is used.
.PP
\fB* /proc interface\fR
.PP
The module creates the following entries for each new specified subnet:
.TP
\fB/proc/net/xt_DNETMAP/\fR\fIsubnet\fR\fB_\fR\fImask\fR
Contains the binding table for the given \fIsubnet/mask\fP. Each line contains
\fBprenat address\fR, \fBpostnat address\fR, \fBttl\fR (seconds until the entry
times out), \fBlasthit\fR (last hit to the entry in seconds relative to system
boot time). Please note that the \fBttl\fR and \fBlasthit\fR entries contain an
\(oq\fBS\fR\(cq in case of a static binding.
.TP
\fB/proc/net/xt_DNETMAP/\fR\fIsubnet\fR\fB_\fR\fImask\fR\fB_stat\fR
Contains statistics for a given \fIsubnet/mask\fP. The line contains four
numerical values separated by spaces. The first one is the number of currently
used dynamic addresses (bindings with negative TTL excluded), the second one is
the number of static assignments, the third one is the number of all usable
addresses in the subnet, and the fourth one is the mean \fBTTL\fR value for all
active entries. If the prefix has the persistent flag set, it will be noted as
fifth entry.
.PP
The following write operations are supported via the procfs interface:
.TP
echo "+\fIprenat-address\fR:\fIpostnat-address\fR" >\fB/proc/net/xt_DNETMAP/subnet_mask\fR
Adds a static binding between the prenat and postnap address. If
postnat_address is already bound, any previous binding will be timed out
immediately. A static binding is never timed out.
.TP
echo "\-\fIaddress\fR" >\fB/proc/net/xt_DNETMAP/subnet_mask\fR
Removes the binding with \fIaddress\fR as prenat or postnat address. If the
removed binding is currently static, it will make the entry available for
dynamic allocation.
.TP
echo "+persistent" >\fB/proc/net/xt_DNETMAP/subnet_mask\fR
Sets the persistent flag for the prefix. It is useful if you do not want
bindings to get flushed when the firewall is restarted. You can check if the
prefix is persistent by printing the contents of
\fB/proc/net/xt_DNETMAP/\fR\fIsubnet\fR\fB_\fR\fImask\fR\fB_stat\fR.
.TP
echo "\-persistent" >\fB/proc/net/xt_DNETMAP/subnet_mask\fR
Unsets the persistent flag for the prefix. In this mode, the prefix will be
deleted if the last iptables rule for that prefix is removed.
.TP
echo "flush" >\fB/proc/net/xt_DNETMAP/subnet_mask\fR
Flushes all bindings for the specific prefix. All static entries are also
flushed and become available for dynamic bindings.
.PP
Note! Entries are removed if the last iptables rule for a specific prefix is
deleted unless the persistent flag is set.
.PP
\fB* Logging\fR
.PP
The module logs binding add/timeout events to klog. This behavior can be
disabled using the \fBdisable_log\fR module parameter.
.PP
\fB* Examples\fR
.PP
\fB1.\fR Map subnet 192.168.0.0/24 to subnets 20.0.0.0/26. SNAT only:
.PP
iptables \-t nat \-A POSTROUTING \-s 192.168.0.0/24 \-j DNETMAP \-\-prefix 20.0.0.0/26
.PP
Active hosts from the 192.168.0.0/24 subnet are mapped to 20.0.0.0/26. If the
packet from a not yet bound prenat address hits the rule and there are no free
or timed-out (TTL<0) entries in prefix 20.0.0.0/28, then a notice is logged to
klog and chain traversal continues. If packet from an already-bound prenat
address hits the rule, the binding's TTL value is reset to default_ttl and SNAT
is performed.
.PP
\fB2.\fR Use of \fB\-\-reuse\fR and \fB\-\-ttl\fR switches, multiple rule
interaction:
.PP
iptables \-t nat \-A POSTROUTING \-s 192.168.0.0/24 \-j DNETMAP \-\-prefix
20.0.0.0/26 \-\-reuse \-\-ttl 200
.PP
iptables \-t nat \-A POSTROUTING \-s 192.168.0.0/24 \-j DNETMAP \-\-prefix 30.0.0.0/26
.PP
Active hosts from 192.168.0.0/24 subnet are mapped to 20.0.0.0/26 with TTL =
200 seconds. If there are no free addresses in first prefix, the next one
(30.0.0.0/26) is used with the default TTL. It is important to note that the
first rule SNATs all flows whose source address is already actively bound
(TTL>0) to ANY prefix. The \fB\-\-reuse\fR parameter makes this functionality
work even for inactive (TTL<0) entries.
.PP
If both subnets are exhausted, then chain traversal continues.
.PP
\fB3.\fR Map 192.168.0.0/24 to subnets 20.0.0.0/26 in a bidirectional way:
.PP
iptables \-t nat \-A POSTROUTING \-s 192.168.0.0/24 \-j DNETMAP \-\-prefix 20.0.0.0/26
.PP
iptables \-t nat \-A PREROUTING \-j DNETMAP
.PP
If the host 192.168.0.10 generates some traffic, it gets bound to first free
address in the subnet \(em 20.0.0.0. Now, any traffic directed to 20.0.0.0 gets
DNATed to 192.168.0.10 as long as there is an active (TTL>0) binding. There is
no need to specify \fB\-\-prefix\fR parameter in a PREROUTING rule, because
this way, it DNATs traffic to all active prefixes. You could specify the prefix
you would like to make DNAT work for a specific prefix only.
.PP
\fB4.\fR Map 192.168.0.0/24 to subnets 20.0.0.0/26 with static assignments
only:
.PP
iptables \-t nat \-A POSTROUTING \-s 192.168.0.0/24 \-j DNETMAP \-\-prefix 20.0.0.0/26
\-\-static
.PP
echo "+192.168.0.10:20.0.0.1" >/proc/net/xt_DNETMAP/20.0.0.0_26
.br
echo "+192.168.0.11:20.0.0.2" >/proc/net/xt_DNETMAP/20.0.0.0_26
.br
echo "+192.168.0.51:20.0.0.3" >/proc/net/xt_DNETMAP/20.0.0.0_26
.PP
This configuration will allow only preconfigured static bindings to work due to
the \fBstatic\fR rule option. Without this flag, dynamic bindings would be
created using non-static entries.
.PP
\fB5.\fR Persistent prefix:
.PP
iptables \-t nat \-A POSTROUTING \-s 192.168.0.0/24 \-j DNETMAP \-\-prefix 20.0.0.0/26
\-\-persistent
.br
\fBor\fR
.br
iptables \-t nat \-A POSTROUTING \-s 192.168.0.0/24 \-j DNETMAP \-\-prefix 20.0.0.0/26
.br
echo "+persistent" >/proc/net/xt_DNETMAP/20.0.0.0_26
.PP
Now, we can check the persistent flag of the prefix:
.br
cat /proc/net/xt_DNETMAP/20.0.0.0_26
.br
0 0 64 0 \fBpersistent\fR
.PP
Flush the iptables nat table and see that prefix is still in existence:
.br
iptables \-F \-t nat
.br
ls \-l /proc/net/xt_DNETMAP
.br
\-rw\-r\-\-r\-\- 1 root root 0 06\-10 09:01 20.0.0.0_26
.br
\-rw\-r\-\-r\-\- 1 root root 0 06\-10 09:01 20.0.0.0_26_stat
.
.SS ECHO
.PP
The \fBECHO\fP target will send back all packets it received. It serves as an
examples for an Xtables target.
.PP
ECHO takes no options.
.SS IPMARK
.PP
Allows you to mark a received packet basing on its IP address. This
can replace many mangle/mark entries with only one, if you use
firewall based classifier.
.PP
This target is to be used inside the \fBmangle\fP table.
.TP
\fB\-\-addr\fP {\fBsrc\fP|\fBdst\fP}
Select source or destination IP address as a basis for the mark.
.TP
\fB\-\-and\-mask\fP \fImask\fP
Perform bitwise AND on the IP address and this bitmask.
.TP
\fB\-\-or\-mask\fP \fImask\fP
Perform bitwise OR on the IP address and this bitmask.
.TP
\fB\-\-shift\fP \fIvalue\fP
Shift addresses to the right by the given number of bits before taking it
as a mark. (This is done before ANDing or ORing it.) This option is needed
to select part of an IPv6 address, because marks are only 32 bits in size.
.PP
The order of IP address bytes is reversed to meet "human order of bytes":
192.168.0.1 is 0xc0a80001. At first the "AND" operation is performed, then
"OR".
.PP
Examples:
.PP
We create a queue for each user, the queue number is adequate
to the IP address of the user, e.g.: all packets going to/from 192.168.5.2
are directed to 1:0502 queue, 192.168.5.12 -> 1:050c etc.
.PP
We have one classifier rule:
.IP
tc filter add dev eth3 parent 1:0 protocol ip fw
.PP
Earlier we had many rules just like below:
.IP
iptables \-t mangle \-A POSTROUTING \-o eth3 \-d 192.168.5.2 \-j MARK
\-\-set\-mark 0x10502
.IP
iptables \-t mangle \-A POSTROUTING \-o eth3 \-d 192.168.5.3 \-j MARK
\-\-set\-mark 0x10503
.PP
Using IPMARK target we can replace all the mangle/mark rules with only one:
.IP
iptables \-t mangle \-A POSTROUTING \-o eth3 \-j IPMARK \-\-addr dst
\-\-and\-mask 0xffff \-\-or\-mask 0x10000
.PP
On the routers with hundreds of users there should be significant load
decrease (e.g. twice).
.PP
(IPv6 example) If the source address is of the form
2001:db8:45:1d:20d:93ff:fe9b:e443 and the resulting mark should be 0x93ff,
then a right-shift of 16 is needed first:
.IP
\-t mangle \-A PREROUTING \-s 2001:db8::/32 \-j IPMARK \-\-addr src \-\-shift
16 \-\-and\-mask 0xFFFF
.SS LOGMARK
.PP
The LOGMARK target will log packet and connection marks to syslog.
.TP
\fB\-\-log\-level\fR \fIlevel\fR
A logging level between 0 and 8 (inclusive).
.TP
\fB\-\-log\-prefix\fR \fIstring\fR
Prefix log messages with the specified prefix; up to 29 bytes long, and useful
for distinguishing messages in the logs.
.SS PROTO
.PP
The PROTO target modifies the protocol number in IP packet header.
.TP
\fB\-\-proto-set\fP \fIproto_num\fP
This option is mandatory. \fIproto_num\fP is the protocol number to which you want to
modify the packets.
.TP
\fB\-\-stop-at-frag\fP
This option is only valid for IPv6 rules. When specifying this option, the
fragment extension header will be seen as a non-extension header.
.TP
\fB\-\-stop-at-auth\fP
This option is only valid for IPv6 rules. When specifying this option, the
authentication extension header will be seen as a non-extension header.
.PP
For IPv4 packets, the \fBProtocol\fP field is modified and the checksum is
recalculated.
.PP
For IPv6 packets, the scenario can be more complex due to the introduction of
the extension headers mechanism. By default, the PROTO target will scan the IPv6
packet, finding the last extension header and modify its \fBNext-header\fP field.
Normally, the following headers will be seen as an extension header:
\fINEXTHDR_HOP\fP,
\fINEXTHDR_ROUTING\fP,
\fINEXTHDR_FRAGMENT\fP,
\fINEXTHDR_AUTH\fP,
\fINEXTHDR_DEST\fP.
.PP
For fragmented packets, only the first fragment is processed and other fragments
are not touched.
.SS SYSRQ
.PP
The SYSRQ target allows one to remotely trigger sysrq on the local machine over
the network. This can be useful when vital parts of the machine hang, for
example an oops in a file system causing locks to be not released and processes
to get stuck as a result \(em if still possible, use /proc/sysrq-trigger. Even
when processes are stuck, interrupts are likely to be still processed, and as
such, sysrq can be triggered through incoming network packets.
.PP
The xt_SYSRQ implementation uses a salted hash and a sequence number to prevent
network sniffers from either guessing the password or replaying earlier
requests. The initial sequence number comes from the time of day so you will
have a small window of vulnerability should time go backwards at a reboot.
However, the file /sys/module/xt_SYSREQ/seqno can be used to both query and
update the current sequence number. Also, you should limit as to who can issue
commands using \fB\-s\fP and/or \fB\-m mac\fP, and also that the destination is
correct using \fB\-d\fP (to protect against potential broadcast packets),
noting that it is still short of MAC/IP spoofing:
.IP
\-A INPUT \-s 10.10.25.1 \-m mac \-\-mac\-source aa:bb:cc:dd:ee:ff \-d
10.10.25.7 \-p udp \-\-dport 9 \-j SYSRQ
.IP
(with IPsec) \-A INPUT \-s 10.10.25.1 \-d 10.10.25.7 \-m policy \-\-dir in
\-\-pol ipsec \-\-proto esp \-\-tunnel\-src 10.10.25.1 \-\-tunnel\-dst
10.10.25.7 \-p udp \-\-dport 9 \-j SYSRQ
.PP
You should also limit the rate at which connections can be received to limit
the CPU time taken by illegal requests, for example:
.IP
\-A INPUT \-s 10.10.25.1 \-m mac \-\-mac\-source aa:bb:cc:dd:ee:ff \-d
10.10.25.7 \-p udp \-\-dport 9 \-m limit \-\-limit 5/minute \-j SYSRQ
.PP
This extension does not take any options. The \fB\-p udp\fP options are
required.
.PP
The SYSRQ password can be changed through
/sys/module/xt_SYSRQ/parameters/password, for example:
.IP
echo \-n "password" >/sys/module/xt_SYSRQ/parameters/password
.PP
The module will not respond to sysrq requests until a password has been set.
.PP
Alternatively, the password may be specified at modprobe time, but this is
insecure as people can possible see it through ps(1). You can use an option
line in e.g. /etc/modprobe.d/xt_sysrq if it is properly guarded, that is, only
readable by root.
.IP
options xt_SYSRQ password=cookies
.PP
The hash algorithm can also be specified as a module option, for example, to
use SHA-256 instead of the default SHA-1:
.IP
options xt_SYSRQ hash=sha256
.PP
The xt_SYSRQ module is normally silent unless a successful request is received,
but the \fIdebug\fP module parameter can be used to find exactly why a
seemingly correct request is not being processed.
.PP
To trigger SYSRQ from a remote host, just use socat:
.PP
.nf
sysrq_key="s"  # the SysRq key(s)
password="password"
seqno="$(date +%s)"
salt="$(dd bs=12 count=1 if=/dev/urandom 2>/dev/null |
    openssl enc \-base64)"
ipaddr="2001:0db8:0000:0000:0000:ff00:0042:8329"
req="$sysrq_key,$seqno,$salt"
req="$req,$(echo \-n "$req,$ipaddr,$password" | sha1sum | cut \-c1\-40)"

echo "$req" | socat stdin udp\-sendto:$ipaddr:9
.fi
.PP
See the Linux docs for possible sysrq keys. Important ones are: re(b)oot,
power(o)ff, (s)ync file systems, (u)mount and remount readonly. More than one
sysrq key can be used at once, but bear in mind that, for example, a sync may
not complete before a subsequent reboot or poweroff.
.PP
An IPv4 address should have no leading zeros, an IPv6 address should
be in the full expanded form (as shown above). The debug option will cause
output to be emitted in the same form.
.PP
The hashing scheme should be enough to prevent mis-use of SYSRQ in many
environments, but it is not perfect: take reasonable precautions to
protect your machines.
.SS TARPIT
.PP
Captures and holds incoming TCP connections using no local per-connection
resources.
.PP
TARPIT only works at the TCP level, and is totally application agnostic. This
module will answer a TCP request and play along like a listening server, but
aside from sending an ACK or RST, no data is sent. Incoming packets are ignored
and dropped. The attacker will terminate the session eventually. This module
allows the initial packets of an attack to be captured by other software for
inspection. In most cases this is sufficient to determine the nature of the
attack.
.PP
This offers similar functionality to LaBrea
<https://labrea.sourceforge.io/> but does not require dedicated hardware or
IPs. Any TCP port that you would normally DROP or REJECT can instead become a
tarpit.
.TP
\fB\-\-tarpit\fP
This mode completes a connection with the attacker but limits the window size
to 0, thus keeping the attacker waiting long periods of time. While he is
maintaining state of the connection and trying to continue every 60-240
seconds, we keep none, so it is very lightweight. Attempts to close the
connection are ignored, forcing the remote side to time out the connection in
12-24 minutes. This mode is the default.
.TP
\fB\-\-honeypot\fP
This mode completes a connection with the attacker, but signals a normal window
size, so that the remote side will attempt to send data, often with some very
nasty exploit attempts. We can capture these packets for decoding and further
analysis. The module does not send any data, so if the remote expects an
application level response, the game is up.
.TP
\fB\-\-reset\fP
This mode is handy because we can send an inline RST (reset). It has no other
function.
.PP
To tarpit connections to TCP port 80 destined for the current machine:
.IP
\-A INPUT \-p tcp \-m tcp \-\-dport 80 \-j TARPIT
.PP
To significantly slow down Code Red/Nimda-style scans of unused address space,
forward unused ip addresses to a Linux box not acting as a router (e.g. "ip
route 10.0.0.0 255.0.0.0 ip.of.linux.box" on a Cisco), enable IP forwarding on
the Linux box, and add:
.IP
\-A FORWARD \-p tcp \-j TARPIT
.IP
\-A FORWARD \-j DROP
.PP
NOTE:
If you use the conntrack module while you are using TARPIT, you should also use
unset tracking on the packet, or the kernel will unnecessarily allocate
resources for each TARPITted connection. To TARPIT incoming connections to the
standard IRC port while using conntrack, you could:
.IP
\-t raw \-A PREROUTING \-p tcp \-\-dport 6667 \-j CT \-\-notrack
.IP
\-A INPUT \-p tcp \-\-dport 6667 \-j NFLOG
.IP
\-A INPUT \-p tcp \-\-dport 6667 \-j TARPIT
