"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkMailSendLimit = void 0;
const rate_limiter_flexible_1 = require("rate-limiter-flexible");
const globalMailSendLimitMinute = new rate_limiter_flexible_1.RateLimiterMemory({
    keyPrefix: 'timelimit:sendmail-auth:global:minute',
    points: 100,
    duration: 60 // 1 minute
});
const globalMailSendLimitHour = new rate_limiter_flexible_1.RateLimiterMemory({
    keyPrefix: 'timelimit:sendmail-auth:global:hour',
    points: 500,
    duration: 60 * 60 // 1 hour
});
const gloablMailSendLimitDay = new rate_limiter_flexible_1.RateLimiterMemory({
    keyPrefix: 'timelimit:sendmail-auth:global:day',
    points: 1000,
    duration: 60 * 60 * 24 // 1 day
});
const checkGlobalMailSendLimit = async () => {
    await globalMailSendLimitMinute.consume('global');
    await globalMailSendLimitHour.consume('global');
    await gloablMailSendLimitDay.consume('global');
};
const individualMailLimitFiveMinutes = new rate_limiter_flexible_1.RateLimiterMemory({
    keyPrefix: 'timelimit:sendmail-auth:individual:5minutes',
    points: 2,
    duration: 60 * 5 // 5 minutes
});
const individualMailLimitDay = new rate_limiter_flexible_1.RateLimiterMemory({
    keyPrefix: 'timelimit:sendmail-auth:individual:day',
    points: 6,
    duration: 60 * 60 * 24 // 1 day
});
const checkIndividualMailSendLimit = async (receiver) => {
    await individualMailLimitFiveMinutes.consume(receiver);
    await individualMailLimitDay.consume(receiver);
};
const checkMailSendLimit = async (receiver) => {
    await checkIndividualMailSendLimit(receiver);
    await checkGlobalMailSendLimit();
};
exports.checkMailSendLimit = checkMailSendLimit;
//# sourceMappingURL=ratelimit-authmail.js.map