"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.InMemoryEventHandler = void 0;
class InMemoryEventHandler {
    constructor() {
        this.counters = new Map();
        this.maxValues = new Map();
    }
    countEvent(name) {
        this.counters.set(name, (this.counters.get(name) || 0) + 1);
    }
    reportMax(name, value) {
        this.maxValues.set(name, Math.max((this.maxValues.get(name) || 0), value));
    }
    async getValues() {
        return {
            counters: this.buildObject(this.counters),
            maxValues: this.buildObject(this.maxValues)
        };
    }
    async reset() {
        this.counters.clear();
        this.maxValues.clear();
    }
    buildObject(map) {
        const result = {};
        const keys = [];
        map.forEach((_, key) => keys.push(key));
        keys.sort().forEach((key) => {
            const value = map.get(key);
            if (value !== undefined) {
                result[key] = value;
            }
        });
        return result;
    }
}
exports.InMemoryEventHandler = InMemoryEventHandler;
//# sourceMappingURL=inmemoryeventhandler.js.map