"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IncompleteAppActivityItemException = exports.RemovedAppActivityItem = exports.AppActivityItem = void 0;
class AppActivityItem {
    constructor({ packageName, activityName, title }) {
        this.serialize = () => ({
            p: this.packageName,
            c: this.activityName,
            t: this.title
        });
        if ((!packageName) || (!activityName)) {
            throw new IncompleteAppActivityItemException('incomplete app activity');
        }
        this.packageName = packageName;
        this.activityName = activityName;
        this.title = title;
    }
}
exports.AppActivityItem = AppActivityItem;
AppActivityItem.parse = ({ p, c, t }) => (new AppActivityItem({
    packageName: p,
    activityName: c,
    title: t
}));
class RemovedAppActivityItem {
    constructor({ packageName, activityName }) {
        this.serialize = () => ([
            this.packageName,
            this.activityName
        ]);
        if ((!packageName) || (!activityName)) {
            throw new IncompleteAppActivityItemException('incomplete app activity');
        }
        this.packageName = packageName;
        this.activityName = activityName;
    }
}
exports.RemovedAppActivityItem = RemovedAppActivityItem;
RemovedAppActivityItem.parse = (data) => (new RemovedAppActivityItem({
    packageName: data[0],
    activityName: data[1]
}));
class IncompleteAppActivityItemException extends Error {
}
exports.IncompleteAppActivityItemException = IncompleteAppActivityItemException;
//# sourceMappingURL=appactivity.js.map