"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.sendTaskDoneMails = void 0;
const user_1 = require("../../database/user");
const mail_1 = require("../../util/mail");
const ratelimit_taskdonemail_1 = require("../../util/ratelimit-taskdonemail");
const sendTaskDoneMails = async ({ database, familyId, childName, taskTitle, transaction }) => {
    const parentEntries = await database.user.findAll({
        where: {
            familyId,
            type: 'parent'
        },
        transaction
    });
    const targetMailAddresses = parentEntries
        .filter((item) => item.mail !== '')
        .filter((item) => (item.mailNotificationFlags & user_1.mailNotificationFlags.tasks) === user_1.mailNotificationFlags.tasks)
        .map((item) => item.mail);
    transaction.afterCommit(async () => {
        await Promise.all(targetMailAddresses.map(async (receiver) => {
            if (await (0, ratelimit_taskdonemail_1.canSendTaskDoneMail)(receiver)) {
                await (0, mail_1.sendTaskDoneMail)({ receiver, child: childName, task: taskTitle });
            }
        }));
    });
};
exports.sendTaskDoneMails = sendTaskDoneMails;
//# sourceMappingURL=taskdone.js.map