"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUsedTimes = getUsedTimes;
const Sequelize = require("sequelize");
const minuteofday_1 = require("../../../../util/minuteofday");
async function getUsedTimes({ database, transaction, categoryIdsToSyncUsedTimes, familyEntry, serverCategoriesVersions, clientLevel }) {
    const usedTimesForSyncing = (await database.usedTime.findAll({
        where: Object.assign({ familyId: familyEntry.familyId, categoryId: {
                [Sequelize.Op.in]: categoryIdsToSyncUsedTimes
            } }, (clientLevel === null || clientLevel < 2) ? {
            startMinuteOfDay: minuteofday_1.MinuteOfDay.MIN,
            endMinuteOfDay: minuteofday_1.MinuteOfDay.MAX
        } : {}),
        attributes: [
            'categoryId', 'dayOfEpoch', 'usedTime', 'startMinuteOfDay', 'endMinuteOfDay'
        ],
        transaction
    })).map((item) => ({
        categoryId: item.categoryId,
        dayOfEpoch: item.dayOfEpoch,
        usedTime: item.usedTime,
        startMinuteOfDay: item.startMinuteOfDay,
        endMinuteOfDay: item.endMinuteOfDay
    }));
    const sessionDurationsForSyncing = (await database.sessionDuration.findAll({
        where: {
            familyId: familyEntry.familyId,
            categoryId: {
                [Sequelize.Op.in]: categoryIdsToSyncUsedTimes
            }
        },
        attributes: [
            'categoryId',
            'maxSessionDuration',
            'sessionPauseDuration',
            'startMinuteOfDay',
            'endMinuteOfDay',
            'lastUsage',
            'lastSessionDuration'
        ],
        transaction
    })).map((item) => ({
        categoryId: item.categoryId,
        maxSessionDuration: item.maxSessionDuration,
        sessionPauseDuration: item.sessionPauseDuration,
        startMinuteOfDay: item.startMinuteOfDay,
        endMinuteOfDay: item.endMinuteOfDay,
        lastUsage: item.lastUsage,
        lastSessionDuration: item.lastSessionDuration
    }));
    const getCategoryUsedTimesVersion = (categoryId) => (serverCategoriesVersions.requireByCategoryId(categoryId).usedTimesVersion);
    return categoryIdsToSyncUsedTimes.map((categoryId) => ({
        categoryId,
        times: usedTimesForSyncing.filter((item) => item.categoryId === categoryId).map((item) => ({
            day: item.dayOfEpoch,
            time: item.usedTime,
            start: item.startMinuteOfDay,
            end: item.endMinuteOfDay
        })),
        sessionDurations: sessionDurationsForSyncing.filter((item) => item.categoryId === categoryId).map((item) => ({
            md: item.maxSessionDuration,
            spd: item.sessionPauseDuration,
            sm: item.startMinuteOfDay,
            em: item.endMinuteOfDay,
            l: parseInt(item.lastUsage, 10),
            d: item.lastSessionDuration
        })),
        version: getCategoryUsedTimesVersion(categoryId)
    }));
}
//# sourceMappingURL=used-times.js.map