"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseEncodedAction = parseEncodedAction;
const exception_1 = require("../../../action/meta/exception");
const invalidaction_1 = require("./exception/invalidaction");
function parseEncodedAction(action) {
    try {
        const result = JSON.parse(action.encodedAction);
        if (typeof result !== 'object')
            throw new invalidaction_1.BadEncodedActionJsonException();
        return result;
    }
    catch (ex) {
        if (ex instanceof SyntaxError) {
            throw new invalidaction_1.BadEncodedActionJsonException();
        }
        else if (ex instanceof exception_1.InvalidActionParameterException) {
            throw new invalidaction_1.InvalidActionParamterException(ex);
        }
        else
            throw ex;
    }
}
//# sourceMappingURL=parse-encoded-action.js.map