"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.CanNotRelaxRestrictionsSelfLimitException = exports.SelfLimitNotPossibleException = exports.ActionNotSupportedBySelfLimitationException = exports.CanNotModifyOtherUsersBySelfLimitationException = exports.SelfLimitationException = void 0;
const index_1 = require("./index");
class SelfLimitationException extends index_1.ApplyActionException {
}
exports.SelfLimitationException = SelfLimitationException;
class CanNotModifyOtherUsersBySelfLimitationException extends SelfLimitationException {
    constructor() {
        super({ staticMessage: 'can not modify other users with the self limitation' });
    }
}
exports.CanNotModifyOtherUsersBySelfLimitationException = CanNotModifyOtherUsersBySelfLimitationException;
class ActionNotSupportedBySelfLimitationException extends SelfLimitationException {
    constructor() {
        super({ staticMessage: 'can not dispatch this action with the self limitation' });
    }
}
exports.ActionNotSupportedBySelfLimitationException = ActionNotSupportedBySelfLimitationException;
class SelfLimitNotPossibleException extends SelfLimitationException {
}
exports.SelfLimitNotPossibleException = SelfLimitNotPossibleException;
class CanNotRelaxRestrictionsSelfLimitException extends SelfLimitationException {
    constructor() {
        super({ staticMessage: 'can not relax restrictions with the self limitation' });
    }
}
exports.CanNotRelaxRestrictionsSelfLimitException = CanNotRelaxRestrictionsSelfLimitException;
//# sourceMappingURL=self-limit.js.map