"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.EncodedActionSchemaMismatchException = exports.BadEncodedActionContentException = exports.BadEncodedActionJsonException = exports.InvalidActionParamterException = exports.InvalidActionException = void 0;
const index_1 = require("./index");
class InvalidActionException extends index_1.ApplyActionException {
}
exports.InvalidActionException = InvalidActionException;
class InvalidActionParamterException extends InvalidActionException {
    constructor(cause) {
        super({
            staticMessage: cause.staticMessage,
            dynamicMessage: cause.dynamicMessage
        });
    }
}
exports.InvalidActionParamterException = InvalidActionParamterException;
class BadEncodedActionJsonException extends InvalidActionException {
    constructor() { super({ staticMessage: 'bad encoded action JSON' }); }
}
exports.BadEncodedActionJsonException = BadEncodedActionJsonException;
class BadEncodedActionContentException extends InvalidActionException {
}
exports.BadEncodedActionContentException = BadEncodedActionContentException;
class EncodedActionSchemaMismatchException extends BadEncodedActionContentException {
    constructor({ type, action }) {
        super({
            staticMessage: 'encoded ' + type + ' action does not match schema',
            dynamicMessage: 'encoded action does not match schema: ' + JSON.stringify(action)
        });
        this.action = action;
    }
}
exports.EncodedActionSchemaMismatchException = EncodedActionSchemaMismatchException;
//# sourceMappingURL=invalidaction.js.map