"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidChildActionIntegrityValue = exports.InvalidU2fIntegrityValue = exports.InvalidParentActionIntegrityValue = exports.ParentDeviceActionWithoutParentDeviceException = exports.ApplyActionIntegrityException = void 0;
const index_1 = require("./index");
class ApplyActionIntegrityException extends index_1.ApplyActionException {
}
exports.ApplyActionIntegrityException = ApplyActionIntegrityException;
class ParentDeviceActionWithoutParentDeviceException extends ApplyActionIntegrityException {
    constructor() { super({ staticMessage: 'parent device action but no parent device' }); }
}
exports.ParentDeviceActionWithoutParentDeviceException = ParentDeviceActionWithoutParentDeviceException;
class InvalidParentActionIntegrityValue extends ApplyActionIntegrityException {
    constructor() { super({ staticMessage: 'invalid parent action integrity value' }); }
}
exports.InvalidParentActionIntegrityValue = InvalidParentActionIntegrityValue;
class InvalidU2fIntegrityValue extends ApplyActionIntegrityException {
    constructor(message) { super({ staticMessage: 'invalid parent action u2f integrity value: ' + message }); }
}
exports.InvalidU2fIntegrityValue = InvalidU2fIntegrityValue;
class InvalidChildActionIntegrityValue extends ApplyActionIntegrityException {
    constructor() { super({ staticMessage: 'invalid child action integrity value' }); }
}
exports.InvalidChildActionIntegrityValue = InvalidChildActionIntegrityValue;
//# sourceMappingURL=integrity.js.map