"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2020 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionObjectTypeNotHandledException = exports.SourceFamilyNotFoundException = exports.SourceUserNotFoundException = exports.SourceDeviceNotFoundException = exports.IllegalStateException = void 0;
const index_1 = require("./index");
class IllegalStateException extends index_1.ApplyActionException {
    constructor({ staticMessage }) {
        super({ staticMessage });
    }
}
exports.IllegalStateException = IllegalStateException;
class SourceDeviceNotFoundException extends IllegalStateException {
    constructor() {
        super({ staticMessage: 'source device not found' });
    }
}
exports.SourceDeviceNotFoundException = SourceDeviceNotFoundException;
class SourceUserNotFoundException extends IllegalStateException {
    constructor() {
        super({ staticMessage: 'source user not found' });
    }
}
exports.SourceUserNotFoundException = SourceUserNotFoundException;
class SourceFamilyNotFoundException extends IllegalStateException {
    constructor() {
        super({ staticMessage: 'family entry not found' });
    }
}
exports.SourceFamilyNotFoundException = SourceFamilyNotFoundException;
class ActionObjectTypeNotHandledException extends IllegalStateException {
    constructor() {
        super({ staticMessage: 'action object type not handled' });
    }
}
exports.ActionObjectTypeNotHandledException = ActionObjectTypeNotHandledException;
//# sourceMappingURL=illegal-state.js.map