"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchUpdateUserFlagsAction = dispatchUpdateUserFlagsAction;
const illegal_state_1 = require("../exception/illegal-state");
const missing_item_1 = require("../exception/missing-item");
async function dispatchUpdateUserFlagsAction({ action, cache }) {
    const userEntry = await cache.database.user.findOne({
        where: {
            familyId: cache.familyId,
            userId: action.userId
        },
        transaction: cache.transaction
    });
    if (!userEntry) {
        throw new missing_item_1.MissingUserException();
    }
    const oldFlags = parseInt(userEntry.flags, 10);
    if (!Number.isSafeInteger(oldFlags)) {
        throw new illegal_state_1.IllegalStateException({ staticMessage: 'oldFlags is not a safe integer' });
    }
    const newFlags = (oldFlags & ~action.modifiedBits) | action.newValues;
    userEntry.flags = newFlags.toString(10);
    await userEntry.save({ transaction: cache.transaction });
    cache.invalidiateUserList = true;
    cache.incrementTriggeredSyncLevel(1);
}
//# sourceMappingURL=updateuserflags.js.map