"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchUpdateChildTaskAction = dispatchUpdateChildTaskAction;
const illegal_state_1 = require("../exception/illegal-state");
const missing_item_1 = require("../exception/missing-item");
async function dispatchUpdateChildTaskAction({ action, cache }) {
    const categoryInfoUnsafe = await cache.database.category.findOne({
        where: {
            familyId: cache.familyId,
            categoryId: action.categoryId
        },
        attributes: ['childId'],
        transaction: cache.transaction
    });
    if (categoryInfoUnsafe === null)
        throw new missing_item_1.MissingCategoryException();
    const taskInfo = await cache.database.childTask.findOne({
        where: {
            familyId: cache.familyId,
            taskId: action.taskId
        },
        transaction: cache.transaction
    });
    const notFound = taskInfo === null;
    if (notFound !== action.isNew) {
        if (action.isNew) {
            throw new illegal_state_1.IllegalStateException({
                staticMessage: 'can not create task which exists already'
            });
        }
        else {
            throw new missing_item_1.MissingTaskException();
        }
    }
    if (taskInfo === null) {
        await cache.database.childTask.create({
            familyId: cache.familyId,
            taskId: action.taskId,
            categoryId: action.categoryId,
            taskTitle: action.taskTitle,
            extraTimeDuration: action.extraTimeDuration,
            pendingRequest: 0,
            lastGrantTimestamp: '0'
        }, {
            transaction: cache.transaction
        });
        cache.categoriesWithModifiedTasks.add(action.categoryId);
    }
    else {
        await cache.database.childTask.update({
            taskTitle: action.taskTitle,
            categoryId: action.categoryId,
            extraTimeDuration: action.extraTimeDuration
        }, {
            where: {
                familyId: cache.familyId,
                taskId: action.taskId
            },
            transaction: cache.transaction
        });
        cache.categoriesWithModifiedTasks.add(taskInfo.categoryId);
        cache.categoriesWithModifiedTasks.add(action.categoryId);
        cache.incrementTriggeredSyncLevel(1);
    }
}
//# sourceMappingURL=updatechildtaskaction.js.map