"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchUpdateCategoryTemporarilyBlocked = dispatchUpdateCategoryTemporarilyBlocked;
const missing_item_1 = require("../exception/missing-item");
const premium_1 = require("../exception/premium");
const self_limit_1 = require("../exception/self-limit");
async function dispatchUpdateCategoryTemporarilyBlocked({ action, cache, fromChildSelfLimitAddChildUserId }) {
    var _a;
    if (action.blocked === true) {
        if (!cache.hasFullVersion) {
            throw new premium_1.PremiumVersionMissingException();
        }
    }
    const categoryEntryUnsafe = await cache.database.category.findOne({
        where: {
            familyId: cache.familyId,
            categoryId: action.categoryId
        },
        transaction: cache.transaction,
        attributes: ['childId', 'temporarilyBlocked', 'temporarilyBlockedEndTime']
    });
    if (!categoryEntryUnsafe) {
        throw new missing_item_1.MissingCategoryException();
    }
    const categoryEntry = {
        childId: categoryEntryUnsafe.childId,
        temporarilyBlocked: categoryEntryUnsafe.temporarilyBlocked,
        temporarilyBlockedEndTime: parseInt(categoryEntryUnsafe.temporarilyBlockedEndTime, 10)
    };
    if (fromChildSelfLimitAddChildUserId !== null) {
        if (fromChildSelfLimitAddChildUserId !== categoryEntry.childId) {
            throw new self_limit_1.CanNotModifyOtherUsersBySelfLimitationException();
        }
        if (action.endTime === undefined || !action.blocked) {
            throw new self_limit_1.SelfLimitationException({ staticMessage: 'the child may only enable a temporarily blocking' });
        }
        if (categoryEntry.temporarilyBlocked) {
            if (action.endTime < categoryEntry.temporarilyBlockedEndTime || categoryEntry.temporarilyBlockedEndTime === 0) {
                throw new self_limit_1.SelfLimitationException({ staticMessage: 'the child may not reduce the temporarily blocking' });
            }
        }
    }
    const [affectedRows] = await cache.database.category.update({
        temporarilyBlocked: action.blocked,
        temporarilyBlockedEndTime: action.blocked ? ((_a = action.endTime) !== null && _a !== void 0 ? _a : 0).toString(10) : '0'
    }, {
        where: {
            familyId: cache.familyId,
            categoryId: action.categoryId
        },
        transaction: cache.transaction
    });
    if (affectedRows !== 0) {
        cache.categoriesWithModifiedBaseData.add(action.categoryId);
        cache.incrementTriggeredSyncLevel(2);
    }
}
//# sourceMappingURL=updatecategorytemporarilyblocked.js.map