"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchSetKeepSignedIn = dispatchSetKeepSignedIn;
const illegal_state_1 = require("../exception/illegal-state");
const index_1 = require("../exception/index");
const missing_item_1 = require("../exception/missing-item");
async function dispatchSetKeepSignedIn({ action, cache, parentUserId }) {
    const doesUserExist = await cache.doesUserExist(parentUserId);
    if (!doesUserExist) {
        throw new illegal_state_1.SourceUserNotFoundException();
    }
    const deviceEntry = await cache.database.device.findOne({
        where: {
            familyId: cache.familyId,
            deviceId: action.deviceId
        },
        transaction: cache.transaction
    });
    if (!deviceEntry) {
        throw new missing_item_1.MissingDeviceException();
    }
    if (deviceEntry.currentUserId !== parentUserId) {
        if (action.keepSignedIn) {
            throw new index_1.ApplyActionException({ staticMessage: 'only the user itself can disable asking for the password' });
        }
    }
    const [affectedRows] = await cache.database.device.update({
        isUserKeptSignedIn: action.keepSignedIn
    }, {
        where: {
            familyId: cache.familyId,
            deviceId: action.deviceId,
            currentUserId: deviceEntry.currentUserId
        },
        transaction: cache.transaction
    });
    if (affectedRows !== 0) {
        cache.invalidiateDeviceList = true;
        cache.incrementTriggeredSyncLevel(1);
        cache.incrementTargetedTriggeredSyncLevel(action.deviceId, 2);
    }
}
//# sourceMappingURL=setkeepsignedin.js.map