"use strict";
/*
 * server component for the TimeLimit App
 * Copyright (C) 2019 - 2022 Jonas Lochmann
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispatchSetDeviceUser = dispatchSetDeviceUser;
const missing_item_1 = require("../exception/missing-item");
async function dispatchSetDeviceUser({ action, cache }) {
    if (action.userId !== '') {
        const doesUserExist = await cache.doesUserExist(action.userId);
        if (!doesUserExist) {
            throw new missing_item_1.MissingUserException();
        }
    }
    const oldDeviceItem = await cache.database.device.findOne({
        where: {
            familyId: cache.familyId,
            deviceId: action.deviceId
        },
        transaction: cache.transaction
    });
    if (!oldDeviceItem) {
        throw new missing_item_1.MissingDeviceException();
    }
    await cache.database.device.update({
        currentUserId: action.userId,
        isUserKeptSignedIn: false
    }, {
        where: {
            familyId: cache.familyId,
            deviceId: action.deviceId
        },
        transaction: cache.transaction
    });
    cache.invalidiateDeviceList = true;
    cache.incrementTriggeredSyncLevel(1);
    cache.incrementTargetedTriggeredSyncLevel(action.deviceId, 2);
}
//# sourceMappingURL=setdeviceuser.js.map